/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.directory;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.biojava.directory.OBDARegistryParser;
import org.biojava.directory.Registry;
import org.biojava.directory.RegistryConfiguration;

public class SystemRegistry {
    private static Registry systemRegistry;

    public static Registry instance() {
        if (systemRegistry == null) {
            RegistryConfiguration.Composite regConfig = new RegistryConfiguration.Composite();
            Iterator i = SystemRegistry.getRegistryPath().iterator();
            while (i.hasNext()) {
                try {
                    String locator = (String)i.next();
                    BufferedReader stream = new BufferedReader(new InputStreamReader(new URL(locator).openStream()));
                    if (stream == null) continue;
                    try {
                        RegistryConfiguration cfg = OBDARegistryParser.parseRegistry(stream, locator);
                        regConfig.addBottomConfig(cfg);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            systemRegistry = new Registry(regConfig);
        }
        return systemRegistry;
    }

    public static List getRegistryPath() {
        ArrayList<String> registryPath = new ArrayList<String>();
        String userHome = System.getProperty("user.home");
        if (userHome != null) {
            registryPath.add("file:///" + userHome + "/.bioinformatics/seqdatabase.ini");
        }
        registryPath.add("file:///etc/bioinformatics/seqdatabase.ini");
        registryPath.add("http://www.open-bio.net/bioinformatics/seqdatabase.ini");
        return registryPath;
    }
}

