/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class JDBCConnectionPool {
    private final String dbURL;
    private final String dbUser;
    private final String dbPass;
    private List connectionPool = new ArrayList();

    public JDBCConnectionPool(String url, String user, String pass) {
        this.dbURL = url;
        this.dbUser = user;
        this.dbPass = pass;
    }

    public JDBCConnectionPool(String url) {
        this(url, null, null);
    }

    public Connection takeConnection() throws SQLException {
        Connection conn = null;
        List list = this.connectionPool;
        synchronized (list) {
            if (this.connectionPool.size() > 0) {
                conn = (Connection)this.connectionPool.remove(0);
            }
        }
        if (conn != null) {
            if (!conn.isClosed()) {
                return conn;
            }
            return this.takeConnection();
        }
        conn = this.dbUser != null ? DriverManager.getConnection(this.dbURL, this.dbUser, this.dbPass) : DriverManager.getConnection(this.dbURL);
        Statement st = conn.createStatement();
        st.close();
        return conn;
    }

    public void putConnection(Connection c) throws SQLException {
        List list = this.connectionPool;
        synchronized (list) {
            this.connectionPool.add(c);
        }
    }

    public Statement takeStatement() throws SQLException {
        return this.takeConnection().createStatement();
    }

    public void putStatement(Statement st) throws SQLException {
        this.putConnection(st.getConnection());
        st.close();
    }
}

