/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils;

import java.util.LinkedList;
import org.biojava.utils.ThreadPool;

public class SimpleThreadPool
implements ThreadPool {
    protected PooledThread[] threads;
    protected int priority;
    private LinkedList queue;
    private boolean daemon;
    private boolean waiting;
    private boolean stopped;

    public SimpleThreadPool() {
        this(4, false);
    }

    public SimpleThreadPool(int threadCount, boolean daemon) {
        this(threadCount, daemon, 5);
    }

    public SimpleThreadPool(int threadCount, boolean daemon, int priority) {
        this.daemon = daemon;
        this.priority = priority;
        this.queue = new LinkedList();
        this.threads = new PooledThread[threadCount];
        this.stopped = true;
        this.waiting = false;
        this.startThreads();
    }

    public void addRequest(Runnable task) {
        if (this.waiting || this.stopped) {
            throw new IllegalStateException("Thread pool has been closed to new requests");
        }
        LinkedList linkedList = this.queue;
        synchronized (linkedList) {
            this.queue.add(task);
            this.queue.notifyAll();
        }
    }

    public void startThreads() {
        if (!this.stopped) {
            throw new IllegalStateException("Thread pool is already started");
        }
        this.stopped = false;
        PooledThread[] pooledThreadArray = this.threads;
        synchronized (pooledThreadArray) {
            int i = 0;
            while (i < this.threads.length) {
                this.threads[i] = new PooledThread();
                if (this.daemon) {
                    this.threads[i].setDaemon(true);
                }
                this.threads[i].setPriority(this.priority);
                this.threads[i].start();
                ++i;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stopThreads() {
        if (this.stopped) {
            throw new IllegalStateException("Thread pool has already been stopped");
        }
        this.stopped = true;
        LinkedList linkedList = this.queue;
        synchronized (linkedList) {
            while (this.threadsAlive() > 0) {
                try {
                    this.queue.wait(500L);
                    this.queue.notifyAll();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void waitForThreads() {
        if (this.stopped) {
            throw new IllegalStateException("Thread pool has been stopped");
        }
        this.waiting = true;
        PooledThread[] pooledThreadArray = this.threads;
        synchronized (pooledThreadArray) {
            while (!this.queue.isEmpty() || this.threadsWorking() > 0) {
                try {
                    this.threads.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.waiting = false;
    }

    public int threadsWorking() {
        int workingCount = 0;
        PooledThread[] pooledThreadArray = this.threads;
        synchronized (pooledThreadArray) {
            int i = 0;
            while (i < this.threads.length) {
                if (this.threads[i].working) {
                    ++workingCount;
                }
                ++i;
            }
        }
        return workingCount;
    }

    public int threadsIdle() {
        return this.threads.length - this.threadsWorking();
    }

    public int requestsQueued() {
        return this.queue.size();
    }

    protected int threadsAlive() {
        int aliveCount = 0;
        PooledThread[] pooledThreadArray = this.threads;
        synchronized (pooledThreadArray) {
            int i = 0;
            while (i < this.threads.length) {
                if (this.threads[i].isAlive()) {
                    ++aliveCount;
                }
                ++i;
            }
        }
        return aliveCount;
    }

    protected Runnable nextRequest() {
        LinkedList linkedList = this.queue;
        synchronized (linkedList) {
            try {
                while (!this.stopped && this.queue.isEmpty()) {
                    this.queue.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.stopped) {
                Runnable runnable = null;
                return runnable;
            }
            Runnable runnable = (Runnable)this.queue.removeFirst();
            return runnable;
        }
    }

    private class PooledThread
    extends Thread {
        boolean working = false;

        private PooledThread() {
        }

        public void run() {
            Runnable task;
            while ((task = SimpleThreadPool.this.nextRequest()) != null) {
                PooledThread[] pooledThreadArray = SimpleThreadPool.this.threads;
                synchronized (pooledThreadArray) {
                    this.working = true;
                }
                task.run();
                PooledThread[] pooledThreadArray2 = SimpleThreadPool.this.threads;
                synchronized (pooledThreadArray2) {
                    this.working = false;
                    SimpleThreadPool.this.threads.notify();
                }
            }
        }
    }
}

