/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class SmallMap
extends AbstractMap
implements Serializable {
    private Object[] mappings;
    private int numMappings = 0;

    public SmallMap() {
        this(5);
    }

    public SmallMap(int size) {
        this.mappings = new Object[size * 2];
    }

    public SmallMap(Map m) {
        this(m.size());
        Iterator i = m.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry me = i.next();
            this.put(me.getKey(), me.getValue());
        }
    }

    public Object get(Object key) {
        int keyHash = key.hashCode();
        int i = 0;
        while (i < this.numMappings * 2) {
            if (keyHash == this.mappings[i].hashCode() && key.equals(this.mappings[i])) {
                return this.mappings[i + 1];
            }
            i += 2;
        }
        return null;
    }

    public Object put(Object key, Object value) {
        int keyHash = key.hashCode();
        int i = 0;
        while (i < this.numMappings * 2) {
            if (keyHash == this.mappings[i].hashCode() && key.equals(this.mappings[i])) {
                Object oldValue = this.mappings[i + 1];
                this.mappings[i + 1] = value;
                return oldValue;
            }
            i += 2;
        }
        int newPos = this.numMappings * 2;
        if (newPos + 1 >= this.mappings.length) {
            Object[] newMappings = new Object[this.mappings.length + 6];
            System.arraycopy(this.mappings, 0, newMappings, 0, this.mappings.length);
            this.mappings = newMappings;
        }
        this.mappings[newPos] = key;
        this.mappings[newPos + 1] = value;
        ++this.numMappings;
        return null;
    }

    public Set keySet() {
        return new KeySet();
    }

    public Set entrySet() {
        return new EntrySet();
    }

    public int size() {
        return this.numMappings;
    }

    public boolean containsKey(Object key) {
        int keyHash = key.hashCode();
        int i = 0;
        while (i < this.numMappings * 2) {
            if (keyHash == this.mappings[i].hashCode() && key.equals(this.mappings[i])) {
                return true;
            }
            i += 2;
        }
        return false;
    }

    private void removeMapping(int num) {
        if (num < this.numMappings - 1) {
            System.arraycopy(this.mappings, num + 1, this.mappings, num, (this.numMappings - num - 1) * 2);
        }
        --this.numMappings;
    }

    private class MapEntry
    implements Map.Entry {
        private int offset;

        private MapEntry(int offset) {
            this.offset = offset;
        }

        public Object getKey() {
            return SmallMap.this.mappings[this.offset];
        }

        public Object getValue() {
            return SmallMap.this.mappings[this.offset + 1];
        }

        public Object setValue(Object v) {
            Object oldValue = SmallMap.this.mappings[this.offset + 1];
            ((SmallMap)SmallMap.this).mappings[this.offset + 1] = v;
            return oldValue;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object o) {
            boolean bl;
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry mo = (Map.Entry)o;
            if (this.getKey() == null) {
                if (mo.getKey() != null) return false;
                bl = true;
            } else {
                bl = this.getKey().equals(mo.getKey());
            }
            if (!bl) return false;
            if (this.getValue() == null) {
                if (mo.getValue() != null) return false;
                return true;
            }
            boolean bl2 = this.getValue().equals(mo.getValue());
            if (!bl2) return false;
            return true;
        }

        public int hashCode() {
            return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
        }
    }

    private class EntryIterator
    implements Iterator {
        int pos = 0;

        private EntryIterator() {
        }

        public boolean hasNext() {
            return this.pos < SmallMap.this.numMappings;
        }

        public Object next() {
            if (this.pos >= SmallMap.this.numMappings) {
                throw new NoSuchElementException();
            }
            int offset = this.pos * 2;
            ++this.pos;
            return new MapEntry(offset);
        }

        public void remove() {
            SmallMap.this.removeMapping(this.pos);
            --this.pos;
        }
    }

    private class EntrySet
    extends AbstractSet {
        private EntrySet() {
        }

        public Iterator iterator() {
            return new EntryIterator();
        }

        public int size() {
            return SmallMap.this.numMappings;
        }
    }

    private class KeyIterator
    implements Iterator {
        int pos = 0;

        private KeyIterator() {
        }

        public boolean hasNext() {
            return this.pos < SmallMap.this.numMappings;
        }

        public Object next() {
            if (this.pos >= SmallMap.this.numMappings) {
                throw new NoSuchElementException();
            }
            int offset = this.pos * 2;
            ++this.pos;
            return SmallMap.this.mappings[offset];
        }

        public void remove() {
            SmallMap.this.removeMapping(this.pos);
            --this.pos;
        }
    }

    private class KeySet
    extends AbstractSet {
        private KeySet() {
        }

        public Iterator iterator() {
            return new KeyIterator();
        }

        public int size() {
            return SmallMap.this.numMappings;
        }
    }
}

