/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.parser;

import com.ibm.xml.parser.AttDef;
import com.ibm.xml.parser.Child;
import com.ibm.xml.parser.DTD;
import com.ibm.xml.parser.GeneralReference;
import com.ibm.xml.parser.Match;
import com.ibm.xml.parser.NOOPVisitor;
import com.ibm.xml.parser.Namespace;
import com.ibm.xml.parser.NonRecursivePreorderTreeTraversal;
import com.ibm.xml.parser.Parent;
import com.ibm.xml.parser.TXAttribute;
import com.ibm.xml.parser.TXAttributeList;
import com.ibm.xml.parser.TXDOMException;
import com.ibm.xml.parser.TXNodeList;
import com.ibm.xml.parser.TXText;
import com.ibm.xml.parser.Util;
import com.ibm.xml.parser.Visitor;
import java.util.Enumeration;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class TXElement
extends Parent
implements Element,
Namespace {
    public static final String S_XMLNS = "xmlns";
    public static final String S_XMLNAMESPACEURI = "http://www.w3.org/XML/1998/namespace";
    String name;
    TXAttributeList attributes;
    boolean isPreserveSpace = false;

    public TXElement(String string) {
        this.setTagName(string);
    }

    public synchronized Object clone() {
        TXElement tXElement = this.cloneWithoutChildren();
        tXElement.children.ensureCapacity(this.children.getLength());
        int n = 0;
        while (n < this.children.getLength()) {
            tXElement.insertBefore(this.children.item(n).cloneNode(true), null);
            ++n;
        }
        return tXElement;
    }

    public synchronized TXElement cloneWithoutChildren() {
        this.checkFactory();
        TXElement tXElement = (TXElement)this.factory.createElement(this.getTagName());
        tXElement.setFactory(this.getFactory());
        tXElement.setPreserveSpace(this.isPreserveSpace);
        if (this.attributes != null) {
            int n = 0;
            while (n < this.attributes.getLength()) {
                tXElement.setAttributeNode((TXAttribute)this.attributes.item(n).cloneNode(true));
                ++n;
            }
        }
        return tXElement;
    }

    public Node cloneNode(boolean bl) {
        if (bl) {
            return (Node)this.clone();
        }
        return this.cloneWithoutChildren();
    }

    public boolean equals(Node node, boolean bl) {
        if (node == null) {
            return false;
        }
        if (!(node instanceof TXElement)) {
            return false;
        }
        TXElement tXElement = (TXElement)node;
        if (!tXElement.getTagName().equals(this.getTagName())) {
            return false;
        }
        NamedNodeMap namedNodeMap = tXElement.getAttributes();
        NamedNodeMap namedNodeMap2 = this.getAttributes();
        if (namedNodeMap.getLength() != namedNodeMap2.getLength()) {
            return false;
        }
        int n = 0;
        while (n < namedNodeMap.getLength()) {
            Attr attr = (Attr)namedNodeMap.item(n);
            Attr attr2 = (Attr)namedNodeMap2.getNamedItem(attr.getName());
            if (attr2 == null || !((Child)((Object)attr)).equals(attr2, true)) {
                return false;
            }
            ++n;
        }
        return !bl || tXElement.children.equals(this.children, bl);
    }

    public short getNodeType() {
        return 1;
    }

    public String getNodeName() {
        return this.getTagName();
    }

    public String getTagName() {
        return this.name;
    }

    public String getName() {
        return this.getTagName();
    }

    public void setTagName(String string) {
        this.name = string;
        this.clearDigest();
    }

    public String getAttribute(String string) {
        if (this.attributes != null) {
            TXAttribute tXAttribute = (TXAttribute)this.attributes.getNamedItem(string);
            if (tXAttribute == null) {
                return null;
            }
            return tXAttribute.getValue();
        }
        return null;
    }

    public Attr getAttributeNode(String string) {
        if (this.attributes != null) {
            return (Attr)this.attributes.getNamedItem(string);
        }
        return null;
    }

    public void setAttribute(String string, String string2) throws DOMException {
        this.checkFactory();
        Attr attr = this.getAttributeNode(string);
        if (attr == null) {
            attr = this.factory.createAttribute(string);
            this.setAttributeNode(attr);
            attr.setValue(string2);
            return;
        }
        attr.setValue(string2);
        this.clearDigest();
    }

    public void setAttribute(TXAttribute tXAttribute) {
        this.makeAttributeList();
        this.attributes.setNamedItem(tXAttribute);
    }

    public Attr setAttributeNode(Attr attr) {
        this.makeAttributeList();
        return (Attr)this.attributes.setNamedItem(attr);
    }

    public void removeAttribute(String string) {
        if (this.attributes != null) {
            this.attributes.removeNamedItem(string);
        }
        this.resetDefaultAttribute(string);
    }

    public Attr removeAttributeNode(Attr attr) {
        String string;
        Attr attr2 = null;
        if (this.attributes != null && (string = this.getAttribute(attr.getName())) != null && string.equals(attr.getValue())) {
            attr2 = (Attr)this.attributes.removeNamedItem(attr.getName());
        }
        this.resetDefaultAttribute(attr.getName());
        return attr2;
    }

    protected void resetDefaultAttribute(String string) {
        DTD dTD = (DTD)this.getOwnerDocument().getDoctype();
        if (dTD == null) {
            return;
        }
        AttDef attDef = dTD.getAttributeDeclaration(this.getNodeName(), string);
        if (attDef == null) {
            return;
        }
        switch (attDef.getDefaultType()) {
            case -1: 
            case 1: {
                this.setAttribute(string, attDef.getDefaultStringValue());
                return;
            }
        }
    }

    public NamedNodeMap getAttributes() {
        this.makeAttributeList();
        return this.attributes;
    }

    public TXAttribute[] getAttributeArray() {
        if (this.attributes == null) {
            return new TXAttribute[0];
        }
        return this.attributes.makeArray();
    }

    public Enumeration attributeElements() {
        this.makeAttributeList();
        return this.attributes.elements();
    }

    public String getNSLocalName() {
        return TXElement.getLocalNameForQName(this.getNodeName());
    }

    public String getNSName() {
        return this.getNamespaceForQName(this.getNodeName());
    }

    public String getUniversalName() {
        String string = this.getNSName();
        if (string == null) {
            return this.getNSLocalName();
        }
        return String.valueOf(string) + ":" + this.getNSLocalName();
    }

    public String createExpandedName() {
        String string = this.getNSName();
        if (string == null || string.length() == 0) {
            return this.getNSLocalName();
        }
        return String.valueOf(string) + this.getFactory().expandedNameSeparator + this.getNSLocalName();
    }

    public boolean isEmpty() {
        return this.children.getLength() == 0;
    }

    public boolean isPreserveSpace() {
        return this.isPreserveSpace;
    }

    public void setPreserveSpace(boolean bl) {
        this.isPreserveSpace = bl;
    }

    public String getLanguage() {
        String string = this.getAttribute("xml:lang");
        if (string != null) {
            return string;
        }
        if (this.parent != null) {
            if (this.parent instanceof TXElement) {
                return ((TXElement)this.parent).getLanguage();
            }
            if (this.parent instanceof GeneralReference) {
                return ((GeneralReference)this.parent).getLanguage();
            }
        }
        return null;
    }

    public void normalize() {
        TXElement.normalize(this, this.isPreserveSpace());
    }

    private static void normalize(Node node, boolean bl) {
        Node node2;
        Node node3 = node.getFirstChild();
        if (node3 == null) {
            return;
        }
        if (node3.getNodeType() == 1) {
            TXElement.normalize(node3, ((TXElement)node3).isPreserveSpace());
        } else if (node3.getNodeType() == 5) {
            TXElement.normalize(node3, bl);
        }
        while ((node2 = node3.getNextSibling()) != null) {
            short s = node2.getNodeType();
            if (s == 3 && node3.getNodeType() == 3) {
                ((Text)node2).setData(String.valueOf(node3.getNodeValue()) + node2.getNodeValue());
                node.removeChild(node3);
                if (!bl && Util.checkAllSpace(node2.getNodeValue())) {
                    Node node4 = node2.getPreviousSibling();
                    Node node5 = node2.getNextSibling();
                    if (!(node4 != null && node4.getNodeType() == 3 || node5 != null && node4.getNodeType() == 3)) {
                        ((TXText)node2).setIsIgnorableWhitespace(true);
                    }
                }
            } else if (s == 1) {
                TXElement.normalize(node2, ((TXElement)node3).isPreserveSpace());
            } else if (s == 5) {
                TXElement.normalize(node2, bl);
            }
            node3 = node2;
        }
    }

    public void addTextElement(TXText tXText) {
        if (tXText == null) {
            return;
        }
        if (tXText instanceof CDATASection) {
            this.appendChild(tXText);
            return;
        }
        Node node = this.getLastChild();
        if (node == null) {
            this.appendChild(tXText);
            return;
        }
        if (node.getNodeType() == 3) {
            ((Text)node).appendData(tXText.getData());
            if (!tXText.getIsIgnorableWhitespace() || !((TXText)node).getIsIgnorableWhitespace()) {
                ((TXText)node).setIsIgnorableWhitespace(false);
            }
            return;
        }
        this.appendChild(tXText);
    }

    public TXElement searchDescendants(String string) {
        return this.searchDescendants(0, null, string);
    }

    public TXElement searchDescendants(int n, String string, String string2) {
        Child child = (Child)this.getFirstChild();
        while (child != null) {
            if (child instanceof TXElement) {
                if (Match.matchName((TXElement)child, n, string, string2)) {
                    return (TXElement)child;
                }
                TXElement tXElement = ((TXElement)child).searchDescendants(n, string, string2);
                if (tXElement != null) {
                    return tXElement;
                }
            }
            child = (Child)child.getNextSibling();
        }
        return null;
    }

    public TXElement getElementNamed(String string) {
        return this.getNthElementNamed(0, 0, null, string);
    }

    public TXElement getElementNamed(String string, String string2) {
        return this.getNthElementNamed(0, 2, string, string2);
    }

    public TXElement getElementNamed(int n, String string, String string2) {
        return this.getNthElementNamed(0, n, string, string2);
    }

    public TXElement getNthElementNamed(int n, String string) {
        return this.getNthElementNamed(n, 0, null, string);
    }

    public TXElement getNthElementNamed(int n, String string, String string2) {
        return this.getNthElementNamed(n, 2, string, string2);
    }

    public TXElement getNthElementNamed(int n, int n2, String string, String string2) {
        Node node = this.getFirstChild();
        while (node != null) {
            TXElement tXElement;
            if (node instanceof TXElement && Match.matchName(tXElement = (TXElement)node, n2, string, string2)) {
                if (n == 0) {
                    return tXElement;
                }
                --n;
            }
            node = node.getNextSibling();
        }
        return null;
    }

    public TXElement[] searchChildrenAll(String string) {
        Vector<Node> vector = new Vector<Node>();
        Node node = this.getFirstChild();
        while (node != null) {
            if (node instanceof Element && Match.matchName((Namespace)((Object)node), 0, null, string)) {
                vector.addElement(node);
            }
            node = node.getNextSibling();
        }
        Object[] objectArray = new TXElement[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public NodeList getElementsByTagName(String string) {
        return new TXNodeList.VectorNodeList(this.realSearchDescendantsAll(0, null, string));
    }

    public TXElement[] searchDescendantsAll(String string) {
        return this.searchDescendantsAll(0, null, string);
    }

    public TXElement[] searchDescendantsAll(int n, String string, String string2) {
        Vector vector = this.realSearchDescendantsAll(n, string, string2);
        Object[] objectArray = new TXElement[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public NodeList getElementsNamed(String string) {
        return this.getElementsNamed(0, null, string);
    }

    public NodeList getElementsNamed(String string, String string2) {
        return this.getElementsNamed(2, string, string2);
    }

    public NodeList getElementsNamed(int n, String string, String string2) {
        Vector<Node> vector = new Vector<Node>();
        Node node = this.getFirstChild();
        while (node != null) {
            if (node instanceof Element && Match.matchName((Namespace)((Object)node), n, string, string2)) {
                vector.addElement(node);
            }
            node = node.getNextSibling();
        }
        return new TXNodeList.VectorNodeList(vector);
    }

    public void acceptPre(Visitor visitor) throws Exception {
        visitor.visitElementPre(this);
    }

    public void acceptPost(Visitor visitor) throws Exception {
        visitor.visitElementPost(this);
    }

    private Vector realSearchDescendantsAll(int n, String string, String string2) {
        Vector vector = new Vector();
        SearchElementVisitor searchElementVisitor = new SearchElementVisitor(vector, n, string, string2);
        try {
            new NonRecursivePreorderTreeTraversal(searchElementVisitor).traverse(this);
        }
        catch (Exception exception) {}
        return vector;
    }

    private void makeAttributeList() {
        if (this.attributes == null) {
            this.checkFactory();
            this.attributes = new TXAttributeList();
            this.attributes.setParent(this);
        }
    }

    protected void checkChildType(Node node) throws DOMException {
        switch (node.getNodeType()) {
            default: {
                throw new TXDOMException(3, "Specified node type (" + node.getNodeType() + ") can't be a child of Element.");
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 23: 
        }
    }

    public String getNamespaceForPrefix(String string) {
        if (string.equals("xml")) {
            return S_XMLNAMESPACEURI;
        }
        if (string.equals(S_XMLNS)) {
            return string;
        }
        String string2 = string.length() == 0 ? S_XMLNS : "xmlns:" + string;
        Node node = this;
        do {
            short s;
            String string3;
            if ((string3 = ((Element)node).getAttribute(string2)) != null) {
                return string3;
            }
            do {
                if ((node = node.getParentNode()) != null) continue;
                if (string2 == S_XMLNS) {
                    return "";
                }
                return null;
            } while ((s = node.getNodeType()) == 5);
            if (s == 1) continue;
            if (string2 == S_XMLNS) {
                return "";
            }
            return null;
        } while (node != null);
        return null;
    }

    public String getNamespaceForQName(String string) {
        int n = string.indexOf(58);
        String string2 = n < 0 ? "" : string.substring(0, n).intern();
        return this.getNamespaceForPrefix(string2);
    }

    public static String getLocalNameForQName(String string) {
        int n = string.indexOf(58);
        if (n < 0) {
            return string;
        }
        return string.substring(n + 1).intern();
    }

    public void collectNamespaceAttributes() {
        this.collectNamespaceAttributes(this.getParentNode());
    }

    /*
     * Unable to fully structure code
     */
    public void collectNamespaceAttributes(Node var1_1) {
        if (this.getFactory().isProcessNamespace()) ** GOTO lbl14
        return;
lbl-1000:
        // 1 sources

        {
            if (var2_2 == 1) {
                var3_3 = var1_1.getAttributes();
                var4_4 = 0;
                while (var4_4 < var3_3.getLength()) {
                    var5_5 = var3_3.item(var4_4);
                    var6_6 = var5_5.getNodeName();
                    if ((var6_6.equals("xmlns") || var6_6.startsWith("xmlns:")) && this.getAttributeNode(var6_6) == null) {
                        this.setAttribute(var6_6, var5_5.getNodeValue());
                    }
                    ++var4_4;
                }
            }
            var1_1 = var1_1.getParentNode();
lbl14:
            // 2 sources

            ** while (var1_1 != null && ((var2_2 = var1_1.getNodeType()) == 1 || var2_2 == 5))
        }
lbl15:
        // 1 sources

    }

    public void removeOverlappedNamespaceAttributes() {
        if (!this.getFactory().isProcessNamespace()) {
            return;
        }
        Vector<String> vector = new Vector<String>();
        NamedNodeMap namedNodeMap = this.getAttributes();
        int n = 0;
        while (n < namedNodeMap.getLength()) {
            Node node = namedNodeMap.item(n);
            String string = node.getNodeName();
            if (string.equals(S_XMLNS) || string.startsWith("xmlns:")) {
                short s;
                Node node2 = this.getParentNode();
                while (node2 != null && ((s = node2.getNodeType()) == 1 || s == 5)) {
                    Element element;
                    String string2;
                    if (s == 1 && (string2 = (element = (Element)node2).getAttribute(string)) != null && string2.equals(node.getNodeValue())) {
                        vector.addElement(string);
                    }
                    node2 = node2.getParentNode();
                }
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < vector.size()) {
            this.removeAttribute((String)vector.elementAt(n2));
            ++n2;
        }
    }

    static class SearchElementVisitor
    extends NOOPVisitor {
        Vector result;
        int matchtype;
        String nsorpre;
        String ename;

        SearchElementVisitor(Vector vector, int n, String string, String string2) {
            this.result = vector;
            this.matchtype = n;
            this.nsorpre = string;
            this.ename = string2;
        }

        public void visitElementPre(TXElement tXElement) throws Exception {
            if (Match.matchName(tXElement, this.matchtype, this.nsorpre, this.ename)) {
                this.result.addElement(tXElement);
            }
        }
    }
}

