/*
 * Decompiled with CFR 0.152.
 */
package trimali;

import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import cern.jet.random.Normal;
import cern.jet.random.Uniform;
import cern.jet.random.engine.RandomEngine;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Random;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.GeneticCodes;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.SymbolList;
import trimali.ListComparator;
import trimali.Model;
import trimali.MyLogFunc;
import trimali.Util;

public class HmmAlgorithms
implements Serializable {
    private static final int MAX_ITERATION = 100;
    private static final double MIN_ERROR = 0.001;
    private static final int MAX_LEN_OBSEQ = 10;
    public static String[] aminoAcids;
    public static final String[] dnasym;
    private static Random rand;
    public double[][] mu;
    public double[][] sigma;
    public double[][] priors;
    public int[] numberCdps;
    private double[][] cumulLengthProbas;
    private int[][] durations;
    public int[] minLength;
    public int[] maxLength;
    public Model lambda;
    private double[][] alpha;
    public double[][][] alphaForMultipleSequences;
    private double[][] alphaBar;
    public double[][][] alphaBarForMultipleSequences;
    private double[][] beta;
    public double[][][] betaForMultipleSequences;
    public double[][] gamma;
    public double[][][] gammaForMultipleSequences;
    public double[][][][] gammaMixtureForMultipleSequences;
    private double obsSeqProba;
    public double[] obsSeqProbaForMultipleSequences;
    public double obsSeqProbaForMultipleSequencesOverall;
    private double[][][] ksi;
    public double[][][][] ksiForMultipleSequences;
    private double[][] delta;
    public double[][][] deltaForMultipleSequences;
    public double[][] decodVar;
    public double[][][] decodVarForMultipleSequences;
    private int[][] psi;
    public int[][][] psiForMultipleSequences;
    public ArrayList[][][][][] psiForMultipleSequencesForProtGeneModels;
    public int[] qstar;
    public int[][] qstarForMultipleSequences;
    public ArrayList[][] qstarForMultipleSequencesForProtGeneModels;
    private double[] scaleFactor;
    public double[][] scaleFactorForMultipleSequences;
    private double[] scaleFactorBar;
    public double[][] scaleFactorBarForMultipleSequences;
    public int len_obseq = 0;
    public ArrayList obSeq;
    public ArrayList obSeqs;
    private transient String file_name = null;
    public double[][][][][] alphaForMultipleSequencesForProtGeneModels;
    public double[][][][][] betaForMultipleSequencesForProtGeneModels;
    public double[][][][][] gammaForMultipleSequencesForProtGeneModels;
    public double[][] a;
    public double[][] b;
    public double[] pi;
    public double[][] logA;
    public double[] logPi;
    public double[][] logObs;
    public double[][][] logObsForMultipleSequences;
    public double[][][] probaObsForMultipleSequences;
    public double[][][][] logObsForMultipleSequencesForProtGeneModels;
    public double[][][][] probaObsForMultipleSequencesForProtGeneModels;
    public double[][] stateConservations;
    public double[] consmu;
    public double[] conssigma;
    private double[] consObs;
    private double[][] consObsLogScores;
    public double totalconservation;
    public boolean conservationMode;
    public boolean hasInhomogeneousLengths = false;
    public int lengthOfAllSequences;

    public HmmAlgorithms() {
    }

    public HmmAlgorithms(Model model) {
        this.lambda = model;
        this.a = model.getA();
        this.b = model.getB();
        this.pi = model.getPi();
        this.logA = model.getLogA();
        this.logPi = model.getLogPi();
        this.consmu = model.getStatesConservationMu();
        this.conssigma = model.getStatesConservationSigma();
        this.stateConservations = model.getStatesConservation();
        this.lambda.num_states = model.getNumStates();
    }

    public HmmAlgorithms(boolean hasContinuousObs, int numStates, int numSymbols, int dimensionOfData, int numGaussianMixtureComponents) {
        Model model = new Model();
        model.hasContinuousObs = hasContinuousObs;
        Random generator = new Random();
        model.a = HmmAlgorithms.normaliseMatrix(HmmAlgorithms.randomizeMatrix(numStates, numStates, generator));
        model.b = HmmAlgorithms.normaliseMatrix(HmmAlgorithms.randomizeMatrix(numStates, numSymbols, generator));
        model.pi = HmmAlgorithms.normaliseVector(HmmAlgorithms.randomizeVector(numStates, generator));
        model.numGaussianMixtureComponents = numGaussianMixtureComponents;
        model.dimensionOfData = dimensionOfData;
        model.GaussianWeights = HmmAlgorithms.normaliseMatrix(HmmAlgorithms.randomizeMatrix(numStates, numGaussianMixtureComponents, generator));
        model.GaussianMu = new double[numStates][numGaussianMixtureComponents][dimensionOfData];
        model.GaussianCova = new double[numStates][numGaussianMixtureComponents][dimensionOfData][dimensionOfData];
        model.num_states = numStates;
        this.lambda = model;
        this.consmu = model.getStatesConservationMu();
        this.conssigma = model.getStatesConservationSigma();
        this.stateConservations = model.getStatesConservation();
    }

    public HmmAlgorithms(Model model, ArrayList obseq, boolean conservationMode, boolean hasInhomogeneousLengths) {
        this.conservationMode = conservationMode;
        this.lambda = model;
        this.lambda.hasInhomogeneousLengths = hasInhomogeneousLengths;
        this.hasInhomogeneousLengths = hasInhomogeneousLengths;
        this.a = model.getA();
        this.b = model.getB();
        this.pi = model.getPi();
        this.obSeq = obseq;
        this.len_obseq = obseq.size();
        this.logA = model.getLogA();
        this.logPi = model.getLogPi();
        this.computeLogObs(this.obSeq);
        this.consmu = model.getStatesConservationMu();
        this.conssigma = model.getStatesConservationSigma();
        this.stateConservations = model.getStatesConservation();
        this.alpha = new double[this.len_obseq][this.getNumStates()];
        this.alphaBar = new double[this.len_obseq][this.getNumStates()];
        this.beta = new double[this.len_obseq][this.getNumStates()];
        this.gamma = new double[this.len_obseq][this.getNumStates()];
        this.ksi = new double[this.len_obseq - 1][this.getNumStates()][this.getNumStates()];
        this.delta = new double[this.len_obseq][this.getNumStates()];
        this.psi = new int[this.len_obseq][this.getNumStates()];
        this.qstar = new int[this.len_obseq];
        if (this.lambda.hasInhomogeneousLengths) {
            this.cumulLengthProbas = Util.normaliseMatrix(model.getLengthProbs());
        }
        this.lambda.num_states = model.getNumStates();
    }

    public void myComputeLogDelta(int t, int i) {
        MyLogFunc myLog = new MyLogFunc();
        if (t > 0) {
            double tmp = 0.0;
            double max = this.delta[t - 1][0] + this.logA[0][i];
            int index = 0;
            for (int j = 0; j < this.lambda.condA[i].length; ++j) {
                int k = this.lambda.condA[i][j];
                tmp = this.delta[t - 1][k] + this.logA[k][i];
                if (!(tmp > max)) continue;
                max = tmp;
                index = k;
            }
            this.delta[t][i] = max + this.logObs[t][i];
            this.psi[t][i] = index;
        } else {
            double[] dArray = this.delta[0];
            int n = i;
            dArray[n] = dArray[n] + (this.logPi[i] + this.logObs[0][i]);
            this.psi[0][i] = 0;
        }
    }

    public double myLogViterbiAlgorithm() {
        if (!this.lambda.isReady) {
            System.err.println("THE MODEL HAS TO BE READY BEFORE YOU USE IT");
            System.exit(1);
        }
        this.delta = new double[this.len_obseq][this.getNumStates()];
        this.psi = new int[this.len_obseq][this.getNumStates()];
        this.qstar = new int[this.len_obseq];
        for (int t = 0; t < this.obSeq.size(); ++t) {
            for (int s = 0; s < this.getNumStates(); ++s) {
                this.myComputeLogDelta(t, s);
            }
        }
        double temp = 0.0;
        double max = this.delta[this.len_obseq - 1][0];
        this.qstar[this.len_obseq - 1] = 0;
        for (int s = 1; s < this.getNumStates(); ++s) {
            temp = this.delta[this.len_obseq - 1][s];
            if (!(temp > max)) continue;
            max = temp;
            this.qstar[this.len_obseq - 1] = s;
        }
        for (int t = this.len_obseq - 2; t >= 0; --t) {
            this.qstar[t] = this.psi[t + 1][this.qstar[t + 1]];
        }
        return max;
    }

    public void myComputeSemiDelta(int t, int i) {
        boolean isInhomogeneous = false;
        Model model = this.lambda;
        int indexTrans = -1;
        int indexhydroSP = -1;
        int indexAnchor = -1;
        for (int r = 0; r < model.getNumStates(); ++r) {
            if ("transmembrane".equals(model.labels[r])) {
                indexTrans = r;
                continue;
            }
            if ("hydro".equals(model.labels[r])) {
                indexhydroSP = r;
                continue;
            }
            if (!"signal-anchor (type 2 transmem)".equals(model.labels[r])) continue;
            indexAnchor = r;
        }
        MyLogFunc myLog = new MyLogFunc();
        if (t > 0) {
            double tmp = 0.0;
            double max = -1.0E17;
            int duration = 0;
            int index = 0;
            double[][] normalisedA = new double[this.getNumStates()][this.getNumStates()];
            for (int j = 0; j < this.lambda.condA[i].length; ++j) {
                int k = this.lambda.condA[i][j];
                isInhomogeneous = this.lambda.getHasInhomLengths()[k];
                if (k != i) {
                    normalisedA[k][i] = isInhomogeneous ? (this.cumulLengthProbas[k][this.durations[t - 1][k]] > 0.99 ? 1.0E-99 : (1.0 - (1.0 - this.cumulLengthProbas[k][this.durations[t - 1][k]]) / (1.0 - this.cumulLengthProbas[k][this.durations[t - 1][k] - 1])) * (this.lambda.getA(k, i) / (1.0 - this.lambda.getA(k, k)))) : this.lambda.getA(k, i);
                    tmp = this.delta[t - 1][k] + myLog.apply(normalisedA[k][i]);
                    if (tmp > max) {
                        max = tmp;
                        index = k;
                        duration = 1;
                    }
                } else if (k == i) {
                    if (isInhomogeneous) {
                        normalisedA[i][i] = (1.0 - this.cumulLengthProbas[i][this.durations[t - 1][i]]) / (1.0 - this.cumulLengthProbas[i][this.durations[t - 1][i] - 1]);
                    } else if (!isInhomogeneous) {
                        normalisedA[i][i] = this.lambda.getA(i, i);
                    }
                    tmp = this.delta[t - 1][i] + myLog.apply(normalisedA[i][i]);
                    if (tmp > max) {
                        max = tmp;
                        index = i;
                        duration = this.durations[t - 1][i] + 1;
                    }
                }
                this.delta[t][i] = max + this.logObs[t][i];
                this.psi[t][i] = index;
                this.durations[t][i] = duration;
            }
        } else if (t == 0) {
            this.delta[0][i] = this.logPi[i] + this.logObs[0][i];
            this.psi[0][i] = 0;
            this.durations[0][i] = 1;
        }
    }

    public double myLogSemiViterbi() {
        this.durations = new int[this.getLenObSeq()][this.getNumStates()];
        for (int t = 0; t < this.obSeq.size(); ++t) {
            for (int s = 0; s < this.getNumStates(); ++s) {
                this.myComputeSemiDelta(t, s);
            }
        }
        double temp = 0.0;
        double max = this.delta[this.len_obseq - 1][0];
        this.qstar[this.len_obseq - 1] = 0;
        for (int s = 1; s < this.getNumStates(); ++s) {
            if (this.lambda.getHasInhomLengths()[s]) {
                double proba = 0.0;
                proba = this.cumulLengthProbas[s][this.durations[this.len_obseq - 1][s]] > 0.99 ? 1.0E-99 : 1.0 - (1.0 - this.cumulLengthProbas[s][this.durations[this.len_obseq - 1][s] + 1]) / (1.0 - this.cumulLengthProbas[s][this.durations[this.len_obseq - 1][s]]);
                temp = this.delta[this.len_obseq - 1][s] + Math.log(proba);
            } else {
                temp = this.delta[this.len_obseq - 1][s] + Math.log(0.0);
            }
            if (!(temp > max)) continue;
            max = temp;
            this.qstar[this.len_obseq - 1] = s;
        }
        for (int t = this.len_obseq - 2; t >= 0; --t) {
            this.qstar[t] = this.psi[t + 1][this.qstar[t + 1]];
        }
        return max;
    }

    public double myLogConsViterbi() {
        this.durations = new int[this.getLenObSeq()][this.getNumStates()];
        for (int t = 0; t < this.obSeq.size(); ++t) {
            for (int s = 0; s < this.getNumStates(); ++s) {
                this.myComputeConsDelta(t, s);
            }
        }
        double temp = 0.0;
        double max = this.delta[this.len_obseq - 1][0];
        this.qstar[this.len_obseq - 1] = 0;
        for (int s = 1; s < this.getNumStates(); ++s) {
            temp = this.delta[this.len_obseq - 1][s];
            if (!(temp > max)) continue;
            max = temp;
            this.qstar[this.len_obseq - 1] = s;
        }
        for (int t = this.len_obseq - 2; t >= 0; --t) {
            this.qstar[t] = this.psi[t + 1][this.qstar[t + 1]];
        }
        return max;
    }

    public void myComputeConsDelta(int t, int i) {
        MyLogFunc myLog = new MyLogFunc();
        if (t > 0) {
            double tmp = 0.0;
            double max = this.delta[t - 1][0] + this.logA[0][i];
            int index = 0;
            for (int j = 0; j < this.lambda.condA[i].length; ++j) {
                int k = this.lambda.condA[i][j];
                tmp = this.delta[t - 1][k] + this.logA[k][i];
                if (!(tmp > max)) continue;
                max = tmp;
                index = k;
            }
            this.delta[t][i] = max + this.logObs[t][i] + this.consObsLogScores[t][i];
            this.psi[t][i] = index;
        } else {
            double[] dArray = this.delta[0];
            int n = i;
            dArray[n] = dArray[n] + (this.logPi[i] + this.logObs[0][i] + this.consObsLogScores[t][i]);
            this.psi[0][i] = 0;
        }
    }

    public double myLogSemiConsViterbi() {
        this.durations = new int[this.getLenObSeq()][this.getNumStates()];
        for (int t = 0; t < this.obSeq.size(); ++t) {
            for (int s = 0; s < this.getNumStates(); ++s) {
                this.myComputeSemiConsDelta(t, s);
            }
        }
        double temp = 0.0;
        double max = this.delta[this.len_obseq - 1][0];
        this.qstar[this.len_obseq - 1] = 0;
        for (int s = 1; s < this.getNumStates(); ++s) {
            temp = this.lambda.getHasInhomLengths()[s] ? this.delta[this.len_obseq - 1][s] + Math.log(1.0 - (1.0 - this.cumulLengthProbas[s][this.durations[this.len_obseq - 1][s] + 1]) / (1.0 - this.cumulLengthProbas[s][this.durations[this.len_obseq - 1][s]])) : this.delta[this.len_obseq - 1][s] + Math.log(0.0);
            if (!(temp > max)) continue;
            max = temp;
            this.qstar[this.len_obseq - 1] = s;
        }
        for (int t = this.len_obseq - 2; t >= 0; --t) {
            this.qstar[t] = this.psi[t + 1][this.qstar[t + 1]];
        }
        return max;
    }

    public void myComputeSemiConsDelta(int t, int i) {
        boolean isInhomogeneous = false;
        Model model = this.lambda;
        MyLogFunc myLog = new MyLogFunc();
        if (t > 0) {
            double tmp = 0.0;
            double max = -1.0E17;
            int duration = 0;
            int index = 0;
            double[][] normalisedA = new double[this.getNumStates()][this.getNumStates()];
            for (int j = 0; j < this.lambda.condA[i].length; ++j) {
                int k = this.lambda.condA[i][j];
                isInhomogeneous = this.lambda.getHasInhomLengths()[k];
                if (k != i) {
                    normalisedA[k][i] = isInhomogeneous ? 1.0 - (1.0 - this.cumulLengthProbas[k][this.durations[t - 1][k] + 1]) / (1.0 - this.cumulLengthProbas[k][this.durations[t - 1][k]]) : this.lambda.getA(k, i);
                    tmp = this.delta[t - 1][k] + myLog.apply(normalisedA[k][i]);
                    if (tmp > max) {
                        max = tmp;
                        index = k;
                        duration = 1;
                    }
                } else if (k == i) {
                    if (isInhomogeneous) {
                        normalisedA[i][i] = (1.0 - this.cumulLengthProbas[i][this.durations[t - 1][i] + 1]) / (1.0 - this.cumulLengthProbas[i][this.durations[t - 1][i]]);
                    } else if (!isInhomogeneous) {
                        normalisedA[i][i] = this.lambda.getA(i, i);
                    }
                    tmp = this.delta[t - 1][i] + myLog.apply(normalisedA[i][i]);
                    if (tmp > max) {
                        max = tmp;
                        index = i;
                        duration = this.durations[t - 1][i] + 1;
                    }
                }
                this.delta[t][i] = max + this.logObs[t][i] + this.consObsLogScores[t][i];
                this.psi[t][i] = index;
                this.durations[t][i] = duration;
            }
        } else if (t == 0) {
            this.delta[0][i] = this.logPi[i] + this.logObs[0][i] + this.consObsLogScores[0][i];
            this.psi[0][i] = 0;
            this.durations[0][i] = 1;
        }
    }

    public void viterbiForProtGeneModels() {
        int i;
        if (!this.lambda.isReady) {
            System.err.println("THE MODEL HAS TO BE READY BEFORE YOU USE IT");
            System.exit(1);
        }
        MyLogFunc mylog = new MyLogFunc();
        double[] logPidNA = new double[this.lambda.num_states];
        for (int i2 = 0; i2 < this.lambda.num_states; ++i2) {
            logPidNA[i2] = mylog.apply(this.lambda.pi[i2]);
        }
        double[][] logPiProt = new double[this.lambda.num_states][];
        for (int k = 0; k < this.lambda.num_states; ++k) {
            logPiProt[k] = new double[this.lambda.proteinModels[k].num_states];
            for (i = 0; i < this.lambda.proteinModels[k].num_states; ++i) {
                logPiProt[k][i] = mylog.apply(this.lambda.proteinModels[k].pi[i]);
            }
        }
        double[][] logAdNA = new double[this.lambda.num_states][this.lambda.num_states];
        for (i = 0; i < this.lambda.num_states; ++i) {
            for (int j = 0; j < this.lambda.num_states; ++j) {
                logAdNA[i][j] = mylog.apply(this.lambda.a[i][j]);
            }
        }
        double[][][] logAprot = new double[this.lambda.num_states][][];
        for (int k = 0; k < this.lambda.num_states; ++k) {
            logAprot[k] = new double[this.lambda.proteinModels[k].num_states][this.lambda.proteinModels[k].num_states];
            for (int i3 = 0; i3 < this.lambda.proteinModels[k].num_states; ++i3) {
                for (int j = 0; j < this.lambda.proteinModels[k].num_states; ++j) {
                    logAprot[k][i3][j] = mylog.apply(this.lambda.proteinModels[k].a[i3][j]);
                }
            }
        }
        this.psiForMultipleSequencesForProtGeneModels = new ArrayList[this.obSeqs.size()][][][][];
        this.qstarForMultipleSequencesForProtGeneModels = new ArrayList[this.obSeqs.size()][];
        for (int r = 0; r < this.obSeqs.size(); ++r) {
            int l;
            int multiple = 1;
            ArrayList obseq = (ArrayList)this.obSeqs.get(r);
            this.psiForMultipleSequencesForProtGeneModels[r] = new ArrayList[obseq.size()][this.getNumStates()][3][];
            this.qstarForMultipleSequencesForProtGeneModels[r] = new ArrayList[obseq.size()];
            double[][][] decodVarLocal = new double[this.getNumStates()][3][];
            double[][][] decodVarLocalPrevious = new double[this.getNumStates()][3][];
            for (int i4 = 0; i4 < this.getNumStates(); ++i4) {
                for (int p = 0; p < 3; ++p) {
                    decodVarLocal[i4][p] = new double[this.lambda.proteinModels[i4].num_states];
                    decodVarLocalPrevious[i4][p] = new double[this.lambda.proteinModels[i4].num_states];
                    for (l = 0; l < this.lambda.proteinModels[i4].num_states; ++l) {
                        decodVarLocal[i4][p][l] = logPidNA[i4] + this.logObsForMultipleSequences[r][0][i4];
                        decodVarLocalPrevious[i4][p][l] = logPidNA[i4] + this.logObsForMultipleSequences[r][0][i4];
                    }
                }
            }
            for (int t = 1; t < obseq.size(); ++t) {
                int j;
                if (t == multiple * 1000) {
                    System.out.println("decoding ".concat(String.valueOf(String.valueOf(t))));
                    ++multiple;
                }
                for (j = 0; j < this.getNumStates(); ++j) {
                    this.psiForMultipleSequencesForProtGeneModels[r][t][j] = new ArrayList[3][this.lambda.proteinModels[j].num_states];
                    for (l = 0; l < this.lambda.proteinModels[j].num_states; ++l) {
                        for (int p = 0; p < 3; ++p) {
                            int previousp = p - 1;
                            if (previousp == -1) {
                                previousp = 2;
                            }
                            double tmp = Double.NEGATIVE_INFINITY;
                            double max = Double.NEGATIVE_INFINITY;
                            int bestj = -1;
                            int bestp = -1;
                            int bestl = -1;
                            for (int k = 0; k < this.lambda.condA[j].length; ++k) {
                                int s = this.lambda.condA[j][k];
                                if (j == s) {
                                    if (p == 0 && t > 1 && t < obseq.size() - 2) {
                                        boolean hasfoundmax = false;
                                        for (int q = 0; q < this.lambda.proteinModels[j].condA[l].length; ++q) {
                                            int m = this.lambda.proteinModels[j].condA[l][q];
                                            tmp = logAdNA[s][j] + decodVarLocalPrevious[j][previousp][m] + logAprot[j][m][l] + this.logObsForMultipleSequencesForProtGeneModels[r][t][j][l];
                                            if (!(tmp > max)) continue;
                                            bestj = j;
                                            bestp = previousp;
                                            bestl = m;
                                            max = tmp;
                                        }
                                        continue;
                                    }
                                    if (p == 0 && t > 1 && t < obseq.size() - 2 || !((tmp = logAdNA[s][j] + decodVarLocalPrevious[j][previousp][l]) > max)) continue;
                                    bestj = j;
                                    bestp = previousp;
                                    bestl = l;
                                    max = tmp;
                                    continue;
                                }
                                if (s == j) continue;
                                for (int m = 0; m < this.lambda.proteinModels[s].num_states; ++m) {
                                    for (int n = 0; n < 3; ++n) {
                                        tmp = logAdNA[s][j] + decodVarLocalPrevious[s][n][m] + logPiProt[j][l] + mylog.apply(0.368);
                                        if (!(tmp > max)) continue;
                                        bestj = s;
                                        bestp = n;
                                        bestl = m;
                                        max = tmp;
                                    }
                                }
                            }
                            ArrayList<Integer> al = new ArrayList<Integer>(3);
                            al.add(new Integer(bestj));
                            al.add(new Integer(bestp));
                            al.add(new Integer(bestl));
                            this.psiForMultipleSequencesForProtGeneModels[r][t][j][p][l] = al;
                            decodVarLocal[j][p][l] = max + this.logObsForMultipleSequences[r][t][j];
                        }
                    }
                }
                for (j = 0; j < this.getNumStates(); ++j) {
                    for (int p = 0; p < 3; ++p) {
                        for (int l2 = 0; l2 < this.lambda.proteinModels[j].num_states; ++l2) {
                            decodVarLocalPrevious[j][p][l2] = decodVarLocal[j][p][l2];
                        }
                    }
                }
            }
            double temp = 0.0;
            double max = decodVarLocal[0][0][0];
            ArrayList<Integer> al = new ArrayList<Integer>(3);
            for (int v = 0; v < 3; ++v) {
                al.add(new Integer(0));
            }
            this.qstarForMultipleSequencesForProtGeneModels[r][obseq.size() - 1] = al;
            for (int j = 0; j < this.getNumStates(); ++j) {
                for (int l3 = 0; l3 < this.lambda.proteinModels[j].num_states; ++l3) {
                    for (int p = 0; p < 3; ++p) {
                        temp = decodVarLocal[j][p][l3];
                        if (!(temp > max)) continue;
                        al = new ArrayList();
                        al.add(new Integer(j));
                        al.add(new Integer(p));
                        al.add(new Integer(l3));
                        this.qstarForMultipleSequencesForProtGeneModels[r][obseq.size() - 1] = al;
                        max = temp;
                    }
                }
            }
            for (int t = obseq.size() - 2; t >= 0; --t) {
                ArrayList al3;
                ArrayList al2 = this.qstarForMultipleSequencesForProtGeneModels[r][t + 1];
                int j = (Integer)al2.get(0);
                int p = (Integer)al2.get(1);
                int l4 = (Integer)al2.get(2);
                this.qstarForMultipleSequencesForProtGeneModels[r][t] = al3 = this.psiForMultipleSequencesForProtGeneModels[r][t + 1][j][p][l4];
            }
        }
    }

    public void viterbiGlobalForProtGeneModels(int endState) {
        int i;
        if (!this.lambda.isReady) {
            System.err.println("THE MODEL HAS TO BE READY BEFORE YOU USE IT");
            System.exit(1);
        }
        MyLogFunc mylog = new MyLogFunc();
        int indexCodingState = (Integer)Model.statesMap.get("coding-GPCR");
        double[] logPidNA = new double[this.lambda.num_states];
        for (int i2 = 0; i2 < this.lambda.num_states; ++i2) {
            logPidNA[i2] = mylog.apply(this.lambda.pi[i2]);
        }
        double[][] logPiProt = new double[this.lambda.num_states][];
        for (int k = 0; k < this.lambda.num_states; ++k) {
            logPiProt[k] = new double[this.lambda.proteinModels[k].num_states];
            for (i = 0; i < this.lambda.proteinModels[k].num_states; ++i) {
                logPiProt[k][i] = mylog.apply(this.lambda.proteinModels[k].pi[i]);
            }
        }
        double[][] logAdNA = new double[this.lambda.num_states][this.lambda.num_states];
        for (i = 0; i < this.lambda.num_states; ++i) {
            for (int j = 0; j < this.lambda.num_states; ++j) {
                logAdNA[i][j] = mylog.apply(this.lambda.a[i][j]);
            }
        }
        double[][][] logAprot = new double[this.lambda.num_states][][];
        for (int k = 0; k < this.lambda.num_states; ++k) {
            logAprot[k] = new double[this.lambda.proteinModels[k].num_states][this.lambda.proteinModels[k].num_states];
            for (int i3 = 0; i3 < this.lambda.proteinModels[k].num_states; ++i3) {
                for (int j = 0; j < this.lambda.proteinModels[k].num_states; ++j) {
                    logAprot[k][i3][j] = mylog.apply(this.lambda.proteinModels[k].a[i3][j]);
                }
            }
        }
        this.psiForMultipleSequencesForProtGeneModels = new ArrayList[this.obSeqs.size()][][][][];
        this.qstarForMultipleSequencesForProtGeneModels = new ArrayList[this.obSeqs.size()][];
        for (int r = 0; r < this.obSeqs.size(); ++r) {
            int l;
            int p;
            int i4;
            int multiple = 1;
            ArrayList obseq = (ArrayList)this.obSeqs.get(r);
            this.psiForMultipleSequencesForProtGeneModels[r] = new ArrayList[obseq.size()][this.getNumStates()][3][];
            this.qstarForMultipleSequencesForProtGeneModels[r] = new ArrayList[obseq.size()];
            double[][][] decodVarLocal = new double[this.getNumStates()][3][];
            double[][][] decodVarLocalPrevious = new double[this.getNumStates()][3][];
            ArrayList[][][] lastCodingPosition = new ArrayList[this.getNumStates()][][];
            ArrayList[][][] previousLastCodingPosition = new ArrayList[this.getNumStates()][][];
            boolean[][][] hasBeenInCoding = new boolean[this.getNumStates()][][];
            boolean[][][] previousHasBeenInCoding = new boolean[this.getNumStates()][][];
            boolean[][][] hasReachedFinalState = new boolean[this.getNumStates()][][];
            boolean[][][] previousHasReachedFinalState = new boolean[this.getNumStates()][][];
            for (i4 = 0; i4 < this.getNumStates(); ++i4) {
                lastCodingPosition[i4] = new ArrayList[3][this.lambda.proteinModels[i4].num_states];
                previousLastCodingPosition[i4] = new ArrayList[3][this.lambda.proteinModels[i4].num_states];
                hasBeenInCoding[i4] = new boolean[3][this.lambda.proteinModels[i4].num_states];
                previousHasBeenInCoding[i4] = new boolean[3][this.lambda.proteinModels[i4].num_states];
                decodVarLocal[i4] = new double[3][this.lambda.proteinModels[i4].num_states];
                decodVarLocalPrevious[i4] = new double[3][this.lambda.proteinModels[i4].num_states];
                hasReachedFinalState[i4] = new boolean[3][this.lambda.proteinModels[i4].num_states];
                previousHasReachedFinalState[i4] = new boolean[3][this.lambda.proteinModels[i4].num_states];
                for (p = 0; p < 3; ++p) {
                    for (l = 0; l < this.lambda.proteinModels[i4].num_states; ++l) {
                        if (i4 == indexCodingState && this.lambda.proteinModels[i4].labels[l].equals("M0")) {
                            previousHasBeenInCoding[i4][p][l] = true;
                            previousLastCodingPosition[i4][p][l] = new ArrayList();
                            previousLastCodingPosition[i4][p][l].add(new Integer(p));
                            previousLastCodingPosition[i4][p][l].add(new Integer(l));
                        } else {
                            previousHasBeenInCoding[i4][p][l] = false;
                            previousLastCodingPosition[i4][p][l] = new ArrayList();
                            previousLastCodingPosition[i4][p][l].add(new Integer(-1));
                            previousLastCodingPosition[i4][p][l].add(new Integer(-1));
                        }
                        hasReachedFinalState[i4][p][l] = false;
                        previousHasReachedFinalState[i4][p][l] = false;
                    }
                }
            }
            for (i4 = 0; i4 < this.getNumStates(); ++i4) {
                for (p = 0; p < 3; ++p) {
                    decodVarLocal[i4][p] = new double[this.lambda.proteinModels[i4].num_states];
                    decodVarLocalPrevious[i4][p] = new double[this.lambda.proteinModels[i4].num_states];
                    for (l = 0; l < this.lambda.proteinModels[i4].num_states; ++l) {
                        decodVarLocal[i4][p][l] = logPidNA[i4] + logPiProt[i4][l] + this.logObsForMultipleSequences[r][0][i4];
                        decodVarLocalPrevious[i4][p][l] = logPidNA[i4] + logPiProt[i4][l] + this.logObsForMultipleSequences[r][0][i4];
                    }
                }
            }
            for (int t = 1; t < obseq.size(); ++t) {
                int j;
                if (t == multiple * 1000) {
                    System.out.println("decoding ".concat(String.valueOf(String.valueOf(t))));
                    ++multiple;
                }
                for (j = 0; j < this.getNumStates(); ++j) {
                    this.psiForMultipleSequencesForProtGeneModels[r][t][j] = new ArrayList[3][this.lambda.proteinModels[j].num_states];
                    for (l = 0; l < this.lambda.proteinModels[j].num_states; ++l) {
                        for (int p2 = 0; p2 < 3; ++p2) {
                            int previousp = p2 - 1;
                            if (previousp == -1) {
                                previousp = 2;
                            }
                            double tmp = 0.0;
                            double max = -1.0E15;
                            int bestj = 0;
                            int bestp = 0;
                            int bestl = 0;
                            for (int k = 0; k < this.lambda.condA[j].length; ++k) {
                                int n;
                                int m;
                                int s = this.lambda.condA[j][k];
                                tmp = logAdNA[s][j];
                                if (j == s) {
                                    if (p2 == 0 && t < obseq.size() - 2) {
                                        for (int q = 0; q < this.lambda.proteinModels[j].condA[l].length; ++q) {
                                            int m2 = this.lambda.proteinModels[j].condA[l][q];
                                            if ((tmp += decodVarLocalPrevious[j][previousp][m2] + logAprot[j][m2][l] + this.logObsForMultipleSequencesForProtGeneModels[r][t][j][l]) > max) {
                                                bestj = j;
                                                bestp = previousp;
                                                bestl = m2;
                                                max = tmp;
                                            }
                                            tmp = logAdNA[s][j];
                                        }
                                        continue;
                                    }
                                    if (p2 == 0 && t < obseq.size() - 2 || !((tmp += decodVarLocalPrevious[j][previousp][l]) > max)) continue;
                                    bestj = j;
                                    bestp = previousp;
                                    bestl = l;
                                    max = tmp;
                                    continue;
                                }
                                if (s == j) continue;
                                if (j == indexCodingState) {
                                    for (m = 0; m < this.lambda.proteinModels[s].num_states; ++m) {
                                        for (n = 0; n < 3; ++n) {
                                            tmp += decodVarLocalPrevious[s][n][m];
                                            if (previousHasBeenInCoding[s][n][m]) {
                                                int lastFrame = (Integer)previousLastCodingPosition[s][n][m].get(0);
                                                int lastCodingProtState = (Integer)previousLastCodingPosition[s][n][m].get(1);
                                                tmp = l >= lastCodingProtState ? (tmp += mylog.apply(0.368)) : Double.NEGATIVE_INFINITY;
                                            } else if (!previousHasBeenInCoding[s][n][m]) {
                                                tmp += logPiProt[j][l] + mylog.apply(0.368);
                                            }
                                            if (tmp > max) {
                                                bestj = s;
                                                bestp = n;
                                                bestl = m;
                                                max = tmp;
                                            }
                                            tmp = logAdNA[s][j];
                                        }
                                    }
                                    continue;
                                }
                                if (j == indexCodingState) continue;
                                for (m = 0; m < this.lambda.proteinModels[s].num_states; ++m) {
                                    for (n = 0; n < 3; ++n) {
                                        if ((tmp += decodVarLocalPrevious[s][n][m] + mylog.apply(0.368)) > max) {
                                            bestj = s;
                                            bestp = n;
                                            bestl = m;
                                            max = tmp;
                                        }
                                        tmp = logAdNA[s][j];
                                    }
                                }
                            }
                            ArrayList<Integer> al = new ArrayList<Integer>(3);
                            al.add(new Integer(bestj));
                            al.add(new Integer(bestp));
                            al.add(new Integer(bestl));
                            this.psiForMultipleSequencesForProtGeneModels[r][t][j][p2][l] = al;
                            decodVarLocal[j][p2][l] = max + this.logObsForMultipleSequences[r][t][j];
                            hasReachedFinalState[j][p2][l] = bestj == indexCodingState && bestl == endState && bestp == 2 ? true : previousHasReachedFinalState[bestj][bestp][bestl];
                            if (bestj == indexCodingState && j != indexCodingState) {
                                ArrayList<Integer> dummy = new ArrayList<Integer>(2);
                                dummy.add(new Integer(bestp));
                                dummy.add(new Integer(bestl));
                                lastCodingPosition[j][p2][l] = dummy;
                                hasBeenInCoding[j][p2][l] = true;
                                continue;
                            }
                            if (bestj == indexCodingState && j == indexCodingState) {
                                ArrayList<Integer> dummy = new ArrayList<Integer>(2);
                                dummy.add(new Integer(p2));
                                dummy.add(new Integer(l));
                                lastCodingPosition[j][p2][l] = dummy;
                                hasBeenInCoding[j][p2][l] = true;
                                continue;
                            }
                            if (bestj != indexCodingState && j == indexCodingState) {
                                ArrayList<Integer> dummy = new ArrayList<Integer>(2);
                                dummy.add(new Integer(p2));
                                dummy.add(new Integer(l));
                                lastCodingPosition[j][p2][l] = dummy;
                                hasBeenInCoding[j][p2][l] = true;
                                continue;
                            }
                            if (bestj == indexCodingState || j == indexCodingState) continue;
                            lastCodingPosition[j][p2][l] = previousLastCodingPosition[bestj][bestp][bestl];
                            hasBeenInCoding[j][p2][l] = previousHasBeenInCoding[bestj][bestp][bestl];
                        }
                    }
                }
                for (j = 0; j < this.getNumStates(); ++j) {
                    for (int p3 = 0; p3 < 3; ++p3) {
                        for (int l2 = 0; l2 < this.lambda.proteinModels[j].num_states; ++l2) {
                            previousLastCodingPosition[j][p3][l2] = new ArrayList();
                            previousLastCodingPosition[j][p3][l2].add(lastCodingPosition[j][p3][l2].get(0));
                            previousLastCodingPosition[j][p3][l2].add(lastCodingPosition[j][p3][l2].get(1));
                            previousHasBeenInCoding[j][p3][l2] = hasBeenInCoding[j][p3][l2];
                            decodVarLocalPrevious[j][p3][l2] = decodVarLocal[j][p3][l2];
                            previousHasReachedFinalState[j][p3][l2] = hasReachedFinalState[j][p3][l2];
                        }
                    }
                }
            }
            double temp = 0.0;
            double max = decodVarLocal[0][0][0];
            ArrayList<Integer> al = new ArrayList<Integer>(3);
            for (int v = 0; v < 3; ++v) {
                al.add(new Integer(0));
            }
            this.qstarForMultipleSequencesForProtGeneModels[r][obseq.size() - 1] = al;
            for (int j = 0; j < this.getNumStates(); ++j) {
                for (int l3 = 0; l3 < this.lambda.proteinModels[j].num_states; ++l3) {
                    for (int p4 = 0; p4 < 3; ++p4) {
                        if (!hasReachedFinalState[j][p4][l3] && (j != indexCodingState || l3 != endState) || !((temp = decodVarLocal[j][p4][l3]) > max)) continue;
                        al = new ArrayList();
                        al.add(new Integer(j));
                        al.add(new Integer(p4));
                        al.add(new Integer(l3));
                        this.qstarForMultipleSequencesForProtGeneModels[r][obseq.size() - 1] = al;
                        max = temp;
                    }
                }
            }
            for (int t = obseq.size() - 2; t >= 0; --t) {
                ArrayList al3;
                ArrayList al2 = this.qstarForMultipleSequencesForProtGeneModels[r][t + 1];
                int j = (Integer)al2.get(0);
                int p5 = (Integer)al2.get(1);
                int l4 = (Integer)al2.get(2);
                this.qstarForMultipleSequencesForProtGeneModels[r][t] = al3 = this.psiForMultipleSequencesForProtGeneModels[r][t + 1][j][p5][l4];
            }
        }
    }

    public void viterbiGlobalForProtGeneModels2(ArrayList codingStates) {
        int i;
        if (!this.lambda.isReady) {
            System.err.println("THE MODEL HAS TO BE READY BEFORE YOU USE IT");
            System.exit(1);
        }
        MyLogFunc mylog = new MyLogFunc();
        double[] logPidNA = new double[this.lambda.num_states];
        for (int i2 = 0; i2 < this.lambda.num_states; ++i2) {
            logPidNA[i2] = mylog.apply(this.lambda.pi[i2]);
        }
        double[][] logPiProt = new double[this.lambda.num_states][];
        for (int k = 0; k < this.lambda.num_states; ++k) {
            logPiProt[k] = new double[this.lambda.proteinModels[k].num_states];
            for (i = 0; i < this.lambda.proteinModels[k].num_states; ++i) {
                logPiProt[k][i] = mylog.apply(this.lambda.proteinModels[k].pi[i]);
            }
        }
        double[][] logAdNA = new double[this.lambda.num_states][this.lambda.num_states];
        for (i = 0; i < this.lambda.num_states; ++i) {
            for (int j = 0; j < this.lambda.num_states; ++j) {
                logAdNA[i][j] = mylog.apply(this.lambda.a[i][j]);
            }
        }
        double[][][] logAprot = new double[this.lambda.num_states][][];
        for (int k = 0; k < this.lambda.num_states; ++k) {
            logAprot[k] = new double[this.lambda.proteinModels[k].num_states][this.lambda.proteinModels[k].num_states];
            for (int i3 = 0; i3 < this.lambda.proteinModels[k].num_states; ++i3) {
                for (int j = 0; j < this.lambda.proteinModels[k].num_states; ++j) {
                    logAprot[k][i3][j] = mylog.apply(this.lambda.proteinModels[k].a[i3][j]);
                }
            }
        }
        this.psiForMultipleSequencesForProtGeneModels = new ArrayList[this.obSeqs.size()][][][][];
        this.qstarForMultipleSequencesForProtGeneModels = new ArrayList[this.obSeqs.size()][];
        System.out.println("CHECKPOINT 1");
        for (int r = 0; r < this.obSeqs.size(); ++r) {
            int l;
            int multiple = 1;
            ArrayList obseq = (ArrayList)this.obSeqs.get(r);
            this.psiForMultipleSequencesForProtGeneModels[r] = new ArrayList[obseq.size()][this.getNumStates()][3][];
            this.qstarForMultipleSequencesForProtGeneModels[r] = new ArrayList[obseq.size()];
            double[][][] decodVarLocal = new double[this.getNumStates()][3][];
            double[][][] decodVarLocalPrevious = new double[this.getNumStates()][3][];
            for (int i4 = 0; i4 < this.getNumStates(); ++i4) {
                for (int p = 0; p < 3; ++p) {
                    decodVarLocal[i4][p] = new double[this.lambda.proteinModels[i4].num_states];
                    decodVarLocalPrevious[i4][p] = new double[this.lambda.proteinModels[i4].num_states];
                    for (l = 0; l < this.lambda.proteinModels[i4].num_states; ++l) {
                        decodVarLocal[i4][p][l] = logPidNA[i4] + this.logObsForMultipleSequences[r][0][i4];
                        decodVarLocalPrevious[i4][p][l] = logPidNA[i4] + this.logObsForMultipleSequences[r][0][i4];
                    }
                }
            }
            for (int t = 1; t < obseq.size(); ++t) {
                int j;
                if (t == multiple * 1000) {
                    System.out.println("decoding ".concat(String.valueOf(String.valueOf(t))));
                    ++multiple;
                }
                for (j = 0; j < this.getNumStates(); ++j) {
                    this.psiForMultipleSequencesForProtGeneModels[r][t][j] = new ArrayList[3][this.lambda.proteinModels[j].num_states];
                    for (l = 0; l < this.lambda.proteinModels[j].num_states; ++l) {
                        for (int p = 0; p < 3; ++p) {
                            int previousp = p - 1;
                            if (previousp == -1) {
                                previousp = 2;
                            }
                            double tmp = Double.NEGATIVE_INFINITY;
                            double max = Double.NEGATIVE_INFINITY;
                            int bestj = -1;
                            int bestp = -1;
                            int bestl = -1;
                            for (int k = 0; k < this.lambda.condA[j].length; ++k) {
                                int m;
                                int m2;
                                int q;
                                int s = this.lambda.condA[j][k];
                                if (j == s) {
                                    if (p == 0 && t > 1 && t < obseq.size() - 2) {
                                        for (q = 0; q < this.lambda.proteinModels[j].condA[l].length; ++q) {
                                            m2 = this.lambda.proteinModels[j].condA[l][q];
                                            tmp = logAdNA[s][j] + decodVarLocalPrevious[j][previousp][m2] + logAprot[j][m2][l] + this.logObsForMultipleSequencesForProtGeneModels[r][t][s][m2];
                                            if (!(tmp > max)) continue;
                                            bestj = s;
                                            bestp = previousp;
                                            bestl = m2;
                                            max = tmp;
                                        }
                                        continue;
                                    }
                                    if (p == 0 && t > 1 && t < obseq.size() - 2 || !((tmp = logAdNA[s][j] + decodVarLocalPrevious[s][previousp][l]) > max)) continue;
                                    bestj = s;
                                    bestp = previousp;
                                    bestl = l;
                                    max = tmp;
                                    continue;
                                }
                                if (s == j) continue;
                                if (!codingStates.contains(new Integer(s)) || !codingStates.contains(new Integer(j))) {
                                    for (m = 0; m < this.lambda.proteinModels[s].num_states; ++m) {
                                        for (int n = 0; n < 3; ++n) {
                                            tmp = logAdNA[s][j] + decodVarLocalPrevious[s][n][m] + mylog.apply(0.368);
                                            if (!(tmp > max)) continue;
                                            bestj = s;
                                            bestp = n;
                                            bestl = m;
                                            max = tmp;
                                        }
                                    }
                                    continue;
                                }
                                if (!codingStates.contains(new Integer(s)) || !codingStates.contains(new Integer(j))) continue;
                                if (p == 0 && t > 1 && t < obseq.size() - 2) {
                                    for (q = 0; q < this.lambda.proteinModels[j].condA[l].length; ++q) {
                                        m2 = this.lambda.proteinModels[s].condA[l][q];
                                        tmp = logAdNA[s][j] + decodVarLocalPrevious[s][previousp][m2] + logAprot[s][m2][l] + this.logObsForMultipleSequencesForProtGeneModels[r][t][s][m2];
                                        if (!(tmp > max)) continue;
                                        bestj = s;
                                        bestp = previousp;
                                        bestl = m2;
                                        max = tmp;
                                    }
                                    continue;
                                }
                                if (p == 0 && t > 1 && t < obseq.size() - 2) continue;
                                for (m = 0; m < this.lambda.proteinModels[s].num_states; ++m) {
                                    tmp = logAdNA[s][j] + decodVarLocalPrevious[s][previousp][m] + mylog.apply(0.368);
                                    if (!(tmp > max)) continue;
                                    bestj = s;
                                    bestp = previousp;
                                    bestl = m;
                                    max = tmp;
                                }
                            }
                            ArrayList<Integer> al = new ArrayList<Integer>(3);
                            al.add(new Integer(bestj));
                            al.add(new Integer(bestp));
                            al.add(new Integer(bestl));
                            this.psiForMultipleSequencesForProtGeneModels[r][t][j][p][l] = al;
                            decodVarLocal[j][p][l] = max + this.logObsForMultipleSequences[r][t][j];
                        }
                    }
                }
                for (j = 0; j < this.getNumStates(); ++j) {
                    for (int p = 0; p < 3; ++p) {
                        for (int l2 = 0; l2 < this.lambda.proteinModels[j].num_states; ++l2) {
                            decodVarLocalPrevious[j][p][l2] = decodVarLocal[j][p][l2];
                        }
                    }
                }
            }
            System.out.println("CHECKPOINT 2");
            double temp = 0.0;
            double max = decodVarLocal[0][0][0];
            ArrayList<Integer> al = new ArrayList<Integer>(3);
            for (int v = 0; v < 3; ++v) {
                al.add(new Integer(0));
            }
            this.qstarForMultipleSequencesForProtGeneModels[r][obseq.size() - 1] = al;
            for (int j = 0; j < this.getNumStates(); ++j) {
                for (int l3 = 0; l3 < this.lambda.proteinModels[j].num_states; ++l3) {
                    for (int p = 0; p < 3; ++p) {
                        temp = decodVarLocal[j][p][l3];
                        if (!(temp > max)) continue;
                        al = new ArrayList();
                        al.add(new Integer(j));
                        al.add(new Integer(p));
                        al.add(new Integer(l3));
                        this.qstarForMultipleSequencesForProtGeneModels[r][obseq.size() - 1] = al;
                        max = temp;
                    }
                }
            }
            for (int t = obseq.size() - 2; t >= 0; --t) {
                ArrayList al3;
                ArrayList al2 = this.qstarForMultipleSequencesForProtGeneModels[r][t + 1];
                int j = (Integer)al2.get(0);
                int p = (Integer)al2.get(1);
                int l4 = (Integer)al2.get(2);
                this.qstarForMultipleSequencesForProtGeneModels[r][t] = al3 = this.psiForMultipleSequencesForProtGeneModels[r][t + 1][j][p][l4];
            }
        }
    }

    public void viterbiGlobalForProtGeneModels3(ArrayList codingStates) {
        int i;
        if (!this.lambda.isReady) {
            System.err.println("THE MODEL HAS TO BE READY BEFORE YOU USE IT");
            System.exit(1);
        }
        MyLogFunc mylog = new MyLogFunc();
        double[] logPidNA = new double[this.lambda.num_states];
        for (int i2 = 0; i2 < this.lambda.num_states; ++i2) {
            logPidNA[i2] = mylog.apply(this.lambda.pi[i2]);
        }
        double[][] logPiProt = new double[this.lambda.num_states][];
        for (int k = 0; k < this.lambda.num_states; ++k) {
            logPiProt[k] = new double[this.lambda.proteinModels[k].num_states];
            for (i = 0; i < this.lambda.proteinModels[k].num_states; ++i) {
                logPiProt[k][i] = mylog.apply(this.lambda.proteinModels[k].pi[i]);
            }
        }
        double[][] logAdNA = new double[this.lambda.num_states][this.lambda.num_states];
        for (i = 0; i < this.lambda.num_states; ++i) {
            for (int j = 0; j < this.lambda.num_states; ++j) {
                logAdNA[i][j] = mylog.apply(this.lambda.a[i][j]);
            }
        }
        this.psiForMultipleSequencesForProtGeneModels = new ArrayList[this.obSeqs.size()][][][][];
        this.qstarForMultipleSequencesForProtGeneModels = new ArrayList[this.obSeqs.size()][];
        System.out.println("CHECKPOINT 1");
        for (int r = 0; r < this.obSeqs.size(); ++r) {
            int multiple = 1;
            ArrayList obseq = (ArrayList)this.obSeqs.get(r);
            this.psiForMultipleSequencesForProtGeneModels[r] = new ArrayList[obseq.size()][this.getNumStates()][3][];
            this.qstarForMultipleSequencesForProtGeneModels[r] = new ArrayList[obseq.size()];
            double[][] decodVarLocal = new double[this.getNumStates()][3];
            double[][] decodVarLocalPrevious = new double[this.getNumStates()][3];
            for (int i3 = 0; i3 < this.getNumStates(); ++i3) {
                for (int p = 0; p < 3; ++p) {
                    decodVarLocal[i3][p] = logPidNA[i3] + this.logObsForMultipleSequences[r][0][i3];
                    decodVarLocalPrevious[i3][p] = logPidNA[i3] + this.logObsForMultipleSequences[r][0][i3];
                }
            }
            for (int t = 1; t < obseq.size(); ++t) {
                int j;
                if (t == multiple * 1000) {
                    System.out.println("decoding ".concat(String.valueOf(String.valueOf(t))));
                    ++multiple;
                }
                for (j = 0; j < this.getNumStates(); ++j) {
                    this.psiForMultipleSequencesForProtGeneModels[r][t][j] = new ArrayList[3][this.lambda.proteinModels[j].num_states];
                    for (int l = 0; l < this.lambda.proteinModels[j].num_states; ++l) {
                        for (int p = 0; p < 3; ++p) {
                            int previousp = p - 1;
                            if (previousp == -1) {
                                previousp = 2;
                            }
                            double tmp = Double.NEGATIVE_INFINITY;
                            double max = Double.NEGATIVE_INFINITY;
                            int bestj = -1;
                            int bestp = -1;
                            if ((p != 0 || t <= 1 || t >= obseq.size() - 2) && (tmp = decodVarLocalPrevious[j][previousp] + mylog.apply(0.05)) > max) {
                                bestj = j;
                                bestp = previousp;
                                max = tmp;
                            }
                            for (int k = 0; k < this.lambda.condA[j].length; ++k) {
                                int s = this.lambda.condA[j][k];
                                if (j == s) {
                                    if (p != 0 || t <= 1 || t >= obseq.size() - 2 || !((tmp = logAdNA[s][j] + decodVarLocalPrevious[j][previousp] + this.logObsForMultipleSequencesForProtGeneModels[r][t][j][0]) > max)) continue;
                                    bestj = s;
                                    bestp = previousp;
                                    max = tmp;
                                    continue;
                                }
                                if (s == j) continue;
                                if (!codingStates.contains(new Integer(s)) || !codingStates.contains(new Integer(j))) {
                                    for (int n = 0; n < 3; ++n) {
                                        tmp = logAdNA[s][j] + decodVarLocalPrevious[s][n] + mylog.apply(0.05);
                                        if (!(tmp > max)) continue;
                                        bestj = s;
                                        bestp = n;
                                        max = tmp;
                                    }
                                    continue;
                                }
                                if (!codingStates.contains(new Integer(s)) || !codingStates.contains(new Integer(j)) || p != 0 || t <= 1 || t >= obseq.size() - 2 || !((tmp = logAdNA[s][j] + decodVarLocalPrevious[s][previousp] + this.logObsForMultipleSequencesForProtGeneModels[r][t][j][0]) > max)) continue;
                                bestj = s;
                                bestp = previousp;
                                max = tmp;
                            }
                            ArrayList<Integer> al = new ArrayList<Integer>(3);
                            al.add(new Integer(bestj));
                            al.add(new Integer(bestp));
                            al.add(new Integer(0));
                            this.psiForMultipleSequencesForProtGeneModels[r][t][j][p][l] = al;
                            decodVarLocal[j][p] = max + this.logObsForMultipleSequences[r][t][j];
                        }
                    }
                }
                for (j = 0; j < this.getNumStates(); ++j) {
                    for (int p = 0; p < 3; ++p) {
                        for (int l = 0; l < this.lambda.proteinModels[j].num_states; ++l) {
                            decodVarLocalPrevious[j][p] = decodVarLocal[j][p];
                        }
                    }
                }
            }
            System.out.println("CHECKPOINT 2");
            double temp = 0.0;
            double max = decodVarLocal[0][0];
            ArrayList<Integer> al = new ArrayList<Integer>(3);
            for (int v = 0; v < 3; ++v) {
                al.add(new Integer(0));
            }
            this.qstarForMultipleSequencesForProtGeneModels[r][obseq.size() - 1] = al;
            for (int j = 0; j < this.getNumStates(); ++j) {
                for (int l = 0; l < this.lambda.proteinModels[j].num_states; ++l) {
                    for (int p = 0; p < 3; ++p) {
                        temp = decodVarLocal[j][p];
                        if (!(temp > max)) continue;
                        al = new ArrayList();
                        al.add(new Integer(j));
                        al.add(new Integer(p));
                        al.add(new Integer(0));
                        this.qstarForMultipleSequencesForProtGeneModels[r][obseq.size() - 1] = al;
                        max = temp;
                    }
                }
            }
            for (int t = obseq.size() - 2; t >= 0; --t) {
                ArrayList al3;
                ArrayList al2 = this.qstarForMultipleSequencesForProtGeneModels[r][t + 1];
                int j = (Integer)al2.get(0);
                int p = (Integer)al2.get(1);
                int l = (Integer)al2.get(2);
                this.qstarForMultipleSequencesForProtGeneModels[r][t] = al3 = this.psiForMultipleSequencesForProtGeneModels[r][t + 1][j][p][l];
            }
        }
    }

    public double optimalAccuracyDecoding() {
        if (!this.lambda.isReady) {
            System.err.println("THE MODEL HAS TO BE READY BEFORE YOU USE IT");
            System.exit(1);
        }
        this.decodVar = new double[this.len_obseq][this.getNumStates()];
        this.psi = new int[this.len_obseq][this.getNumStates()];
        this.qstar = new int[this.len_obseq];
        MyLogFunc mylog = new MyLogFunc();
        for (int i = 0; i < this.getNumStates(); ++i) {
            this.decodVar[0][i] = mylog.apply(this.gamma[0][i]);
        }
        for (int t = 1; t < this.obSeq.size(); ++t) {
            for (int j = 0; j < this.getNumStates(); ++j) {
                double tmp = 0.0;
                double max = -1.0E15;
                for (int k = 0; k < this.lambda.condA[j].length; ++k) {
                    int i = this.lambda.condA[j][k];
                    double d = 1.0;
                    tmp = this.decodVar[t - 1][i] + mylog.apply(d * this.gamma[t][j]);
                    if (!(tmp > max)) continue;
                    this.psi[t][j] = i;
                    max = tmp;
                }
                this.decodVar[t][j] = max;
            }
        }
        double temp = 0.0;
        double max = this.decodVar[this.len_obseq - 1][0];
        this.qstar[this.len_obseq - 1] = 0;
        for (int s = 1; s < this.getNumStates(); ++s) {
            temp = this.decodVar[this.len_obseq - 1][s];
            if (this.lambda.labels[s].equals("CHAIN")) {
                // empty if block
            }
            if (!(temp > max)) continue;
            this.qstar[this.len_obseq - 1] = s;
            max = temp;
        }
        for (int t = this.len_obseq - 2; t >= 0; --t) {
            this.qstar[t] = this.psi[t + 1][this.qstar[t + 1]];
        }
        return max;
    }

    public void optimalAccuracyDecodingForMultipleSequences() {
        if (!this.lambda.isReady) {
            System.err.println("THE MODEL HAS TO BE READY BEFORE YOU USE IT");
            System.exit(1);
        }
        MyLogFunc mylog = new MyLogFunc();
        this.decodVarForMultipleSequences = new double[this.obSeqs.size()][][];
        this.psiForMultipleSequences = new int[this.obSeqs.size()][][];
        this.qstarForMultipleSequences = new int[this.obSeqs.size()][];
        for (int r = 0; r < this.obSeqs.size(); ++r) {
            ArrayList obseq = (ArrayList)this.obSeqs.get(r);
            this.decodVarForMultipleSequences[r] = new double[obseq.size()][this.getNumStates()];
            this.psiForMultipleSequences[r] = new int[obseq.size()][this.getNumStates()];
            this.qstarForMultipleSequences[r] = new int[obseq.size()];
            for (int i = 0; i < this.getNumStates(); ++i) {
                this.decodVarForMultipleSequences[r][0][i] = mylog.apply(this.gammaForMultipleSequences[r][0][i]);
            }
            for (int t = 1; t < obseq.size(); ++t) {
                for (int j = 0; j < this.getNumStates(); ++j) {
                    double tmp = 0.0;
                    double max = -1.0E15;
                    for (int k = 0; k < this.lambda.condA[j].length; ++k) {
                        int i = this.lambda.condA[j][k];
                        double d = 1.0;
                        tmp = this.decodVarForMultipleSequences[r][t - 1][i] + mylog.apply(d * this.gammaForMultipleSequences[r][t][j]);
                        if (!(tmp > max)) continue;
                        this.psiForMultipleSequences[r][t][j] = i;
                        max = tmp;
                    }
                    this.decodVarForMultipleSequences[r][t][j] = max;
                }
            }
            double temp = 0.0;
            double max = this.decodVarForMultipleSequences[r][obseq.size() - 1][0];
            this.qstarForMultipleSequences[r][obseq.size() - 1] = 0;
            for (int s = 1; s < this.getNumStates(); ++s) {
                temp = this.decodVarForMultipleSequences[r][obseq.size() - 1][s];
                if (!(temp > max)) continue;
                this.qstarForMultipleSequences[r][obseq.size() - 1] = s;
                max = temp;
            }
            for (int t = obseq.size() - 2; t >= 0; --t) {
                this.qstarForMultipleSequences[r][t] = this.psiForMultipleSequences[r][t + 1][this.qstarForMultipleSequences[r][t + 1]];
            }
        }
    }

    public void optimalAccuracyDecodingForMultipleSequencesForProtGeneModels() {
        if (!this.lambda.isReady) {
            System.err.println("THE MODEL HAS TO BE READY BEFORE YOU USE IT");
            System.exit(1);
        }
        MyLogFunc mylog = new MyLogFunc();
        double[][][][][] loggammas = new double[this.obSeqs.size()][][][][];
        this.psiForMultipleSequencesForProtGeneModels = new ArrayList[this.obSeqs.size()][][][][];
        this.qstarForMultipleSequencesForProtGeneModels = new ArrayList[this.obSeqs.size()][];
        for (int r = 0; r < this.obSeqs.size(); ++r) {
            int l;
            int multiple = 1;
            ArrayList obseq = (ArrayList)this.obSeqs.get(r);
            this.psiForMultipleSequencesForProtGeneModels[r] = new ArrayList[obseq.size()][this.getNumStates()][3][];
            this.qstarForMultipleSequencesForProtGeneModels[r] = new ArrayList[obseq.size()];
            loggammas[r] = new double[obseq.size()][this.getNumStates()][3][];
            double[][][] decodVarLocal = new double[this.getNumStates()][3][];
            double[][][] decodVarLocalPrevious = new double[this.getNumStates()][3][];
            for (int i = 0; i < this.getNumStates(); ++i) {
                for (int p = 0; p < 3; ++p) {
                    decodVarLocal[i][p] = new double[this.lambda.proteinModels[i].num_states];
                    decodVarLocalPrevious[i][p] = new double[this.lambda.proteinModels[i].num_states];
                    for (l = 0; l < this.lambda.proteinModels[i].num_states; ++l) {
                        decodVarLocal[i][p][l] = mylog.apply(this.gammaForMultipleSequencesForProtGeneModels[r][0][i][p][l]);
                        decodVarLocalPrevious[i][p][l] = mylog.apply(this.gammaForMultipleSequencesForProtGeneModels[r][0][i][p][l]);
                    }
                }
            }
            for (int t = 1; t < obseq.size(); ++t) {
                int j;
                if (t == multiple * 1000) {
                    System.out.println("decoding ".concat(String.valueOf(String.valueOf(t))));
                    ++multiple;
                }
                for (j = 0; j < this.getNumStates(); ++j) {
                    this.psiForMultipleSequencesForProtGeneModels[r][t][j] = new ArrayList[3][this.lambda.proteinModels[j].num_states];
                    loggammas[r][t][j] = new double[3][this.lambda.proteinModels[j].num_states];
                    for (l = 0; l < this.lambda.proteinModels[j].num_states; ++l) {
                        for (int p = 0; p < 3; ++p) {
                            loggammas[r][t][j][p][l] = mylog.apply(this.gammaForMultipleSequencesForProtGeneModels[r][t][j][p][l]);
                            int previousp = p - 1;
                            if (previousp == -1) {
                                previousp = 2;
                            }
                            double tmp = Double.NEGATIVE_INFINITY;
                            double max = Double.NEGATIVE_INFINITY;
                            int bestj = -1;
                            int bestp = -1;
                            int bestl = -1;
                            for (int k = 0; k < this.lambda.condA[j].length; ++k) {
                                int s = this.lambda.condA[j][k];
                                if (j == s) {
                                    if (p == 0) {
                                        for (int q = 0; q < this.lambda.proteinModels[j].condA[l].length; ++q) {
                                            int m = this.lambda.proteinModels[j].condA[l][q];
                                            tmp = decodVarLocalPrevious[j][previousp][m] + loggammas[r][t][j][p][l];
                                            if (!(tmp > max)) continue;
                                            bestj = j;
                                            bestp = previousp;
                                            bestl = m;
                                            max = tmp;
                                        }
                                        continue;
                                    }
                                    if (p == 0 || !((tmp = decodVarLocalPrevious[j][previousp][l] + loggammas[r][t][j][p][l]) > max)) continue;
                                    bestj = j;
                                    bestp = previousp;
                                    bestl = l;
                                    max = tmp;
                                    continue;
                                }
                                if (j == s) continue;
                                for (int m = 0; m < this.lambda.proteinModels[s].num_states; ++m) {
                                    for (int n = 0; n < 3; ++n) {
                                        tmp = decodVarLocalPrevious[s][n][m] + loggammas[r][t][j][p][l];
                                        if (!(tmp > max)) continue;
                                        bestj = s;
                                        bestp = n;
                                        bestl = m;
                                        max = tmp;
                                    }
                                }
                            }
                            ArrayList<Integer> al = new ArrayList<Integer>(3);
                            al.add(new Integer(bestj));
                            al.add(new Integer(bestp));
                            al.add(new Integer(bestl));
                            this.psiForMultipleSequencesForProtGeneModels[r][t][j][p][l] = al;
                            decodVarLocal[j][p][l] = max;
                        }
                    }
                }
                for (j = 0; j < this.getNumStates(); ++j) {
                    for (int p = 0; p < 3; ++p) {
                        for (int l2 = 0; l2 < this.lambda.proteinModels[j].num_states; ++l2) {
                            decodVarLocalPrevious[j][p][l2] = decodVarLocal[j][p][l2];
                        }
                    }
                }
            }
            double temp = Double.NEGATIVE_INFINITY;
            double max = Double.NEGATIVE_INFINITY;
            ArrayList<Integer> al = new ArrayList<Integer>(3);
            for (int v = 0; v < 3; ++v) {
                al.add(new Integer(0));
            }
            this.qstarForMultipleSequencesForProtGeneModels[r][obseq.size() - 1] = al;
            for (int j = 0; j < this.getNumStates(); ++j) {
                for (int l3 = 0; l3 < this.lambda.proteinModels[j].num_states; ++l3) {
                    for (int p = 0; p < 3; ++p) {
                        temp = decodVarLocal[j][p][l3];
                        if (!(temp > max)) continue;
                        al = new ArrayList();
                        al.add(new Integer(j));
                        al.add(new Integer(p));
                        al.add(new Integer(l3));
                        this.qstarForMultipleSequencesForProtGeneModels[r][obseq.size() - 1] = al;
                        max = temp;
                    }
                }
            }
            for (int t = obseq.size() - 2; t >= 0; --t) {
                ArrayList al3;
                ArrayList al2 = this.qstarForMultipleSequencesForProtGeneModels[r][t + 1];
                int j = (Integer)al2.get(0);
                int p = (Integer)al2.get(1);
                int l4 = (Integer)al2.get(2);
                this.qstarForMultipleSequencesForProtGeneModels[r][t] = al3 = this.psiForMultipleSequencesForProtGeneModels[r][t + 1][j][p][l4];
            }
        }
    }

    public void optimalGlobalAccuracyDecodingForMultipleSequencesForProtGeneModels(double[][][][] gammas, int endState, int indexSeq) {
        if (!this.lambda.isReady) {
            System.err.println("THE MODEL HAS TO BE READY BEFORE YOU USE IT");
            System.exit(1);
        }
        MyLogFunc mylog = new MyLogFunc();
        int indexCodingState = (Integer)Model.statesMap.get("coding-GPCR");
        Object loggammas = new double[gammas.length][][][];
        ArrayList[][][][] psi = new ArrayList[gammas.length][this.getNumStates()][3][];
        this.qstarForMultipleSequencesForProtGeneModels = new ArrayList[1][gammas.length];
        ArrayList[][][] lastCodingPosition = new ArrayList[this.getNumStates()][][];
        ArrayList[][][] previousLastCodingPosition = new ArrayList[this.getNumStates()][][];
        boolean[][][] hasBeenInCoding = new boolean[this.getNumStates()][][];
        boolean[][][] previousHasBeenInCoding = new boolean[this.getNumStates()][][];
        boolean[][][] hasReachedFinalState = new boolean[this.getNumStates()][][];
        boolean[][][] previousHasReachedFinalState = new boolean[this.getNumStates()][][];
        double[][][] decodVarLocal = new double[this.getNumStates()][][];
        double[][][] decodVarLocalPrevious = new double[this.getNumStates()][][];
        for (int i = 0; i < this.getNumStates(); ++i) {
            lastCodingPosition[i] = new ArrayList[3][this.lambda.proteinModels[i].num_states];
            previousLastCodingPosition[i] = new ArrayList[3][this.lambda.proteinModels[i].num_states];
            hasBeenInCoding[i] = new boolean[3][this.lambda.proteinModels[i].num_states];
            previousHasBeenInCoding[i] = new boolean[3][this.lambda.proteinModels[i].num_states];
            hasReachedFinalState[i] = new boolean[3][this.lambda.proteinModels[i].num_states];
            previousHasReachedFinalState[i] = new boolean[3][this.lambda.proteinModels[i].num_states];
            decodVarLocal[i] = new double[3][this.lambda.proteinModels[i].num_states];
            decodVarLocalPrevious[i] = new double[3][this.lambda.proteinModels[i].num_states];
            for (int p = 0; p < 3; ++p) {
                for (int l = 0; l < this.lambda.proteinModels[i].num_states; ++l) {
                    lastCodingPosition[i][p][l] = new ArrayList();
                    lastCodingPosition[i][p][l].add(new Integer(-1));
                    lastCodingPosition[i][p][l].add(new Integer(-1));
                    previousLastCodingPosition[i][p][l] = new ArrayList();
                    previousLastCodingPosition[i][p][l].add(new Integer(-1));
                    previousLastCodingPosition[i][p][l].add(new Integer(-1));
                    hasBeenInCoding[i][p][l] = false;
                    previousHasBeenInCoding[i][p][l] = false;
                    hasReachedFinalState[i][p][l] = false;
                    previousHasReachedFinalState[i][p][l] = false;
                }
            }
        }
        int multiple = 1;
        loggammas = new double[gammas.length][this.getNumStates()][3][];
        for (int i = 0; i < this.getNumStates(); ++i) {
            for (int p = 0; p < 3; ++p) {
                decodVarLocal[i][p] = new double[this.lambda.proteinModels[i].num_states];
                decodVarLocalPrevious[i][p] = new double[this.lambda.proteinModels[i].num_states];
                for (int l = 0; l < this.lambda.proteinModels[i].num_states; ++l) {
                    decodVarLocal[i][p][l] = mylog.apply(gammas[0][i][p][l]);
                    decodVarLocalPrevious[i][p][l] = mylog.apply(gammas[0][i][p][l]);
                    if (i != indexCodingState || this.lambda.proteinModels[i].pi[l] != 0.0) continue;
                    decodVarLocal[i][p][l] = Double.NEGATIVE_INFINITY;
                    decodVarLocalPrevious[i][p][l] = Double.NEGATIVE_INFINITY;
                }
            }
        }
        for (int t = 1; t < gammas.length; ++t) {
            int p;
            int j;
            if (t == multiple * 1000) {
                System.out.println("decoding ".concat(String.valueOf(String.valueOf(t))));
                ++multiple;
            }
            for (j = 0; j < this.getNumStates(); ++j) {
                psi[t][j] = new ArrayList[3][this.lambda.proteinModels[j].num_states];
                loggammas[t][j] = new double[3][this.lambda.proteinModels[j].num_states];
                for (p = 0; p < 3; ++p) {
                    int previousp = p - 1;
                    if (previousp == -1) {
                        previousp = 2;
                    }
                    for (int l = 0; l < this.lambda.proteinModels[j].num_states; ++l) {
                        loggammas[t][j][p][l] = mylog.apply(gammas[t][j][p][l]);
                        double tmp = Double.NEGATIVE_INFINITY;
                        double max = Double.NEGATIVE_INFINITY;
                        int bestj = 0;
                        int bestp = 0;
                        int bestl = 0;
                        for (int k = 0; k < this.lambda.condA[j].length; ++k) {
                            int n;
                            int m;
                            int s = this.lambda.condA[j][k];
                            if (s == j) {
                                if (p == 0) {
                                    for (int q = 0; q < this.lambda.proteinModels[j].condA[l].length; ++q) {
                                        m = this.lambda.proteinModels[j].condA[l][q];
                                        tmp = decodVarLocalPrevious[j][previousp][m] + loggammas[t][j][p][l];
                                        if (!(tmp > max)) continue;
                                        bestj = j;
                                        bestp = previousp;
                                        bestl = m;
                                        max = tmp;
                                    }
                                    continue;
                                }
                                if (p == 0 || !((tmp = decodVarLocalPrevious[j][previousp][l] + loggammas[t][j][p][l]) > max)) continue;
                                bestj = j;
                                bestp = previousp;
                                bestl = l;
                                max = tmp;
                                continue;
                            }
                            if (s == j) continue;
                            if (j == indexCodingState) {
                                for (n = 0; n < 3; ++n) {
                                    for (m = 0; m < this.lambda.proteinModels[s].num_states; ++m) {
                                        if (previousHasBeenInCoding[s][n][m]) {
                                            int lastFrame = (Integer)previousLastCodingPosition[s][n][m].get(0);
                                            int lastCodingProtState = (Integer)previousLastCodingPosition[s][n][m].get(1);
                                            if (this.lambda.proteinModels[j].a[lastCodingProtState][l] != 0.0 && lastFrame == 2 && p == 0) {
                                                tmp = decodVarLocalPrevious[s][n][m] + loggammas[t][j][p][l];
                                            } else if (lastCodingProtState == l && lastFrame != 2 && p == lastFrame + 1) {
                                                tmp = decodVarLocalPrevious[s][n][m] + loggammas[t][j][p][l];
                                            }
                                        } else if (!previousHasBeenInCoding[s][n][m]) {
                                            if (this.lambda.proteinModels[j].pi[l] == 0.0) {
                                                tmp = Double.NEGATIVE_INFINITY;
                                            } else if (this.lambda.proteinModels[j].pi[l] > 0.0) {
                                                tmp = decodVarLocalPrevious[s][n][m] + loggammas[t][j][p][l];
                                            }
                                        }
                                        if (!(tmp > max)) continue;
                                        bestj = s;
                                        bestp = n;
                                        bestl = m;
                                        max = tmp;
                                    }
                                }
                                continue;
                            }
                            if (j == indexCodingState) continue;
                            for (n = 0; n < 3; ++n) {
                                for (m = 0; m < this.lambda.proteinModels[s].num_states; ++m) {
                                    tmp = decodVarLocalPrevious[s][n][m] + loggammas[t][j][p][l];
                                    if (!(tmp > max)) continue;
                                    bestj = s;
                                    bestp = n;
                                    bestl = m;
                                    max = tmp;
                                }
                            }
                        }
                        ArrayList<Integer> al = new ArrayList<Integer>();
                        al.add(new Integer(bestj));
                        al.add(new Integer(bestp));
                        al.add(new Integer(bestl));
                        psi[t][j][p][l] = al;
                        decodVarLocal[j][p][l] = max;
                        hasReachedFinalState[j][p][l] = bestj == indexCodingState && bestl == endState ? true : previousHasReachedFinalState[bestj][bestp][bestl];
                        if (bestj == indexCodingState && j != indexCodingState) {
                            ArrayList<Integer> dummy = new ArrayList<Integer>(2);
                            dummy.add(new Integer(bestp));
                            dummy.add(new Integer(bestl));
                            lastCodingPosition[j][p][l] = dummy;
                            hasBeenInCoding[j][p][l] = true;
                            continue;
                        }
                        lastCodingPosition[j][p][l] = previousLastCodingPosition[bestj][bestp][bestl];
                        hasBeenInCoding[j][p][l] = previousHasBeenInCoding[bestj][bestp][bestl];
                    }
                }
            }
            for (j = 0; j < this.getNumStates(); ++j) {
                for (p = 0; p < 3; ++p) {
                    for (int l = 0; l < this.lambda.proteinModels[j].num_states; ++l) {
                        previousLastCodingPosition[j][p][l] = new ArrayList();
                        previousLastCodingPosition[j][p][l].add(lastCodingPosition[j][p][l].get(0));
                        previousLastCodingPosition[j][p][l].add(lastCodingPosition[j][p][l].get(1));
                        previousHasBeenInCoding[j][p][l] = hasBeenInCoding[j][p][l];
                        previousHasReachedFinalState[j][p][l] = hasReachedFinalState[j][p][l];
                        decodVarLocalPrevious[j][p][l] = decodVarLocal[j][p][l];
                    }
                }
            }
        }
        double temp = 0.0;
        double max = Double.NEGATIVE_INFINITY;
        ArrayList<Integer> al = new ArrayList<Integer>();
        for (int v = 0; v < 3; ++v) {
            al.add(new Integer(0));
        }
        this.qstarForMultipleSequencesForProtGeneModels[indexSeq][gammas.length - 1] = al;
        for (int j = 0; j < this.getNumStates(); ++j) {
            for (int l = 0; l < this.lambda.proteinModels[j].num_states; ++l) {
                for (int p = 0; p < 3; ++p) {
                    if (!hasReachedFinalState[j][p][l] && (j != indexCodingState || l != endState) || !((temp = decodVarLocal[j][p][l]) > max)) continue;
                    al = new ArrayList();
                    al.add(new Integer(j));
                    al.add(new Integer(p));
                    al.add(new Integer(l));
                    this.qstarForMultipleSequencesForProtGeneModels[indexSeq][gammas.length - 1] = al;
                    max = temp;
                }
            }
        }
        for (int t = gammas.length - 2; t >= 0; --t) {
            ArrayList al3;
            ArrayList al2 = this.qstarForMultipleSequencesForProtGeneModels[indexSeq][t + 1];
            int j = (Integer)al2.get(0);
            int p = (Integer)al2.get(1);
            int l = (Integer)al2.get(2);
            this.qstarForMultipleSequencesForProtGeneModels[indexSeq][t] = al3 = psi[t + 1][j][p][l];
        }
    }

    public void forwardAlgo() {
        int t;
        int j;
        double sum = 0.0;
        Model model = this.lambda;
        MyLogFunc myLog = new MyLogFunc();
        this.scaleFactor = new double[this.obSeq.size()];
        this.alpha = new double[this.obSeq.size()][this.lambda.num_states];
        for (j = 0; j < this.getNumStates(); ++j) {
            this.alpha[0][j] = this.pi[j] * Math.exp(this.getLogObs()[0][j]);
            this.scaleFactor[0] = this.scaleFactor[0] + this.alpha[0][j];
        }
        j = 0;
        while (j < this.getNumStates()) {
            double[] dArray = this.alpha[0];
            int n = j++;
            dArray[n] = dArray[n] / this.scaleFactor[0];
        }
        for (t = 1; t < this.obSeq.size(); ++t) {
            int j2;
            for (j2 = 0; j2 < this.getNumStates(); ++j2) {
                for (int k = 0; k < this.lambda.condA[j2].length; ++k) {
                    int s = this.lambda.condA[j2][k];
                    double[] dArray = this.alpha[t];
                    int n = j2;
                    dArray[n] = dArray[n] + this.a[s][j2] * this.alpha[t - 1][s];
                }
                double[] dArray = this.alpha[t];
                int n = j2;
                dArray[n] = dArray[n] * Math.exp(this.getLogObs()[t][j2]);
                int n2 = t;
                this.scaleFactor[n2] = this.scaleFactor[n2] + this.alpha[t][j2];
            }
            j2 = 0;
            while (j2 < this.getNumStates()) {
                double[] dArray = this.alpha[t];
                int n = j2++;
                dArray[n] = dArray[n] / this.scaleFactor[t];
            }
        }
        this.obsSeqProba = 0.0;
        for (t = 0; t < this.obSeq.size(); ++t) {
            this.obsSeqProba += Math.log(this.scaleFactor[t]);
        }
    }

    public double forwardAlgoNumCleav(int number) {
        int j;
        if (!this.lambda.isReady) {
            System.err.println("THE MODEL HAS TO BE READY BEFORE YOU USE IT");
            System.exit(1);
        }
        double sum = 0.0;
        double expectation = 0.0;
        MyLogFunc myLog = new MyLogFunc();
        double[] scaleFactorNumCleav = new double[this.obSeq.size()];
        double[][][] alphaNumCleav = new double[this.obSeq.size()][this.lambda.num_states][number];
        double[] probaNumCleav = new double[number];
        int indexcleav1 = (Integer)Model.statesMap.get("PC1-4");
        int indexcleav2 = (Integer)Model.statesMap.get("PC2-4");
        for (j = 0; j < this.getNumStates(); ++j) {
            alphaNumCleav[0][j][0] = this.pi[j] * Math.exp(this.getLogObs()[0][j]);
            scaleFactorNumCleav[0] = scaleFactorNumCleav[0] + this.alpha[0][j];
        }
        alphaNumCleav[0][indexcleav1][1] = this.pi[indexcleav1] * Math.exp(this.getLogObs()[0][indexcleav1]);
        alphaNumCleav[0][indexcleav2][1] = this.pi[indexcleav2] * Math.exp(this.getLogObs()[0][indexcleav2]);
        scaleFactorNumCleav[0] = scaleFactorNumCleav[0] + (alphaNumCleav[0][indexcleav1][1] + alphaNumCleav[0][indexcleav2][1]);
        for (j = 0; j < this.getNumStates(); ++j) {
            for (int r = 0; r < number; ++r) {
                if (scaleFactorNumCleav[0] == 0.0) continue;
                double[] dArray = alphaNumCleav[0][j];
                int n = r;
                dArray[n] = dArray[n] / scaleFactorNumCleav[0];
            }
        }
        for (int t = 1; t < this.obSeq.size(); ++t) {
            int r;
            int j2;
            for (j2 = 0; j2 < this.getNumStates(); ++j2) {
                int s;
                int k;
                if (j2 == indexcleav1 || j2 == indexcleav2) {
                    for (int k2 = 0; k2 < this.lambda.condA[j2].length; ++k2) {
                        int s2 = this.lambda.condA[j2][k2];
                        double[] dArray = alphaNumCleav[t][j2];
                        int n = number - 1;
                        dArray[n] = dArray[n] + this.a[s2][j2] * alphaNumCleav[t - 1][s2][number - 1];
                    }
                    double[] dArray = alphaNumCleav[t][j2];
                    int n = number - 1;
                    dArray[n] = dArray[n] * Math.exp(this.getLogObs()[t][j2]);
                    int n2 = t;
                    scaleFactorNumCleav[n2] = scaleFactorNumCleav[n2] + alphaNumCleav[t][j2][number - 1];
                    for (r = 1; r < number; ++r) {
                        for (k = 0; k < this.lambda.condA[j2].length; ++k) {
                            s = this.lambda.condA[j2][k];
                            double[] dArray2 = alphaNumCleav[t][j2];
                            int n3 = r;
                            dArray2[n3] = dArray2[n3] + this.a[s][j2] * alphaNumCleav[t - 1][s][r - 1];
                        }
                        double[] dArray3 = alphaNumCleav[t][j2];
                        int n4 = r;
                        dArray3[n4] = dArray3[n4] * Math.exp(this.getLogObs()[t][j2]);
                        int n5 = t;
                        scaleFactorNumCleav[n5] = scaleFactorNumCleav[n5] + alphaNumCleav[t][j2][r];
                    }
                    continue;
                }
                if (j2 == indexcleav1 || j2 == indexcleav2) continue;
                for (r = 0; r < number; ++r) {
                    for (k = 0; k < this.lambda.condA[j2].length; ++k) {
                        s = this.lambda.condA[j2][k];
                        double[] dArray = alphaNumCleav[t][j2];
                        int n = r;
                        dArray[n] = dArray[n] + this.a[s][j2] * alphaNumCleav[t - 1][s][r];
                    }
                    double[] dArray = alphaNumCleav[t][j2];
                    int n = r;
                    dArray[n] = dArray[n] * Math.exp(this.getLogObs()[t][j2]);
                    int n6 = t;
                    scaleFactorNumCleav[n6] = scaleFactorNumCleav[n6] + alphaNumCleav[t][j2][r];
                }
            }
            for (j2 = 0; j2 < this.getNumStates(); ++j2) {
                for (r = 0; r < number; ++r) {
                    if (scaleFactorNumCleav[t] == 0.0) continue;
                    double[] dArray = alphaNumCleav[t][j2];
                    int n = r;
                    dArray[n] = dArray[n] / scaleFactorNumCleav[t];
                }
            }
        }
        for (int r = 0; r < number; ++r) {
            double sum1 = 0.0;
            for (int j3 = 0; j3 < this.getNumStates(); ++j3) {
                sum1 += alphaNumCleav[this.obSeq.size() - 1][j3][r];
            }
            expectation += sum1 * new Double(r);
        }
        return expectation;
    }

    public double computeProbaExcludingStates(ArrayList excludedStates) {
        int j;
        double sum = 0.0;
        this.scaleFactorBar = new double[this.obSeq.size()];
        this.alphaBar = new double[this.obSeq.size()][this.lambda.num_states];
        int[] excludedIndexes = new int[excludedStates.size()];
        for (int k = 0; k < excludedStates.size(); ++k) {
            excludedIndexes[k] = (Integer)Model.statesMap.get((String)excludedStates.get(k));
        }
        boolean[] isExcluded = new boolean[this.lambda.num_states];
        for (int r = 0; r < isExcluded.length; ++r) {
            isExcluded[r] = false;
            for (int k = 0; k < excludedIndexes.length; ++k) {
                if (excludedIndexes[k] != r) continue;
                isExcluded[r] = true;
            }
        }
        Model model = this.lambda;
        MyLogFunc myLog = new MyLogFunc();
        double rest = 0.0;
        for (j = 0; j < this.getNumStates(); ++j) {
            if (isExcluded[j]) continue;
            this.alphaBar[0][j] = this.pi[j] * Math.exp(this.getLogObs()[0][j]);
            this.scaleFactorBar[0] = this.scaleFactorBar[0] + this.alphaBar[0][j];
        }
        for (j = 0; j < this.getNumStates(); ++j) {
            if (isExcluded[j]) continue;
            double[] dArray = this.alphaBar[0];
            int n = j;
            dArray[n] = dArray[n] / this.scaleFactorBar[0];
        }
        for (int t = 1; t < this.obSeq.size() - 1; ++t) {
            int j2;
            for (j2 = 0; j2 < this.getNumStates(); ++j2) {
                if (isExcluded[j2]) continue;
                for (int k = 0; k < this.lambda.condA[j2].length; ++k) {
                    int s = this.lambda.condA[j2][k];
                    if (isExcluded[s]) continue;
                    double[] dArray = this.alphaBar[t];
                    int n = j2;
                    dArray[n] = dArray[n] + this.a[s][j2] * this.alphaBar[t - 1][s];
                }
                double[] dArray = this.alphaBar[t];
                int n = j2;
                dArray[n] = dArray[n] * Math.exp(this.getLogObs()[t][j2]);
                int n2 = t;
                this.scaleFactorBar[n2] = this.scaleFactorBar[n2] + this.alphaBar[t][j2];
            }
            j2 = 0;
            while (j2 < this.getNumStates()) {
                double[] dArray = this.alphaBar[t];
                int n = j2++;
                dArray[n] = dArray[n] / this.scaleFactorBar[t];
            }
        }
        for (j = 0; j < this.getNumStates(); ++j) {
            if (isExcluded[j]) continue;
            for (int k = 0; k < this.lambda.condA[j].length; ++k) {
                int s = this.lambda.condA[j][k];
                if (isExcluded[s]) continue;
                double[] dArray = this.alphaBar[this.obSeq.size() - 1];
                int n = j;
                dArray[n] = dArray[n] + this.a[s][j] * this.alphaBar[this.obSeq.size() - 2][s];
            }
            double[] dArray = this.alphaBar[this.obSeq.size() - 1];
            int n = j;
            dArray[n] = dArray[n] * Math.exp(this.getLogObs()[this.obSeq.size() - 1][j]);
            int n3 = this.obSeq.size() - 1;
            this.scaleFactorBar[n3] = this.scaleFactorBar[n3] + this.alphaBar[this.obSeq.size() - 1][j];
        }
        j = 0;
        while (j < this.getNumStates()) {
            double[] dArray = this.alphaBar[this.obSeq.size() - 1];
            int n = j++;
            dArray[n] = dArray[n] / this.scaleFactorBar[this.obSeq.size() - 1];
        }
        double proba = 0.0;
        for (int t = 0; t < this.obSeq.size(); ++t) {
            proba += Math.log(this.scaleFactorBar[t]);
        }
        return proba;
    }

    public double forwardAlgoForMultipleSequences() {
        ArrayList obseq;
        int r;
        if (!this.lambda.isReady) {
            System.err.println("THE MODEL HAS TO BE READY BEFORE YOU USE IT");
            System.exit(1);
        }
        double sum = 0.0;
        Model model = this.lambda;
        MyLogFunc myLog = new MyLogFunc();
        double overallLikelihood = 0.0;
        this.obSeqs = this.obSeqs;
        this.computeLogObsForMultipleSequences();
        this.alphaForMultipleSequences = new double[this.obSeqs.size()][][];
        this.betaForMultipleSequences = new double[this.obSeqs.size()][][];
        this.scaleFactorForMultipleSequences = new double[this.obSeqs.size()][];
        this.obsSeqProbaForMultipleSequences = new double[this.obSeqs.size()];
        for (r = 0; r < this.obSeqs.size(); ++r) {
            obseq = (ArrayList)this.obSeqs.get(r);
            this.alphaForMultipleSequences[r] = new double[obseq.size()][this.lambda.getNumStates()];
            this.betaForMultipleSequences[r] = new double[obseq.size()][this.lambda.getNumStates()];
            this.scaleFactorForMultipleSequences[r] = new double[obseq.size()];
        }
        for (r = 0; r < this.obSeqs.size(); ++r) {
            int t;
            int j;
            obseq = (ArrayList)this.obSeqs.get(r);
            for (j = 0; j < this.getNumStates(); ++j) {
                this.alphaForMultipleSequences[r][0][j] = this.lambda.pi[j] * Math.exp(this.logObsForMultipleSequences[r][0][j]);
                double[] dArray = this.scaleFactorForMultipleSequences[r];
                dArray[0] = dArray[0] + this.alphaForMultipleSequences[r][0][j];
            }
            j = 0;
            while (j < this.getNumStates()) {
                double[] dArray = this.alphaForMultipleSequences[r][0];
                int n = j++;
                dArray[n] = dArray[n] / this.scaleFactorForMultipleSequences[r][0];
            }
            for (t = 1; t < obseq.size(); ++t) {
                int j2;
                for (j2 = 0; j2 < this.getNumStates(); ++j2) {
                    for (int k = 0; k < this.lambda.condA[j2].length; ++k) {
                        int s = this.lambda.condA[j2][k];
                        double[] dArray = this.alphaForMultipleSequences[r][t];
                        int n = j2;
                        dArray[n] = dArray[n] + Math.exp(myLog.apply(this.lambda.a[s][j2]) + myLog.apply(this.alphaForMultipleSequences[r][t - 1][s]));
                    }
                    this.alphaForMultipleSequences[r][t][j2] = Math.exp(this.logObsForMultipleSequences[r][t][j2] + myLog.apply(this.alphaForMultipleSequences[r][t][j2]));
                    double[] dArray = this.scaleFactorForMultipleSequences[r];
                    int n = t;
                    dArray[n] = dArray[n] + this.alphaForMultipleSequences[r][t][j2];
                }
                j2 = 0;
                while (j2 < this.getNumStates()) {
                    double[] dArray = this.alphaForMultipleSequences[r][t];
                    int n = j2++;
                    dArray[n] = dArray[n] / this.scaleFactorForMultipleSequences[r][t];
                }
            }
            for (t = 0; t < obseq.size(); ++t) {
                int n = r;
                this.obsSeqProbaForMultipleSequences[n] = this.obsSeqProbaForMultipleSequences[n] + Math.log(this.scaleFactorForMultipleSequences[r][t]);
            }
            overallLikelihood += this.obsSeqProbaForMultipleSequences[r];
        }
        this.obsSeqProbaForMultipleSequencesOverall = overallLikelihood;
        return overallLikelihood;
    }

    public double forwardAlgoForMultipleSequencesFast() {
        ArrayList obseq;
        int r;
        if (!this.lambda.isReady) {
            System.err.println("THE MODEL HAS TO BE READY BEFORE YOU USE IT");
            System.exit(1);
        }
        double somme = 0.0;
        double bmoy = 0.0;
        this.probaObsForMultipleSequences = new double[this.obSeqs.size()][][];
        for (int r2 = 0; r2 < this.obSeqs.size(); ++r2) {
            ArrayList obseq2 = (ArrayList)this.obSeqs.get(r2);
            this.probaObsForMultipleSequences[r2] = new double[obseq2.size()][this.lambda.a.length];
            for (int t = 0; t < obseq2.size(); ++t) {
                if (this.lambda.hasContinuousObs) continue;
                int[] multiob = (int[])obseq2.get(t);
                for (int i = 0; i < this.lambda.a.length; ++i) {
                    somme = 0.0;
                    bmoy = 0.0;
                    for (int k = 0; k < multiob.length; ++k) {
                        bmoy += this.lambda.b[i][multiob[k]];
                        somme += 1.0;
                    }
                    this.probaObsForMultipleSequences[r2][t][i] = bmoy /= somme;
                }
            }
        }
        double sum = 0.0;
        Model model = this.lambda;
        MyLogFunc myLog = new MyLogFunc();
        double overallLikelihood = 0.0;
        this.obSeqs = this.obSeqs;
        this.alphaForMultipleSequences = new double[this.obSeqs.size()][][];
        this.betaForMultipleSequences = new double[this.obSeqs.size()][][];
        this.scaleFactorForMultipleSequences = new double[this.obSeqs.size()][];
        this.obsSeqProbaForMultipleSequences = new double[this.obSeqs.size()];
        for (r = 0; r < this.obSeqs.size(); ++r) {
            obseq = (ArrayList)this.obSeqs.get(r);
            this.alphaForMultipleSequences[r] = new double[obseq.size()][this.lambda.getNumStates()];
            this.betaForMultipleSequences[r] = new double[obseq.size()][this.lambda.getNumStates()];
            this.scaleFactorForMultipleSequences[r] = new double[obseq.size()];
        }
        for (r = 0; r < this.obSeqs.size(); ++r) {
            int t;
            int j;
            obseq = (ArrayList)this.obSeqs.get(r);
            for (j = 0; j < this.getNumStates(); ++j) {
                this.alphaForMultipleSequences[r][0][j] = this.lambda.pi[j] * this.probaObsForMultipleSequences[r][0][j];
                double[] dArray = this.scaleFactorForMultipleSequences[r];
                dArray[0] = dArray[0] + this.alphaForMultipleSequences[r][0][j];
            }
            j = 0;
            while (j < this.getNumStates()) {
                double[] dArray = this.alphaForMultipleSequences[r][0];
                int n = j++;
                dArray[n] = dArray[n] / this.scaleFactorForMultipleSequences[r][0];
            }
            for (t = 1; t < obseq.size(); ++t) {
                int j2;
                for (j2 = 0; j2 < this.getNumStates(); ++j2) {
                    for (int k = 0; k < this.lambda.condA[j2].length; ++k) {
                        int s = this.lambda.condA[j2][k];
                        double[] dArray = this.alphaForMultipleSequences[r][t];
                        int n = j2;
                        dArray[n] = dArray[n] + this.lambda.a[s][j2] * this.alphaForMultipleSequences[r][t - 1][s];
                    }
                    this.alphaForMultipleSequences[r][t][j2] = this.probaObsForMultipleSequences[r][t][j2] * this.alphaForMultipleSequences[r][t][j2];
                    double[] dArray = this.scaleFactorForMultipleSequences[r];
                    int n = t;
                    dArray[n] = dArray[n] + this.alphaForMultipleSequences[r][t][j2];
                }
                j2 = 0;
                while (j2 < this.getNumStates()) {
                    double[] dArray = this.alphaForMultipleSequences[r][t];
                    int n = j2++;
                    dArray[n] = dArray[n] / this.scaleFactorForMultipleSequences[r][t];
                }
            }
            for (t = 0; t < obseq.size(); ++t) {
                int n = r;
                this.obsSeqProbaForMultipleSequences[n] = this.obsSeqProbaForMultipleSequences[n] + Math.log(this.scaleFactorForMultipleSequences[r][t]);
            }
            overallLikelihood += this.obsSeqProbaForMultipleSequences[r];
        }
        this.obsSeqProbaForMultipleSequencesOverall = overallLikelihood;
        return overallLikelihood;
    }

    public double forwardAlgoForMultipleSequencesForProtGeneModels() {
        int r;
        if (!this.lambda.isReady) {
            System.err.println("THE MODEL HAS TO BE READY BEFORE YOU USE IT");
            System.exit(1);
        }
        double sum = 0.0;
        Model model = this.lambda;
        MyLogFunc myLog = new MyLogFunc();
        double overallLikelihood = 0.0;
        this.obSeqs = this.obSeqs;
        this.computeProbaObsForMultipleSequences();
        this.computeProbaObsForMultipleSequencesForProtGeneModels();
        this.alphaForMultipleSequencesForProtGeneModels = new double[this.obSeqs.size()][][][][];
        this.betaForMultipleSequencesForProtGeneModels = new double[this.obSeqs.size()][][][][];
        this.gammaForMultipleSequencesForProtGeneModels = new double[this.obSeqs.size()][][][][];
        this.scaleFactorForMultipleSequences = new double[this.obSeqs.size()][];
        this.obsSeqProbaForMultipleSequences = new double[this.obSeqs.size()];
        for (r = 0; r < this.obSeqs.size(); ++r) {
            int t;
            int j;
            int p;
            int i;
            int multcount = 1;
            ArrayList obseq = (ArrayList)this.obSeqs.get(r);
            this.alphaForMultipleSequencesForProtGeneModels[r] = new double[obseq.size()][this.lambda.getNumStates()][3][];
            this.betaForMultipleSequencesForProtGeneModels[r] = new double[obseq.size()][this.lambda.getNumStates()][3][];
            this.gammaForMultipleSequencesForProtGeneModels[r] = new double[obseq.size()][this.lambda.getNumStates()][3][];
            this.scaleFactorForMultipleSequences[r] = new double[obseq.size()];
            for (i = 0; i < this.getNumStates(); ++i) {
                for (p = 0; p < 3; ++p) {
                    this.alphaForMultipleSequencesForProtGeneModels[r][0][i][p] = new double[this.lambda.proteinModels[i].num_states];
                    for (j = 0; j < this.lambda.proteinModels[i].num_states; ++j) {
                        this.alphaForMultipleSequencesForProtGeneModels[r][0][i][p][j] = this.lambda.pi[i] * this.probaObsForMultipleSequences[r][0][i] * this.lambda.proteinModels[i].pi[j];
                        double[] dArray = this.scaleFactorForMultipleSequences[r];
                        dArray[0] = dArray[0] + this.alphaForMultipleSequencesForProtGeneModels[r][0][i][p][j];
                    }
                }
            }
            for (i = 0; i < this.getNumStates(); ++i) {
                for (p = 0; p < 3; ++p) {
                    j = 0;
                    while (j < this.lambda.proteinModels[i].num_states) {
                        double[] dArray = this.alphaForMultipleSequencesForProtGeneModels[r][0][i][p];
                        int n = j++;
                        dArray[n] = dArray[n] / this.scaleFactorForMultipleSequences[r][0];
                    }
                }
            }
            for (t = 1; t < obseq.size(); ++t) {
                int p2;
                int l;
                int j2;
                if (t == 1000 * multcount) {
                    System.out.println("induction of forward algorithm ".concat(String.valueOf(String.valueOf(t))));
                    ++multcount;
                }
                for (j2 = 0; j2 < this.getNumStates(); ++j2) {
                    this.alphaForMultipleSequencesForProtGeneModels[r][t][j2] = new double[3][this.lambda.proteinModels[j2].num_states];
                    for (l = 0; l < this.lambda.proteinModels[j2].num_states; ++l) {
                        for (p2 = 0; p2 < 3; ++p2) {
                            int previousp = p2 - 1;
                            if (previousp == -1) {
                                previousp = 2;
                            }
                            for (int k = 0; k < this.lambda.condA[j2].length; ++k) {
                                int s = this.lambda.condA[j2][k];
                                double intermediateSum = 0.0;
                                if (s == j2) {
                                    if (p2 == 0 && t > 1 && t < obseq.size() - 2) {
                                        for (int q = 0; q < this.lambda.proteinModels[j2].condA[l].length; ++q) {
                                            int m = this.lambda.proteinModels[j2].condA[l][q];
                                            intermediateSum += this.alphaForMultipleSequencesForProtGeneModels[r][t - 1][j2][previousp][m] * this.lambda.proteinModels[j2].a[m][l];
                                        }
                                        intermediateSum *= this.probaObsForMultipleSequencesForProtGeneModels[r][t][j2][l];
                                    } else if (p2 != 0 || t <= 1 || t >= obseq.size() - 2) {
                                        intermediateSum = this.alphaForMultipleSequencesForProtGeneModels[r][t - 1][j2][previousp][l];
                                    }
                                } else if (s != j2) {
                                    double mymax = -1.0E10;
                                    for (int m = 0; m < this.lambda.proteinModels[s].num_states; ++m) {
                                        for (int n = 0; n < 3; ++n) {
                                            intermediateSum += this.alphaForMultipleSequencesForProtGeneModels[r][t - 1][s][n][m];
                                        }
                                    }
                                    intermediateSum = this.lambda.proteinModels[j2].pi[l] * 0.05 * intermediateSum;
                                }
                                double[] dArray = this.alphaForMultipleSequencesForProtGeneModels[r][t][j2][p2];
                                int n = l;
                                dArray[n] = dArray[n] + intermediateSum * this.lambda.a[s][j2];
                            }
                            double[] dArray = this.alphaForMultipleSequencesForProtGeneModels[r][t][j2][p2];
                            int n = l;
                            dArray[n] = dArray[n] * this.probaObsForMultipleSequences[r][t][j2];
                            double[] dArray2 = this.scaleFactorForMultipleSequences[r];
                            int n2 = t;
                            dArray2[n2] = dArray2[n2] + this.alphaForMultipleSequencesForProtGeneModels[r][t][j2][p2][l];
                        }
                    }
                }
                for (j2 = 0; j2 < this.getNumStates(); ++j2) {
                    for (l = 0; l < this.lambda.proteinModels[j2].num_states; ++l) {
                        for (p2 = 0; p2 < 3; ++p2) {
                            double[] dArray = this.alphaForMultipleSequencesForProtGeneModels[r][t][j2][p2];
                            int n = l;
                            dArray[n] = dArray[n] / this.scaleFactorForMultipleSequences[r][t];
                        }
                    }
                }
            }
            System.out.println("termination of forward algorithm");
            for (t = 0; t < obseq.size(); ++t) {
                int n = r;
                this.obsSeqProbaForMultipleSequences[n] = this.obsSeqProbaForMultipleSequences[n] + Math.log(this.scaleFactorForMultipleSequences[r][t]);
            }
            overallLikelihood += this.obsSeqProbaForMultipleSequences[r];
        }
        this.obsSeqProbaForMultipleSequencesOverall = overallLikelihood;
        for (r = 0; r < this.obSeqs.size(); ++r) {
            ArrayList obseq = (ArrayList)this.obSeqs.get(r);
            for (int t = 0; t < obseq.size(); ++t) {
                double max = -1.0E10;
                String beststate = "";
                String bestgenestate = "";
                for (int j = 0; j < this.getNumStates(); ++j) {
                    for (int p = 0; p < 3; ++p) {
                        for (int l = 0; l < this.lambda.proteinModels[j].num_states; ++l) {
                            if (!(max <= this.alphaForMultipleSequencesForProtGeneModels[r][t][j][p][l])) continue;
                            beststate = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.lambda.labels[j]))).append(" ").append(p).append(" ").append(this.lambda.proteinModels[j].labels[l])));
                            max = this.alphaForMultipleSequencesForProtGeneModels[r][t][j][p][l];
                            bestgenestate = this.lambda.labels[j];
                        }
                    }
                }
            }
        }
        System.out.println("Final proba ".concat(String.valueOf(String.valueOf(this.obsSeqProbaForMultipleSequencesOverall))));
        return overallLikelihood;
    }

    public double forwardAlgoForMultipleSequencesForProtGeneModels2() {
        int r;
        if (!this.lambda.isReady) {
            System.err.println("THE MODEL HAS TO BE READY BEFORE YOU USE IT");
            System.exit(1);
        }
        double sum = 0.0;
        Model model = this.lambda;
        MyLogFunc myLog = new MyLogFunc();
        double overallLikelihood = 0.0;
        this.obSeqs = this.obSeqs;
        this.computeProbaObsForMultipleSequences();
        this.computeProbaObsForMultipleSequencesForProtGeneModels();
        this.alphaForMultipleSequencesForProtGeneModels = new double[this.obSeqs.size()][][][][];
        this.betaForMultipleSequencesForProtGeneModels = new double[this.obSeqs.size()][][][][];
        this.gammaForMultipleSequencesForProtGeneModels = new double[this.obSeqs.size()][][][][];
        this.scaleFactorForMultipleSequences = new double[this.obSeqs.size()][];
        this.obsSeqProbaForMultipleSequences = new double[this.obSeqs.size()];
        for (r = 0; r < this.obSeqs.size(); ++r) {
            int t;
            int j;
            int p;
            int i;
            int multcount = 1;
            ArrayList obseq = (ArrayList)this.obSeqs.get(r);
            this.alphaForMultipleSequencesForProtGeneModels[r] = new double[obseq.size()][this.lambda.getNumStates()][3][];
            this.betaForMultipleSequencesForProtGeneModels[r] = new double[obseq.size()][this.lambda.getNumStates()][3][];
            this.gammaForMultipleSequencesForProtGeneModels[r] = new double[obseq.size()][this.lambda.getNumStates()][3][];
            this.scaleFactorForMultipleSequences[r] = new double[obseq.size()];
            for (i = 0; i < this.getNumStates(); ++i) {
                for (p = 0; p < 3; ++p) {
                    this.alphaForMultipleSequencesForProtGeneModels[r][0][i][p] = new double[this.lambda.proteinModels[i].num_states];
                    for (j = 0; j < this.lambda.proteinModels[i].num_states; ++j) {
                        this.alphaForMultipleSequencesForProtGeneModels[r][0][i][p][j] = this.lambda.pi[i] * this.probaObsForMultipleSequences[r][0][i] * this.lambda.proteinModels[i].pi[j];
                        double[] dArray = this.scaleFactorForMultipleSequences[r];
                        dArray[0] = dArray[0] + this.alphaForMultipleSequencesForProtGeneModels[r][0][i][p][j];
                    }
                }
            }
            for (i = 0; i < this.getNumStates(); ++i) {
                for (p = 0; p < 3; ++p) {
                    j = 0;
                    while (j < this.lambda.proteinModels[i].num_states) {
                        double[] dArray = this.alphaForMultipleSequencesForProtGeneModels[r][0][i][p];
                        int n = j++;
                        dArray[n] = dArray[n] / this.scaleFactorForMultipleSequences[r][0];
                    }
                }
            }
            for (t = 1; t < obseq.size(); ++t) {
                int p2;
                int l;
                int j2;
                if (t == 1000 * multcount) {
                    System.out.println("induction of forward algorithm ".concat(String.valueOf(String.valueOf(t))));
                    ++multcount;
                }
                for (j2 = 0; j2 < this.getNumStates(); ++j2) {
                    this.alphaForMultipleSequencesForProtGeneModels[r][t][j2] = new double[3][this.lambda.proteinModels[j2].num_states];
                    for (l = 0; l < this.lambda.proteinModels[j2].num_states; ++l) {
                        for (p2 = 0; p2 < 3; ++p2) {
                            int previousp = p2 - 1;
                            if (previousp == -1) {
                                previousp = 2;
                            }
                            for (int k = 0; k < this.lambda.condA[j2].length; ++k) {
                                int s = this.lambda.condA[j2][k];
                                double intermediateSum = 0.0;
                                if (s == j2) {
                                    if (p2 == 0 && t < obseq.size() - 2) {
                                        for (int q = 0; q < this.lambda.proteinModels[j2].condA[l].length; ++q) {
                                            int m = this.lambda.proteinModels[j2].condA[l][q];
                                            intermediateSum += this.alphaForMultipleSequencesForProtGeneModels[r][t - 1][j2][previousp][m] * this.lambda.proteinModels[j2].a[m][l];
                                        }
                                        intermediateSum *= this.probaObsForMultipleSequencesForProtGeneModels[r][t][j2][l];
                                    } else if (p2 != 0 || t >= obseq.size() - 2) {
                                        intermediateSum = this.alphaForMultipleSequencesForProtGeneModels[r][t - 1][j2][previousp][l] * 0.05;
                                    }
                                } else if (s != j2) {
                                    double mymax = Double.NEGATIVE_INFINITY;
                                    for (int m = 0; m < this.lambda.proteinModels[s].num_states; ++m) {
                                        for (int n = 0; n < 3; ++n) {
                                            intermediateSum += this.alphaForMultipleSequencesForProtGeneModels[r][t - 1][s][n][m];
                                        }
                                    }
                                    if (p2 == 0 && t < obseq.size() - 2) {
                                        intermediateSum *= this.lambda.proteinModels[j2].pi[l] * this.probaObsForMultipleSequencesForProtGeneModels[r][t][j2][l];
                                    } else if (p2 != 0 || t >= obseq.size() - 2) {
                                        intermediateSum *= this.lambda.proteinModels[j2].pi[l] * 0.05;
                                    }
                                }
                                double[] dArray = this.alphaForMultipleSequencesForProtGeneModels[r][t][j2][p2];
                                int n = l;
                                dArray[n] = dArray[n] + intermediateSum * this.lambda.a[s][j2];
                            }
                            double[] dArray = this.alphaForMultipleSequencesForProtGeneModels[r][t][j2][p2];
                            int n = l;
                            dArray[n] = dArray[n] * this.probaObsForMultipleSequences[r][t][j2];
                            double[] dArray2 = this.scaleFactorForMultipleSequences[r];
                            int n2 = t;
                            dArray2[n2] = dArray2[n2] + this.alphaForMultipleSequencesForProtGeneModels[r][t][j2][p2][l];
                        }
                    }
                }
                for (j2 = 0; j2 < this.getNumStates(); ++j2) {
                    for (l = 0; l < this.lambda.proteinModels[j2].num_states; ++l) {
                        for (p2 = 0; p2 < 3; ++p2) {
                            double[] dArray = this.alphaForMultipleSequencesForProtGeneModels[r][t][j2][p2];
                            int n = l;
                            dArray[n] = dArray[n] / this.scaleFactorForMultipleSequences[r][t];
                        }
                    }
                }
            }
            System.out.println("termination of forward algorithm");
            for (t = 0; t < obseq.size(); ++t) {
                int n = r;
                this.obsSeqProbaForMultipleSequences[n] = this.obsSeqProbaForMultipleSequences[n] + Math.log(this.scaleFactorForMultipleSequences[r][t]);
            }
            overallLikelihood += this.obsSeqProbaForMultipleSequences[r];
        }
        this.obsSeqProbaForMultipleSequencesOverall = overallLikelihood;
        for (r = 0; r < this.obSeqs.size(); ++r) {
            ArrayList obseq = (ArrayList)this.obSeqs.get(r);
            for (int t = 0; t < obseq.size(); ++t) {
                double max = -1.0E10;
                String beststate = "";
                String bestgenestate = "";
                for (int j = 0; j < this.getNumStates(); ++j) {
                    for (int p = 0; p < 3; ++p) {
                        for (int l = 0; l < this.lambda.proteinModels[j].num_states; ++l) {
                            if (!(max <= this.alphaForMultipleSequencesForProtGeneModels[r][t][j][p][l])) continue;
                            beststate = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.lambda.labels[j]))).append(" ").append(p).append(" ").append(this.lambda.proteinModels[j].labels[l])));
                            max = this.alphaForMultipleSequencesForProtGeneModels[r][t][j][p][l];
                            bestgenestate = this.lambda.labels[j];
                        }
                    }
                }
            }
        }
        System.out.println("Final proba ".concat(String.valueOf(String.valueOf(this.obsSeqProbaForMultipleSequencesOverall))));
        return overallLikelihood;
    }

    public void backwardAlgo() {
        double sum = 0.0;
        for (int j = 0; j < this.getNumStates(); ++j) {
            this.beta[this.len_obseq - 1][j] = 1.0 / this.scaleFactor[this.len_obseq - 1];
        }
        for (int t = this.obSeq.size() - 2; t >= 0; --t) {
            int i = 0;
            while (i < this.getNumStates()) {
                for (int k = 0; k < this.lambda.condAInv[i].length; ++k) {
                    int j = this.lambda.condAInv[i][k];
                    double[] dArray = this.beta[t];
                    int n = i;
                    dArray[n] = dArray[n] + this.a[i][j] * Math.exp(this.getLogObs()[t + 1][j]) * this.beta[t + 1][j];
                }
                double[] dArray = this.beta[t];
                int n = i++;
                dArray[n] = dArray[n] / this.scaleFactor[t];
            }
        }
    }

    public void backwardAlgoForMultipleSequences() {
        for (int r = 0; r < this.obSeqs.size(); ++r) {
            ArrayList obseq = (ArrayList)this.obSeqs.get(r);
            for (int j = 0; j < this.getNumStates(); ++j) {
                this.betaForMultipleSequences[r][obseq.size() - 1][j] = 1.0 / this.scaleFactorForMultipleSequences[r][obseq.size() - 1];
            }
            for (int t = obseq.size() - 2; t >= 0; --t) {
                int i = 0;
                while (i < this.getNumStates()) {
                    for (int k = 0; k < this.lambda.condAInv[i].length; ++k) {
                        int j = this.lambda.condAInv[i][k];
                        double[] dArray = this.betaForMultipleSequences[r][t];
                        int n = i;
                        dArray[n] = dArray[n] + Math.exp(Math.log(this.lambda.a[i][j]) + this.logObsForMultipleSequences[r][t + 1][j] + Math.log(this.betaForMultipleSequences[r][t + 1][j]));
                    }
                    double[] dArray = this.betaForMultipleSequences[r][t];
                    int n = i++;
                    dArray[n] = dArray[n] / this.scaleFactorForMultipleSequences[r][t];
                }
            }
        }
    }

    public void backwardAlgoForMultipleSequencesFast() {
        for (int r = 0; r < this.obSeqs.size(); ++r) {
            ArrayList obseq = (ArrayList)this.obSeqs.get(r);
            for (int j = 0; j < this.getNumStates(); ++j) {
                this.betaForMultipleSequences[r][obseq.size() - 1][j] = 1.0 / this.scaleFactorForMultipleSequences[r][obseq.size() - 1];
            }
            for (int t = obseq.size() - 2; t >= 0; --t) {
                int i = 0;
                while (i < this.getNumStates()) {
                    for (int k = 0; k < this.lambda.condAInv[i].length; ++k) {
                        int j = this.lambda.condAInv[i][k];
                        double[] dArray = this.betaForMultipleSequences[r][t];
                        int n = i;
                        dArray[n] = dArray[n] + this.lambda.a[i][j] * this.probaObsForMultipleSequences[r][t + 1][j] * this.betaForMultipleSequences[r][t + 1][j];
                    }
                    double[] dArray = this.betaForMultipleSequences[r][t];
                    int n = i++;
                    dArray[n] = dArray[n] / this.scaleFactorForMultipleSequences[r][t];
                }
            }
        }
    }

    public void backwardAlgoForMultipleSequencesForProtGeneModels() {
        for (int r = 0; r < this.obSeqs.size(); ++r) {
            int t;
            ArrayList obseq = (ArrayList)this.obSeqs.get(r);
            int multcount = 1;
            for (int i = 0; i < this.getNumStates(); ++i) {
                for (int p = 0; p < 3; ++p) {
                    this.betaForMultipleSequencesForProtGeneModels[r][obseq.size() - 1][i][p] = new double[this.lambda.proteinModels[i].num_states];
                    for (int j = 0; j < this.lambda.proteinModels[i].num_states; ++j) {
                        this.betaForMultipleSequencesForProtGeneModels[r][obseq.size() - 1][i][p][j] = 1.0 / this.scaleFactorForMultipleSequences[r][obseq.size() - 1];
                    }
                }
            }
            for (t = obseq.size() - 2; t >= 0; --t) {
                if (obseq.size() - t == 1000 * multcount) {
                    System.out.println("induction of backward algorithm ".concat(String.valueOf(String.valueOf(obseq.size() - t))));
                    ++multcount;
                }
                for (int j = 0; j < this.getNumStates(); ++j) {
                    this.betaForMultipleSequencesForProtGeneModels[r][t][j] = new double[3][this.lambda.proteinModels[j].num_states];
                    for (int l = 0; l < this.lambda.proteinModels[j].num_states; ++l) {
                        for (int p = 0; p < 3; ++p) {
                            int nextp = p + 1;
                            if (nextp == 3) {
                                nextp = 0;
                            }
                            for (int k = 0; k < this.lambda.condAInv[j].length; ++k) {
                                int s = this.lambda.condAInv[j][k];
                                double intermediateSum = 0.0;
                                if (s == j) {
                                    if (p != 2 || t >= obseq.size() - 3) {
                                        intermediateSum = this.betaForMultipleSequencesForProtGeneModels[r][t + 1][s][nextp][l];
                                    } else if (p == 2 && t < obseq.size() - 3) {
                                        for (int q = 0; q < this.lambda.proteinModels[j].condAInv[l].length; ++q) {
                                            int m = this.lambda.proteinModels[j].condAInv[l][q];
                                            intermediateSum += this.lambda.proteinModels[j].a[l][m] * this.betaForMultipleSequencesForProtGeneModels[r][t + 1][j][nextp][m] * this.probaObsForMultipleSequencesForProtGeneModels[r][t + 1][j][m];
                                        }
                                    }
                                } else if (s != j) {
                                    double mymax = -1.0E10;
                                    for (int m = 0; m < this.lambda.proteinModels[s].num_states; ++m) {
                                        for (int n = 0; n < 3; ++n) {
                                            double sum = this.betaForMultipleSequencesForProtGeneModels[r][t + 1][s][n][m] * this.lambda.proteinModels[s].pi[m];
                                            intermediateSum += this.betaForMultipleSequencesForProtGeneModels[r][t + 1][s][n][m] * this.lambda.proteinModels[s].pi[m];
                                        }
                                    }
                                    intermediateSum = 0.05 * intermediateSum;
                                }
                                double[] dArray = this.betaForMultipleSequencesForProtGeneModels[r][t][j][p];
                                int n = l;
                                dArray[n] = dArray[n] + intermediateSum * this.lambda.a[j][s] * this.probaObsForMultipleSequences[r][t + 1][s];
                            }
                            double[] dArray = this.betaForMultipleSequencesForProtGeneModels[r][t][j][p];
                            int n = l;
                            dArray[n] = dArray[n] / this.scaleFactorForMultipleSequences[r][t];
                        }
                    }
                }
            }
            for (t = 0; t < obseq.size(); ++t) {
                double max = -1.0E10;
                String beststate = "";
                String bestgenestate = "";
                for (int j = 0; j < this.getNumStates(); ++j) {
                    for (int p = 0; p < 3; ++p) {
                        for (int l = 0; l < this.lambda.proteinModels[j].num_states; ++l) {
                            if (!(max <= this.betaForMultipleSequencesForProtGeneModels[r][t][j][p][l])) continue;
                            beststate = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.lambda.labels[j]))).append(" ").append(p).append(" ").append(this.lambda.proteinModels[j].labels[l])));
                            max = this.betaForMultipleSequencesForProtGeneModels[r][t][j][p][l];
                            bestgenestate = this.lambda.labels[j];
                        }
                    }
                }
            }
        }
    }

    public void backwardAlgoForMultipleSequencesForProtGeneModels2() {
        for (int r = 0; r < this.obSeqs.size(); ++r) {
            int t;
            ArrayList obseq = (ArrayList)this.obSeqs.get(r);
            int multcount = 1;
            for (int i = 0; i < this.getNumStates(); ++i) {
                for (int p = 0; p < 3; ++p) {
                    this.betaForMultipleSequencesForProtGeneModels[r][obseq.size() - 1][i][p] = new double[this.lambda.proteinModels[i].num_states];
                    for (int j = 0; j < this.lambda.proteinModels[i].num_states; ++j) {
                        this.betaForMultipleSequencesForProtGeneModels[r][obseq.size() - 1][i][p][j] = 1.0 / this.scaleFactorForMultipleSequences[r][obseq.size() - 1];
                    }
                }
            }
            for (t = obseq.size() - 2; t >= 0; --t) {
                if (obseq.size() - t == 1000 * multcount) {
                    System.out.println("induction of backward algorithm ".concat(String.valueOf(String.valueOf(obseq.size() - t))));
                    ++multcount;
                }
                for (int j = 0; j < this.getNumStates(); ++j) {
                    this.betaForMultipleSequencesForProtGeneModels[r][t][j] = new double[3][this.lambda.proteinModels[j].num_states];
                    for (int l = 0; l < this.lambda.proteinModels[j].num_states; ++l) {
                        for (int p = 0; p < 3; ++p) {
                            int nextp = p + 1;
                            if (nextp == 3) {
                                nextp = 0;
                            }
                            for (int k = 0; k < this.lambda.condAInv[j].length; ++k) {
                                int s = this.lambda.condAInv[j][k];
                                double intermediateSum = 0.0;
                                if (s == j) {
                                    if (p != 2 || t >= obseq.size() - 3) {
                                        intermediateSum = this.betaForMultipleSequencesForProtGeneModels[r][t + 1][j][nextp][l] * 0.05;
                                    } else if (p == 2 && t < obseq.size() - 3) {
                                        for (int q = 0; q < this.lambda.proteinModels[j].condAInv[l].length; ++q) {
                                            int m = this.lambda.proteinModels[j].condAInv[l][q];
                                            intermediateSum += this.lambda.proteinModels[j].a[l][m] * this.betaForMultipleSequencesForProtGeneModels[r][t + 1][j][nextp][m] * this.probaObsForMultipleSequencesForProtGeneModels[r][t + 1][j][m];
                                        }
                                    }
                                } else if (s != j) {
                                    double mymax = Double.NEGATIVE_INFINITY;
                                    for (int m = 0; m < this.lambda.proteinModels[s].num_states; ++m) {
                                        for (int n = 0; n < 3; ++n) {
                                            if (n == 0 && t < obseq.size() - 3) {
                                                intermediateSum += this.probaObsForMultipleSequencesForProtGeneModels[r][t + 1][s][m] * this.betaForMultipleSequencesForProtGeneModels[r][t + 1][s][n][m] * this.lambda.proteinModels[s].pi[m];
                                                continue;
                                            }
                                            if (n == 0 && t < obseq.size() - 3) continue;
                                            intermediateSum += 0.05 * this.betaForMultipleSequencesForProtGeneModels[r][t + 1][s][n][m] * this.lambda.proteinModels[s].pi[m];
                                        }
                                    }
                                }
                                double[] dArray = this.betaForMultipleSequencesForProtGeneModels[r][t][j][p];
                                int n = l;
                                dArray[n] = dArray[n] + intermediateSum * this.lambda.a[j][s] * this.probaObsForMultipleSequences[r][t + 1][s];
                            }
                            double[] dArray = this.betaForMultipleSequencesForProtGeneModels[r][t][j][p];
                            int n = l;
                            dArray[n] = dArray[n] / this.scaleFactorForMultipleSequences[r][t];
                        }
                    }
                }
            }
            for (t = 0; t < obseq.size(); ++t) {
                double max = -1.0E10;
                String beststate = "";
                String bestgenestate = "";
                for (int j = 0; j < this.getNumStates(); ++j) {
                    for (int p = 0; p < 3; ++p) {
                        for (int l = 0; l < this.lambda.proteinModels[j].num_states; ++l) {
                            if (!(max <= this.betaForMultipleSequencesForProtGeneModels[r][t][j][p][l])) continue;
                            beststate = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.lambda.labels[j]))).append(" ").append(p).append(" ").append(this.lambda.proteinModels[j].labels[l])));
                            max = this.betaForMultipleSequencesForProtGeneModels[r][t][j][p][l];
                            bestgenestate = this.lambda.labels[j];
                        }
                    }
                }
            }
        }
    }

    public void backwardAlgoForMultipleSequences(ArrayList constraints) {
        for (int r = 0; r < this.obSeqs.size(); ++r) {
            ArrayList obseq = (ArrayList)this.obSeqs.get(r);
            int[] constraint = (int[])constraints.get(r);
            this.betaForMultipleSequences[r][obseq.size() - 1][constraint[1]] = 1.0 / this.scaleFactorForMultipleSequences[r][obseq.size() - 1];
            for (int t = obseq.size() - 2; t >= 0; --t) {
                int i = 0;
                while (i < this.getNumStates()) {
                    for (int k = 0; k < this.lambda.condAInv[i].length; ++k) {
                        int j = this.lambda.condAInv[i][k];
                        double[] dArray = this.betaForMultipleSequences[r][t];
                        int n = i;
                        dArray[n] = dArray[n] + this.a[i][j] * Math.exp(this.logObsForMultipleSequences[r][t + 1][j]) * this.betaForMultipleSequences[r][t + 1][j];
                    }
                    double[] dArray = this.betaForMultipleSequences[r][t];
                    int n = i++;
                    dArray[n] = dArray[n] / this.scaleFactorForMultipleSequences[r][t];
                }
            }
        }
    }

    public void computeGamma() {
        for (int t = 0; t < this.len_obseq; ++t) {
            int i;
            double sum = 0.0;
            for (i = 0; i < this.getNumStates(); ++i) {
                this.gamma[t][i] = this.alpha[t][i] * this.beta[t][i];
                sum += this.gamma[t][i];
            }
            i = 0;
            while (i < this.getNumStates()) {
                double[] dArray = this.gamma[t];
                int n = i++;
                dArray[n] = dArray[n] / sum;
            }
        }
    }

    public void computeGammaForMultipleSequences() {
        this.gammaForMultipleSequences = new double[this.obSeqs.size()][][];
        for (int r = 0; r < this.obSeqs.size(); ++r) {
            ArrayList obseq = (ArrayList)this.obSeqs.get(r);
            this.gammaForMultipleSequences[r] = new double[obseq.size()][this.lambda.getNumStates()];
            for (int t = 0; t < obseq.size(); ++t) {
                int i;
                double sum = 0.0;
                for (i = 0; i < this.getNumStates(); ++i) {
                    this.gammaForMultipleSequences[r][t][i] = this.alphaForMultipleSequences[r][t][i] * this.betaForMultipleSequences[r][t][i];
                    sum += this.gammaForMultipleSequences[r][t][i];
                }
                i = 0;
                while (i < this.getNumStates()) {
                    double[] dArray = this.gammaForMultipleSequences[r][t];
                    int n = i++;
                    dArray[n] = dArray[n] / sum;
                }
            }
        }
    }

    public void computeGammaForMultipleSequencesForProtGeneModels() {
        for (int r = 0; r < this.obSeqs.size(); ++r) {
            ArrayList obseq = (ArrayList)this.obSeqs.get(r);
            this.gammaForMultipleSequencesForProtGeneModels[r] = new double[obseq.size()][this.lambda.getNumStates()][3][];
            for (int t = 0; t < obseq.size(); ++t) {
                int j;
                int i;
                double sum = 0.0;
                for (i = 0; i < this.getNumStates(); ++i) {
                    this.gammaForMultipleSequencesForProtGeneModels[r][t][i] = new double[3][this.lambda.proteinModels[i].num_states];
                    for (j = 0; j < this.lambda.proteinModels[i].num_states; ++j) {
                        for (int p = 0; p < 3; ++p) {
                            this.gammaForMultipleSequencesForProtGeneModels[r][t][i][p][j] = this.alphaForMultipleSequencesForProtGeneModels[r][t][i][p][j] * this.betaForMultipleSequencesForProtGeneModels[r][t][i][p][j];
                            sum += this.gammaForMultipleSequencesForProtGeneModels[r][t][i][p][j];
                        }
                    }
                }
                for (i = 0; i < this.getNumStates(); ++i) {
                    for (j = 0; j < this.lambda.proteinModels[i].num_states; ++j) {
                        for (int p = 0; p < 3; ++p) {
                            double[] dArray = this.gammaForMultipleSequencesForProtGeneModels[r][t][i][p];
                            int n = j;
                            dArray[n] = dArray[n] / sum;
                        }
                    }
                }
                double max = -1.0E10;
                String beststate = "";
                String bestgenestate = "";
                for (int j2 = 0; j2 < this.getNumStates(); ++j2) {
                    for (int p = 0; p < 3; ++p) {
                        for (int l = 0; l < this.lambda.proteinModels[j2].num_states; ++l) {
                            if (!(max <= this.gammaForMultipleSequencesForProtGeneModels[r][t][j2][p][l])) continue;
                            beststate = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.lambda.labels[j2]))).append(" ").append(p).append(" ").append(this.lambda.proteinModels[j2].labels[l])));
                            max = this.gammaForMultipleSequencesForProtGeneModels[r][t][j2][p][l];
                            bestgenestate = this.lambda.labels[j2];
                        }
                    }
                }
            }
        }
    }

    public double forwardBackwardTrellis() {
        if (!this.lambda.isReady) {
            System.err.println("THE MODEL HAS TO BE READY BEFORE YOU USE IT");
            System.exit(1);
        }
        this.forwardAlgo();
        this.backwardAlgo();
        this.computeGamma();
        return this.obsSeqProba;
    }

    public void forwardAlgoCons() {
        int t;
        int j;
        double sum = 0.0;
        Model model = this.lambda;
        MyLogFunc myLog = new MyLogFunc();
        this.scaleFactor = new double[this.obSeq.size()];
        for (j = 0; j < this.getNumStates(); ++j) {
            this.alpha[0][j] = this.pi[j] * Math.exp(1.0 * this.getLogObs()[0][j] + 0.25 * this.getConsObsLogScores()[0][j]);
            this.scaleFactor[0] = this.scaleFactor[0] + this.alpha[0][j];
        }
        j = 0;
        while (j < this.getNumStates()) {
            double[] dArray = this.alpha[0];
            int n = j++;
            dArray[n] = dArray[n] / this.scaleFactor[0];
        }
        for (t = 1; t < this.obSeq.size() - 1; ++t) {
            int j2;
            for (j2 = 0; j2 < this.getNumStates(); ++j2) {
                for (int k = 0; k < this.lambda.condA[j2].length; ++k) {
                    int s = this.lambda.condA[j2][k];
                    double[] dArray = this.alpha[t];
                    int n = j2;
                    dArray[n] = dArray[n] + this.a[s][j2] * this.alpha[t - 1][s];
                }
                double[] dArray = this.alpha[t];
                int n = j2;
                dArray[n] = dArray[n] * Math.exp(1.0 * this.getLogObs()[t][j2] + 0.25 * this.getConsObsLogScores()[t][j2]);
                int n2 = t;
                this.scaleFactor[n2] = this.scaleFactor[n2] + this.alpha[t][j2];
            }
            j2 = 0;
            while (j2 < this.getNumStates()) {
                double[] dArray = this.alpha[t];
                int n = j2++;
                dArray[n] = dArray[n] / this.scaleFactor[t];
            }
        }
        for (j = 0; j < this.getNumStates(); ++j) {
            for (int k = 0; k < this.lambda.condA[j].length; ++k) {
                int s = this.lambda.condA[j][k];
                double[] dArray = this.alpha[this.obSeq.size() - 1];
                int n = j;
                dArray[n] = dArray[n] + this.a[s][j] * this.alpha[this.obSeq.size() - 2][s];
            }
            double[] dArray = this.alpha[this.obSeq.size() - 1];
            int n = j;
            dArray[n] = dArray[n] * Math.exp(1.0 * this.getLogObs()[this.obSeq.size() - 1][j] + this.getConsObsLogScores()[this.obSeq.size() - 1][j]);
            int n3 = this.obSeq.size() - 1;
            this.scaleFactor[n3] = this.scaleFactor[n3] + this.alpha[this.obSeq.size() - 1][j];
        }
        j = 0;
        while (j < this.getNumStates()) {
            double[] dArray = this.alpha[this.obSeq.size() - 1];
            int n = j++;
            dArray[n] = dArray[n] / this.scaleFactor[this.obSeq.size() - 1];
        }
        this.obsSeqProba = 0.0;
        for (t = 0; t < this.obSeq.size(); ++t) {
            this.obsSeqProba += Math.log(this.scaleFactor[t]);
        }
    }

    public void computeKsi() {
        for (int t = 0; t < this.len_obseq - 1; ++t) {
            int j;
            int i;
            double sum = 0.0;
            for (i = 0; i < this.getNumStates(); ++i) {
                for (j = 0; j < this.getNumStates(); ++j) {
                    this.ksi[t][i][j] = this.alpha[t][i] * this.beta[t + 1][j] * this.lambda.getA(i, j) * Math.exp(this.logObs[t + 1][j]);
                    sum += this.ksi[t][i][j];
                }
            }
            for (i = 0; i < this.getNumStates(); ++i) {
                j = 0;
                while (j < this.getNumStates()) {
                    double[] dArray = this.ksi[t][i];
                    int n = j++;
                    dArray[n] = dArray[n] / sum;
                }
            }
        }
    }

    public void computeKsiForMultipleSequences() {
        this.ksiForMultipleSequences = new double[this.obSeqs.size()][][][];
        for (int r = 0; r < this.obSeqs.size(); ++r) {
            ArrayList obseq = (ArrayList)this.obSeqs.get(r);
            this.ksiForMultipleSequences[r] = new double[obseq.size()][this.lambda.getNumStates()][this.lambda.getNumStates()];
            for (int t = 0; t < obseq.size() - 1; ++t) {
                int j;
                int i;
                double sum = 0.0;
                for (i = 0; i < this.getNumStates(); ++i) {
                    for (j = 0; j < this.getNumStates(); ++j) {
                        this.ksiForMultipleSequences[r][t][i][j] = Math.exp(Math.log(this.alphaForMultipleSequences[r][t][i]) + Math.log(this.betaForMultipleSequences[r][t + 1][j]) + Math.log(this.lambda.getA(i, j)) + this.logObsForMultipleSequences[r][t + 1][j]);
                        sum += this.ksiForMultipleSequences[r][t][i][j];
                    }
                }
                for (i = 0; i < this.getNumStates(); ++i) {
                    j = 0;
                    while (j < this.getNumStates()) {
                        double[] dArray = this.ksiForMultipleSequences[r][t][i];
                        int n = j++;
                        dArray[n] = dArray[n] / sum;
                    }
                }
            }
        }
    }

    private double sumGamma(int t, int i) {
        double sum = 0.0;
        for (int s = 0; s < t; ++s) {
            sum += this.gamma[s][i];
        }
        return sum;
    }

    private double sumKsi(int t, int i, int j) {
        double sum = 0.0;
        for (int s = 0; s < t; ++s) {
            sum += this.ksi[s][i][j];
        }
        return sum;
    }

    public int getNumStates() {
        return this.lambda.getNumStates();
    }

    public int getNumSymbols() {
        return this.lambda.getNumSymbols();
    }

    public int getLenObSeq() {
        return this.len_obseq;
    }

    public double getObsSeqProba() {
        return this.obsSeqProba;
    }

    public void loadHmm(String file) {
        this.loadHmm(file, 1, true);
    }

    public void loadHmm(String file, boolean bXml) {
        this.loadHmm(file, 1, bXml);
    }

    public void loadHmm(String file, int lobseq) {
        this.loadHmm(file, lobseq, true);
    }

    public void loadHmm(String file, int lobseq, boolean bXml) {
        if (bXml) {
            this.loadHmmXml(file, lobseq);
        } else {
            this.loadHmmAscii(file, lobseq);
        }
    }

    public void loadHmmAscii(String file) {
        this.loadHmmAscii(file, 1);
    }

    public void loadHmmAscii(String file, int lobseq) {
        this.lambda.loadSemiModelAscii(file);
        this.len_obseq = lobseq;
        this.alpha = new double[this.len_obseq][this.getNumStates()];
        this.beta = new double[this.len_obseq][this.getNumStates()];
        this.gamma = new double[this.len_obseq][this.getNumStates()];
        this.ksi = new double[this.len_obseq - 1][this.getNumStates()][this.getNumStates()];
        this.delta = new double[this.len_obseq][this.getNumStates()];
        this.psi = new int[this.len_obseq][this.getNumStates()];
        this.qstar = new int[this.len_obseq];
        this.scaleFactor = new double[this.len_obseq];
        this.obSeq = new ArrayList();
    }

    public void loadHmmXml(String file) {
        this.loadHmmXml(file, 1);
    }

    public void loadHmmXml(String file, int lobseq) {
        this.lambda.loadModelXml(file);
        this.len_obseq = lobseq;
        this.alpha = new double[this.len_obseq][this.getNumStates()];
        this.beta = new double[this.len_obseq][this.getNumStates()];
        this.gamma = new double[this.len_obseq][this.getNumStates()];
        this.ksi = new double[this.len_obseq - 1][this.getNumStates()][this.getNumStates()];
        this.delta = new double[this.len_obseq][this.getNumStates()];
        this.psi = new int[this.len_obseq][this.getNumStates()];
        this.qstar = new int[this.len_obseq];
        this.scaleFactor = new double[this.len_obseq];
        this.obSeq = new ArrayList();
    }

    public void initializeSemiModel() {
        this.initializeSemiModel(true);
    }

    public void initializeSemiModel(boolean bRandomize) {
        this.lambda.setProbability(bRandomize);
    }

    public void setModel(Model mod) {
        this.lambda = mod;
    }

    public void setObseqs(ArrayList obseqs) {
        this.obSeqs = obseqs;
    }

    public void setObSeq(ArrayList seq) {
        this.obSeq = seq;
        this.len_obseq = seq.size();
        this.computeLogObs(this.obSeq);
        this.scaleFactor = new double[this.len_obseq];
        this.alpha = new double[this.len_obseq][this.getNumStates()];
        this.beta = new double[this.len_obseq][this.getNumStates()];
        this.gamma = new double[this.len_obseq][this.getNumStates()];
        this.ksi = new double[this.len_obseq - 1][this.getNumStates()][this.getNumStates()];
        this.delta = new double[this.len_obseq][this.getNumStates()];
        this.psi = new int[this.len_obseq][this.getNumStates()];
        this.qstar = new int[this.len_obseq];
    }

    public void setConsObs(double[] co) {
        this.consObs = co;
    }

    public int getObSeq(int t, int k) {
        int[] ali = (int[])this.obSeq.get(k);
        return ali[k];
    }

    public ArrayList getObSeq() {
        return this.obSeq;
    }

    public int[] generateSeq() {
        int[] seq = new int[this.len_obseq];
        block0: for (int t = 0; t < this.len_obseq; ++t) {
            double r = rand.nextDouble();
            double p = 0.0;
            for (int k = 0; k < this.getNumSymbols(); ++k) {
                double s = 0.0;
                for (int i = 0; i < this.getNumStates(); ++i) {
                    s += this.lambda.getB(i, k) * this.lambda.getPi(t, i);
                }
                if (!((p += s) > r)) continue;
                seq[t] = k;
                continue block0;
            }
        }
        return seq;
    }

    public double[][] formatLengthsDist(double[][] matrix) {
        double[][] res = new double[matrix.length][];
        int len = -1;
        double max = -1000.0;
        double min = 1000.0;
        for (int i = 0; i < matrix.length; ++i) {
            int j;
            len = matrix[i].length;
            res[i] = new double[matrix[i].length];
            max = -1000.0;
            min = 1000.0;
            for (j = 0; j < len; ++j) {
                res[i][j] = matrix[i][j];
                min = Math.min(min, res[i][j]);
            }
            if (min < 0.0) {
                for (j = 0; j < len; ++j) {
                    res[i][j] = res[i][j] - min;
                }
            }
            for (j = 0; j < len; ++j) {
                max = Math.max(max, res[i][j]);
            }
            if (!(max > 1.0)) continue;
            for (j = 0; j < len; ++j) {
                res[i][j] = res[i][j] / max;
            }
        }
        return res;
    }

    public void computeConsObsLogScores() {
        this.consObsLogScores = new double[this.consObs.length][this.getNumStates()];
        double lenpdf = this.stateConservations[0].length;
        for (int t = 0; t < this.consObs.length; ++t) {
            int i;
            double sum = 0.0;
            for (i = 0; i < this.getNumStates(); ++i) {
                int index = new Double(Math.floor(lenpdf * Math.ceil(this.consObs[t] * (double)1000) / (double)1000)).intValue() - 1;
                if (index < 0) {
                    index = 0;
                }
                if (this.lambda.getHasConsIndex()[i]) {
                    this.consObsLogScores[t][i] = this.stateConservations[i][index];
                }
                sum += this.consObsLogScores[t][i];
            }
            for (i = 0; i < this.getNumStates(); ++i) {
                this.consObsLogScores[t][i] = Math.log(this.consObsLogScores[t][i] / sum);
            }
        }
        double ratio = new Double(this.lambda.num_states) / new Double(this.lambda.num_symbols);
        if (this.conservationMode) {
            for (int t = 0; t < this.logObs.length; ++t) {
                double sum = 0.0;
                for (int j = 0; j < this.logObs[0].length; ++j) {
                    this.logObs[t][j] = this.logObs[t][j] + 0.25 * this.consObsLogScores[t][j];
                    sum += Math.exp(this.logObs[t][j]);
                }
            }
        }
    }

    public void computeTotalConservation() {
        this.totalconservation = 0.0;
        for (int t = 0; t < this.consObs.length; ++t) {
            this.totalconservation += (double)5 + this.consObs[t];
        }
    }

    public double[][] getConsObsLogScores() {
        return this.consObsLogScores;
    }

    public double computeCompositionScore() {
        ArrayList observations = this.obSeq;
        double[][] frequencies = this.lambda.b;
        MyLogFunc myLog = new MyLogFunc();
        double score = 0.0;
        int size = observations.size();
        for (int i = 0; i < size; ++i) {
            int[] multiObs = (int[])observations.get(i);
            int len = multiObs.length;
            double sumpro = 0.0;
            double sumpep = 0.0;
            for (int j = 0; j < len; ++j) {
                if (multiObs[j] == 21) continue;
                sumpro += frequencies[8][multiObs[j]];
                sumpep += frequencies[9][multiObs[j]];
            }
            score += 0.5 * myLog.apply(sumpro /= (double)len) + 0.5 * myLog.apply(sumpep /= (double)len);
        }
        return score;
    }

    public double computeBestPeptide(int numBestConsidered) {
        MyLogFunc mylogfunc = new MyLogFunc();
        ArrayList CSal = new ArrayList();
        double lengthprotein = this.gamma.length;
        int csindex = -1;
        int pepindex = -1;
        int propepindex = -1;
        int spindex = -1;
        for (int k = 0; k < this.lambda.labels.length; ++k) {
            if (this.lambda.labels[k].equals("PC1-4")) {
                csindex = k;
                continue;
            }
            if (this.lambda.labels[k].equals("PEPTIDE")) {
                pepindex = k;
                continue;
            }
            if (this.lambda.labels[k].equals("PROPEP")) {
                propepindex = k;
                continue;
            }
            if (!this.lambda.labels[k].equals("CLEAV3")) continue;
            spindex = k;
        }
        int spCleavIndex = -1;
        double spCleavScore = 0.0;
        int t = 0;
        while ((double)t < lengthprotein) {
            if (this.gamma[t][spindex] > spCleavScore) {
                spCleavScore = this.gamma[t][spindex];
                spCleavIndex = t;
            }
            ++t;
        }
        for (t = 0; t < this.len_obseq; ++t) {
            ArrayList<Number> al = new ArrayList<Number>(2);
            al.add(new Integer(t));
            al.add(new Double(this.gamma[t][csindex]));
            CSal.add(al);
        }
        ListComparator comp = new ListComparator(1);
        Collections.sort(CSal, comp);
        ArrayList<Integer> bestCSindexes = new ArrayList<Integer>(numBestConsidered);
        for (int t2 = 0; t2 < numBestConsidered; ++t2) {
            ArrayList al = (ArrayList)CSal.get(t2);
            bestCSindexes.add((Integer)al.get(0));
        }
        bestCSindexes.add(new Integer(spCleavIndex));
        Collections.sort(bestCSindexes);
        double bestpepscore = 0.0;
        double bestpropepscore = 0.0;
        double lpep = -1.0;
        double rpep = -1.0;
        double lpropep = -1.0;
        double rpropep = -1.0;
        for (int i = 0; i < bestCSindexes.size() - 1; ++i) {
            int sizei = (Integer)bestCSindexes.get(i);
            for (int j = i + 1; j < bestCSindexes.size(); ++j) {
                int sizej = (Integer)bestCSindexes.get(j);
                if (sizej - sizei <= 1) continue;
                double pepscore = 0.0;
                double propepscore = 0.0;
                for (int k = sizei + 1; k < sizej; ++k) {
                    pepscore += Math.log(this.gamma[k][pepindex]);
                    propepscore += Math.log(this.gamma[k][propepindex]);
                }
                double len = sizej - sizei - 1;
                pepscore /= len;
                propepscore /= len;
                double csscore = 0.0;
                if (sizei != spCleavIndex) {
                    csscore = Math.log(this.gamma[sizei][csindex]) + Math.log(this.gamma[sizej][csindex]);
                } else if (sizei == spCleavIndex) {
                    csscore = Math.log(this.gamma[sizei][spCleavIndex]) + Math.log(this.gamma[sizej][csindex]);
                }
                pepscore += csscore;
                propepscore += csscore;
                double lengthsscore = mylogfunc.apply(this.lambda.pdfLengths[pepindex][sizej - sizei - 1]);
                pepscore += lengthsscore;
                propepscore += lengthsscore;
                if (pepscore > bestpepscore) {
                    bestpepscore = pepscore;
                    lpep = sizei + 2;
                    rpep = sizej;
                }
                if (!(propepscore > bestpropepscore)) continue;
                bestpropepscore = propepscore;
                lpropep = sizei + 2;
                rpropep = sizej;
            }
        }
        double bestscore = bestpropepscore + bestpepscore;
        return bestscore;
    }

    public double computeBestPeptide2(int numBestConsidered, int numPropepResidues) {
        int t;
        MyLogFunc mylogfunc = new MyLogFunc();
        ArrayList CSal = new ArrayList();
        int lengthprotein = this.gamma.length;
        int csindex = -1;
        int pepindex = -1;
        int propepindex = -1;
        int spindex = -1;
        for (int k = 0; k < this.lambda.labels.length; ++k) {
            if (this.lambda.labels[k].equals("PC1-4")) {
                csindex = k;
                continue;
            }
            if (this.lambda.labels[k].equals("PEPTIDE")) {
                pepindex = k;
                continue;
            }
            if (this.lambda.labels[k].equals("CLEAV3")) {
                spindex = k;
                continue;
            }
            if (!this.lambda.labels[k].equals("PROPEP")) continue;
            propepindex = k;
        }
        int spCleavIndex = -1;
        double spCleavScore = 0.0;
        for (t = 0; t < lengthprotein; ++t) {
            if (!(this.gamma[t][spindex] > spCleavScore)) continue;
            spCleavScore = this.gamma[t][spindex];
            spCleavIndex = t;
        }
        for (t = 0; t < this.len_obseq; ++t) {
            ArrayList<Number> al = new ArrayList<Number>(2);
            al.add(new Integer(t));
            al.add(new Double(this.gamma[t][csindex]));
            CSal.add(al);
        }
        ListComparator comp = new ListComparator(1);
        Collections.sort(CSal, comp);
        ArrayList<Integer> bestCSindexes = new ArrayList<Integer>(numBestConsidered);
        for (int t2 = 0; t2 < numBestConsidered; ++t2) {
            ArrayList al = (ArrayList)CSal.get(t2);
            bestCSindexes.add((Integer)al.get(0));
        }
        bestCSindexes.add(new Integer(spCleavIndex));
        bestCSindexes.add(new Integer(this.gamma.length));
        Collections.sort(bestCSindexes);
        double bestpepscore = 0.0;
        double lpep = -1.0;
        double rpep = -1.0;
        for (int i = 0; i < bestCSindexes.size() - 1; ++i) {
            int sizei = (Integer)bestCSindexes.get(i);
            for (int j = i + 1; j < bestCSindexes.size(); ++j) {
                int k;
                int sizej = (Integer)bestCSindexes.get(j);
                if (sizej - sizei <= 2) continue;
                double score = 0.0;
                double numresidue = 0.0;
                for (k = sizei + 2; k < sizej; ++k) {
                    score += Math.log(this.gamma[k][pepindex]);
                    numresidue += 1.0;
                }
                if (sizei - spCleavIndex > numPropepResidues) {
                    for (k = sizei - numPropepResidues - 2; k < sizei - 2; ++k) {
                        score += Math.log(this.gamma[k][propepindex]);
                        numresidue += 1.0;
                    }
                }
                if (sizej + numPropepResidues + 2 <= lengthprotein) {
                    for (k = sizej + 2; k < sizej + numPropepResidues + 2; ++k) {
                        score += Math.log(this.gamma[k][propepindex]);
                        numresidue += 1.0;
                    }
                }
                score /= numresidue;
                double csscore = 0.0;
                double numcleav = 0.0;
                if (sizei - spCleavIndex > 1) {
                    csscore = Math.log(this.gamma[sizei][csindex]);
                    numcleav += 1.0;
                }
                if (sizej != lengthprotein - 1) {
                    csscore += Math.log(this.gamma[sizej][csindex]);
                    numcleav += 1.0;
                }
                if (numcleav != 0.0) {
                    csscore /= numcleav;
                }
                score += csscore;
                double lengthsscore = mylogfunc.apply(this.lambda.pdfLengths[pepindex][sizej - sizei - 1]);
                if (!((score += lengthsscore) > bestpepscore)) continue;
                bestpepscore = score;
                lpep = sizei + 2;
                rpep = sizej;
            }
        }
        return bestpepscore;
    }

    public ArrayList computeBestPeptide3(int numBestConsidered, String localSequence) {
        int t;
        MyLogFunc mylogfunc = new MyLogFunc();
        ArrayList CSal = new ArrayList();
        int lengthprotein = this.gamma.length;
        int cs1index = -1;
        int cs2index = -1;
        int pepindex1 = 0;
        int pepindex2 = 0;
        int pepindex = 0;
        int propep1index = 0;
        int propep2index = 0;
        int propepindex = 0;
        int spindex = -1;
        for (int k = 0; k < this.lambda.labels.length; ++k) {
            if (this.lambda.labels[k].equals("PC1-4")) {
                cs1index = k;
            }
            if (this.lambda.labels[k].equals("PC2-4")) {
                cs2index = k;
                continue;
            }
            if (this.lambda.labels[k].equals("PEPTIDE1")) {
                pepindex1 = k;
                continue;
            }
            if (this.lambda.labels[k].equals("PEPTIDE2")) {
                pepindex2 = k;
                continue;
            }
            if (this.lambda.labels[k].equals("PEPTIDE")) {
                pepindex = k;
                continue;
            }
            if (this.lambda.labels[k].equals("CLEAV3")) {
                spindex = k;
                continue;
            }
            if (this.lambda.labels[k].equals("PROPEP1")) {
                propep1index = k;
                continue;
            }
            if (this.lambda.labels[k].equals("PROPEP2")) {
                propep2index = k;
                continue;
            }
            if (!this.lambda.labels[k].equals("PROPEP")) continue;
            propepindex = k;
        }
        int spCleavIndex = -1;
        double spCleavScore = 0.0;
        for (t = 0; t < lengthprotein; ++t) {
            if (!(this.gamma[t][spindex] > spCleavScore)) continue;
            spCleavScore = this.gamma[t][spindex];
            spCleavIndex = t;
        }
        for (t = 0; t < this.len_obseq; ++t) {
            ArrayList<Number> al = new ArrayList<Number>(2);
            al.add(new Integer(t));
            al.add(new Double(Math.max(this.gamma[t][cs1index], this.gamma[t][cs2index])));
            CSal.add(al);
        }
        ListComparator comp = new ListComparator(1);
        Collections.sort(CSal, comp);
        ArrayList<Integer> bestCSindexes = new ArrayList<Integer>(numBestConsidered);
        for (int t2 = 0; t2 < numBestConsidered; ++t2) {
            ArrayList al = (ArrayList)CSal.get(t2);
            bestCSindexes.add((Integer)al.get(0));
        }
        bestCSindexes.add(new Integer(spCleavIndex));
        bestCSindexes.add(new Integer(lengthprotein - 1));
        Collections.sort(bestCSindexes);
        double bestpepscore = -10000.0;
        double cleavscore = -10000.0;
        double lpep = -1.0;
        double rpep = -1.0;
        for (int i = 0; i < bestCSindexes.size() - 1; ++i) {
            int sizei = (Integer)bestCSindexes.get(i);
            for (int j = i + 1; j < bestCSindexes.size(); ++j) {
                int sizej = (Integer)bestCSindexes.get(j);
                if (sizej - sizei < 5 || sizej - sizei >= 60) continue;
                double score = -1000.0;
                if (sizei < lengthprotein - 2) {
                    double moyenne = 0.0;
                    double maximum = 0.0;
                    double count = 0.0;
                    if (sizej - sizei - 4 >= 0) {
                        for (int r = sizei + 2; r < sizej - 2; ++r) {
                            moyenne += Math.log(Math.max(Math.max(this.gamma[r][pepindex1], this.gamma[r][pepindex2]), this.gamma[r][pepindex]));
                            maximum = Math.log(Math.max(Math.max(Math.max(this.gamma[r][pepindex1], this.gamma[r][pepindex2]), this.gamma[r][pepindex]), maximum));
                            count += 1.0;
                        }
                        moyenne /= count;
                    } else if (sizej - sizei - 4 < 0) {
                        moyenne += Math.log(Math.max(Math.max(this.gamma[sizei + 2][pepindex1], this.gamma[sizei + 2][pepindex2]), this.gamma[sizei + 2][pepindex]));
                    }
                    score = moyenne;
                }
                if (sizej != lengthprotein - 1 && sizei != spCleavIndex) {
                    cleavscore = 0.5 * mylogfunc.apply(this.gamma[sizej][cs1index] + this.gamma[sizej][cs2index]) + 0.5 * mylogfunc.apply(this.gamma[sizei][cs1index] + this.gamma[sizei][cs2index]);
                } else if (sizei == spCleavIndex) {
                    double cumulcleavscore = 0.0;
                    for (int s = sizei - 6; s < sizei + 1; ++s) {
                        cumulcleavscore += this.gamma[s][spindex];
                    }
                    cleavscore = 0.5 * mylogfunc.apply(this.gamma[sizej][cs1index] + this.gamma[sizej][cs2index]) + 0.5 * mylogfunc.apply(cumulcleavscore);
                } else if (sizej == lengthprotein - 1) {
                    cleavscore = mylogfunc.apply(this.gamma[sizei][cs2index]);
                }
                score += cleavscore;
                double lengthsscore = mylogfunc.apply((double)1000 * this.lambda.pdfLengths[pepindex][sizej - sizei - 1]) / (double)2;
                if (!(score > bestpepscore)) continue;
                bestpepscore = score;
                lpep = sizei + 2;
                rpep = sizej - 1;
                if (rpep != (double)(lengthprotein - 2)) continue;
                rpep += 1.0;
            }
        }
        ArrayList<Double> alresult = new ArrayList<Double>();
        alresult.add(new Double(bestpepscore));
        alresult.add(new Double(lpep));
        alresult.add(new Double(rpep));
        return alresult;
    }

    public ArrayList computeBestPeptide4(int numBestConsidered) {
        int t;
        MyLogFunc mylogfunc = new MyLogFunc();
        ArrayList CSal = new ArrayList();
        int lengthprotein = this.gamma.length;
        int cs1index = -1;
        int cs2index = -1;
        int pepindex1 = -1;
        int pepindex2 = -1;
        int propep1index = -1;
        int propep2index = -1;
        int spindex = -1;
        for (int k = 0; k < this.lambda.labels.length; ++k) {
            if (this.lambda.labels[k].equals("PC1-4")) {
                cs1index = k;
            }
            if (this.lambda.labels[k].equals("PC2-4")) {
                cs2index = k;
                continue;
            }
            if (this.lambda.labels[k].equals("PEPTIDE1")) {
                pepindex1 = k;
                continue;
            }
            if (this.lambda.labels[k].equals("PEPTIDE2")) {
                pepindex2 = k;
                continue;
            }
            if (this.lambda.labels[k].equals("CLEAV3")) {
                spindex = k;
                continue;
            }
            if (this.lambda.labels[k].equals("PROPEP1")) {
                propep1index = k;
                continue;
            }
            if (!this.lambda.labels[k].equals("PROPEP2")) continue;
            propep2index = k;
        }
        int spCleavIndex = -1;
        double spCleavScore = 0.0;
        for (t = 0; t < lengthprotein; ++t) {
            if (!(this.gamma[t][spindex] > spCleavScore)) continue;
            spCleavScore = this.gamma[t][spindex];
            spCleavIndex = t;
        }
        for (t = 0; t < this.len_obseq; ++t) {
            ArrayList<Number> al = new ArrayList<Number>(2);
            al.add(new Integer(t));
            al.add(new Double(Math.max(this.gamma[t][cs1index], this.gamma[t][cs2index])));
            CSal.add(al);
        }
        ListComparator comp = new ListComparator(1);
        Collections.sort(CSal, comp);
        ArrayList<Integer> bestCSindexes = new ArrayList<Integer>(numBestConsidered);
        for (int t2 = 0; t2 < numBestConsidered; ++t2) {
            ArrayList al = (ArrayList)CSal.get(t2);
            bestCSindexes.add((Integer)al.get(0));
        }
        bestCSindexes.add(new Integer(spCleavIndex));
        bestCSindexes.add(new Integer(this.gamma.length - 1));
        Collections.sort(bestCSindexes);
        double bestpepscore = -10000.0;
        double lpep = -1.0;
        double rpep = -1.0;
        double bestcleavscore = -100000.0;
        double bestpeplengthscore = -100000.0;
        double bestpeptidescore = -100000.0;
        double cleavscore = -100000.0;
        double peplengthscore = -100000.0;
        double peptidescore = -100000.0;
        for (int i = 0; i < bestCSindexes.size() - 1; ++i) {
            int sizei = (Integer)bestCSindexes.get(i);
            for (int j = i + 1; j < bestCSindexes.size(); ++j) {
                int sizej = (Integer)bestCSindexes.get(j);
                if (sizej - sizei <= 2) continue;
                double score = -1000.0;
                double moyenne = 0.0;
                double count = 0.0;
                if (sizej - sizei - 6 >= 0) {
                    for (int r = sizei + 2; r < sizej - 4; ++r) {
                        moyenne += mylogfunc.apply(Math.max(this.gamma[r][pepindex1], this.gamma[r][pepindex2]));
                        count += 1.0;
                    }
                    score = moyenne /= count;
                }
                peptidescore = moyenne;
                if (sizej != lengthprotein - 1 && sizei != spCleavIndex) {
                    cleavscore = 0.5 * (mylogfunc.apply(Math.max(this.gamma[sizei][cs1index], this.gamma[sizei][cs2index])) + mylogfunc.apply(Math.max(this.gamma[sizej][cs1index], this.gamma[sizej][cs2index])));
                } else if (sizei == spCleavIndex) {
                    cleavscore = mylogfunc.apply(Math.max(this.gamma[sizej][cs1index], this.gamma[sizej][cs2index]));
                } else if (sizej == lengthprotein - 1) {
                    cleavscore = mylogfunc.apply(Math.max(this.gamma[sizei][cs1index], this.gamma[sizei][cs2index]));
                }
                score += cleavscore;
                double lengthsscore = mylogfunc.apply((double)1000 * this.lambda.pdfLengths[pepindex1][sizej - sizei - 1]);
                score += lengthsscore;
                peplengthscore = lengthsscore;
                if (!(score > bestpepscore)) continue;
                bestpepscore = score;
                bestpeptidescore = peptidescore;
                bestcleavscore = cleavscore;
                bestpeplengthscore = peplengthscore;
                lpep = sizei + 2;
                rpep = sizej - 1;
            }
        }
        ArrayList<Double> alresult = new ArrayList<Double>();
        alresult.add(new Double(bestpepscore));
        alresult.add(new Double(lpep));
        alresult.add(new Double(rpep));
        return alresult;
    }

    public void computeLogObs(ArrayList obSeq) {
        MyLogFunc mylog = new MyLogFunc();
        this.logObs = new double[obSeq.size()][this.lambda.a.length];
        double bmoy = 0.0;
        int[] multiob = null;
        for (int t = 0; t < obSeq.size(); ++t) {
            multiob = (int[])obSeq.get(t);
            for (int i = 0; i < this.lambda.a.length; ++i) {
                double somme = 0.0;
                bmoy = 0.0;
                for (int k = 0; k < multiob.length; ++k) {
                    if (multiob[k] == 22) continue;
                    bmoy += mylog.apply(this.lambda.b[i][multiob[k]]);
                    somme += 1.0;
                }
                this.logObs[t][i] = bmoy /= somme;
            }
        }
    }

    public void computeLogObsForMultipleSequences() {
        MyLogFunc mylog = new MyLogFunc();
        this.logObsForMultipleSequences = new double[this.obSeqs.size()][][];
        Algebra alg = new Algebra();
        double[][][][] cov = null;
        double[][][] mus = null;
        DenseDoubleMatrix2D[][] invCovariances = null;
        DenseDoubleMatrix1D[][] muVectors = null;
        if (this.lambda.hasContinuousObs) {
            mus = this.lambda.GaussianMu;
            cov = this.lambda.GaussianCova;
            invCovariances = new DenseDoubleMatrix2D[this.lambda.num_states][this.lambda.numGaussianMixtureComponents];
            muVectors = new DenseDoubleMatrix1D[this.lambda.num_states][this.lambda.numGaussianMixtureComponents];
            for (int i = 0; i < this.lambda.num_states; ++i) {
                for (int j = 0; j < this.lambda.numGaussianMixtureComponents; ++j) {
                    DenseDoubleMatrix2D covariances = new DenseDoubleMatrix2D(this.lambda.dimensionOfData, this.lambda.dimensionOfData);
                    DenseDoubleMatrix1D muVector = new DenseDoubleMatrix1D(this.lambda.dimensionOfData);
                    for (int k = 0; k < this.lambda.dimensionOfData; ++k) {
                        muVector.setQuick(k, mus[i][j][k]);
                        for (int l = 0; l < this.lambda.dimensionOfData; ++l) {
                            covariances.setQuick(k, l, cov[i][j][k][l]);
                        }
                        muVectors[i][j] = muVector;
                    }
                    invCovariances[i][j] = (DenseDoubleMatrix2D)alg.inverse((DoubleMatrix2D)covariances);
                }
            }
        }
        double somme = 0.0;
        double bmoy = 0.0;
        for (int r = 0; r < this.obSeqs.size(); ++r) {
            ArrayList obseq = (ArrayList)this.obSeqs.get(r);
            this.logObsForMultipleSequences[r] = new double[obseq.size()][this.lambda.a.length];
            for (int t = 0; t < obseq.size(); ++t) {
                Object[] multiob;
                if (!this.lambda.hasContinuousObs) {
                    multiob = (int[])obseq.get(t);
                    for (int i = 0; i < this.lambda.a.length; ++i) {
                        somme = 0.0;
                        bmoy = 0.0;
                        for (int k = 0; k < multiob.length; ++k) {
                            bmoy += mylog.apply(this.lambda.b[i][multiob[k]]);
                            somme += 1.0;
                        }
                        this.logObsForMultipleSequences[r][t][i] = bmoy /= somme;
                    }
                    continue;
                }
                if (!this.lambda.hasContinuousObs) continue;
                multiob = (double[])obseq.get(t);
                DenseDoubleMatrix1D multidimensionalobs = new DenseDoubleMatrix1D(multiob.length);
                for (int p = 0; p < multiob.length; ++p) {
                    multidimensionalobs.setQuick(p, (double)multiob[p]);
                }
                for (int i = 0; i < this.lambda.a.length; ++i) {
                    this.logObsForMultipleSequences[r][t][i] = mylog.apply(HmmAlgorithms.computeGaussianMixtureProbability((DoubleMatrix1D)multidimensionalobs, this.lambda.GaussianWeights[i], (DoubleMatrix1D[])muVectors[i], (DoubleMatrix2D[])invCovariances[i]));
                }
            }
        }
    }

    public void computeProbaObsForMultipleSequences() {
        this.probaObsForMultipleSequences = new double[this.obSeqs.size()][][];
        Algebra alg = new Algebra();
        double[][][][] cov = null;
        double[][][] mus = null;
        DenseDoubleMatrix2D[][] invCovariances = null;
        DenseDoubleMatrix1D[][] muVectors = null;
        if (this.lambda.hasContinuousObs) {
            mus = this.lambda.GaussianMu;
            cov = this.lambda.GaussianCova;
            invCovariances = new DenseDoubleMatrix2D[this.lambda.num_states][this.lambda.numGaussianMixtureComponents];
            muVectors = new DenseDoubleMatrix1D[this.lambda.num_states][this.lambda.numGaussianMixtureComponents];
            for (int i = 0; i < this.lambda.num_states; ++i) {
                for (int j = 0; j < this.lambda.numGaussianMixtureComponents; ++j) {
                    DenseDoubleMatrix2D covariances = new DenseDoubleMatrix2D(this.lambda.dimensionOfData, this.lambda.dimensionOfData);
                    DenseDoubleMatrix1D muVector = new DenseDoubleMatrix1D(this.lambda.dimensionOfData);
                    for (int k = 0; k < this.lambda.dimensionOfData; ++k) {
                        muVector.setQuick(k, mus[i][j][k]);
                        for (int l = 0; l < this.lambda.dimensionOfData; ++l) {
                            covariances.setQuick(k, l, cov[i][j][k][l]);
                        }
                        muVectors[i][j] = muVector;
                    }
                    invCovariances[i][j] = (DenseDoubleMatrix2D)alg.inverse((DoubleMatrix2D)covariances);
                }
            }
        }
        double somme = 0.0;
        double bmoy = 0.0;
        for (int r = 0; r < this.obSeqs.size(); ++r) {
            ArrayList obseq = (ArrayList)this.obSeqs.get(r);
            this.probaObsForMultipleSequences[r] = new double[obseq.size()][this.lambda.a.length];
            for (int t = 0; t < obseq.size(); ++t) {
                Object[] multiob;
                if (!this.lambda.hasContinuousObs) {
                    multiob = (int[])obseq.get(t);
                    for (int i = 0; i < this.lambda.a.length; ++i) {
                        somme = 0.0;
                        bmoy = 0.0;
                        for (int k = 0; k < multiob.length; ++k) {
                            if (multiob[k] == 22 || multiob[k] == 21) continue;
                            bmoy += this.lambda.b[i][multiob[k]];
                            somme += 1.0;
                        }
                        this.probaObsForMultipleSequences[r][t][i] = bmoy /= somme;
                    }
                    continue;
                }
                if (!this.lambda.hasContinuousObs) continue;
                multiob = (double[])obseq.get(t);
                DenseDoubleMatrix1D multidimensionalobs = new DenseDoubleMatrix1D(multiob.length);
                for (int p = 0; p < multiob.length; ++p) {
                    multidimensionalobs.setQuick(p, (double)multiob[p]);
                }
                for (int i = 0; i < this.lambda.a.length; ++i) {
                    this.probaObsForMultipleSequences[r][t][i] = HmmAlgorithms.computeGaussianMixtureProbability((DoubleMatrix1D)multidimensionalobs, this.lambda.GaussianWeights[i], (DoubleMatrix1D[])muVectors[i], (DoubleMatrix2D[])invCovariances[i]);
                }
            }
        }
    }

    public void resetTotalLengthTo0() {
        this.lengthOfAllSequences = 0;
    }

    public void computeLogObsForMultipleSequencesForProtGeneModels() {
        MyLogFunc mylog = new MyLogFunc();
        this.logObsForMultipleSequencesForProtGeneModels = new double[this.obSeqs.size()][][][];
        HashMap<String, Integer> symbolsMap = new HashMap<String, Integer>(aminoAcids.length);
        for (int i = 0; i < aminoAcids.length; ++i) {
            symbolsMap.put(aminoAcids[i], new Integer(i));
        }
        SymbolTokenization dnaParser = null;
        SymbolTokenization protParser = null;
        FiniteAlphabet protAlph = (FiniteAlphabet)AlphabetManager.alphabetForName((String)"PROTEIN-TERM");
        FiniteAlphabet dnaAlph = (FiniteAlphabet)AlphabetManager.alphabetForName((String)"DNA");
        SimpleSymbolList codon = null;
        SymbolList aminoacid = null;
        try {
            dnaParser = dnaAlph.getTokenization("token");
            protParser = protAlph.getTokenization("token");
        }
        catch (BioException ex) {
            ex.printStackTrace();
        }
        String[][][] codons = new String[4][4][4];
        for (int i = 0; i < dnasym.length; ++i) {
            for (int j = 0; j < dnasym.length; ++j) {
                for (int k = 0; k < dnasym.length; ++k) {
                    try {
                        codon = new SimpleSymbolList(dnaParser, String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(dnasym[i]))).append(dnasym[j]).append(dnasym[k]))));
                    }
                    catch (IllegalSymbolException ex) {
                        ex.printStackTrace();
                    }
                    try {
                        aminoacid = GeneticCodes.translate(codon);
                    }
                    catch (IllegalAlphabetException ex) {
                        ex.printStackTrace();
                    }
                    codons[i][j][k] = aminoacid.seqString();
                }
            }
        }
        double somme = 0.0;
        double moy = 0.0;
        for (int r = 0; r < this.obSeqs.size(); ++r) {
            int multiple = 1;
            ArrayList obseq = (ArrayList)this.obSeqs.get(r);
            this.logObsForMultipleSequencesForProtGeneModels[r] = new double[obseq.size() - 2][this.lambda.a.length][];
            for (int t = 2; t < obseq.size(); ++t) {
                if (multiple * 1000 == t) {
                    System.out.println("bp ".concat(String.valueOf(String.valueOf(t))));
                    ++multiple;
                }
                int[][] multioball = new int[3][];
                for (int k = 0; k < 3; ++k) {
                    multioball[k] = (int[])obseq.get(t - 2 + k);
                }
                double[][] logobsaverages = new double[this.lambda.a.length][];
                for (int k = 0; k < multioball[2].length; ++k) {
                    String runningAminoacid = codons[multioball[0][k]][multioball[1][k]][multioball[2][k]];
                    int aainteger = (Integer)symbolsMap.get(runningAminoacid);
                    for (int i = 0; i < this.lambda.a.length; ++i) {
                        logobsaverages[i] = new double[this.lambda.proteinModels[i].num_states];
                        this.logObsForMultipleSequencesForProtGeneModels[r][t - 2][i] = new double[this.lambda.proteinModels[i].num_states];
                        for (int j = 0; j < this.lambda.proteinModels[i].num_states; ++j) {
                            double[] dArray = logobsaverages[i];
                            int n = j;
                            dArray[n] = dArray[n] + mylog.apply(this.lambda.proteinModels[i].b[j][aainteger]);
                        }
                    }
                }
                for (int i = 0; i < this.lambda.a.length; ++i) {
                    for (int j = 0; j < this.lambda.proteinModels[i].num_states; ++j) {
                        this.logObsForMultipleSequencesForProtGeneModels[r][t - 2][i][j] = logobsaverages[i][j] / new Integer(multioball[2].length).doubleValue();
                    }
                }
            }
        }
    }

    public void computeProbaObsForMultipleSequencesForProtGeneModels() {
        this.probaObsForMultipleSequencesForProtGeneModels = new double[this.obSeqs.size()][][][];
        HashMap<String, Integer> symbolsMap = new HashMap<String, Integer>(aminoAcids.length);
        for (int i = 0; i < aminoAcids.length; ++i) {
            symbolsMap.put(aminoAcids[i], new Integer(i));
        }
        SymbolTokenization dnaParser = null;
        SymbolTokenization protParser = null;
        FiniteAlphabet protAlph = (FiniteAlphabet)AlphabetManager.alphabetForName((String)"PROTEIN-TERM");
        FiniteAlphabet dnaAlph = (FiniteAlphabet)AlphabetManager.alphabetForName((String)"DNA");
        SimpleSymbolList codon = null;
        SymbolList aminoacid = null;
        try {
            dnaParser = dnaAlph.getTokenization("token");
            protParser = protAlph.getTokenization("token");
        }
        catch (BioException ex) {
            ex.printStackTrace();
        }
        String[][][] codons = new String[4][4][4];
        for (int i = 0; i < dnasym.length; ++i) {
            for (int j = 0; j < dnasym.length; ++j) {
                for (int k = 0; k < dnasym.length; ++k) {
                    try {
                        codon = new SimpleSymbolList(dnaParser, String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(dnasym[i]))).append(dnasym[j]).append(dnasym[k]))));
                    }
                    catch (IllegalSymbolException ex) {
                        ex.printStackTrace();
                    }
                    try {
                        aminoacid = GeneticCodes.translate(codon);
                    }
                    catch (IllegalAlphabetException ex) {
                        ex.printStackTrace();
                    }
                    codons[i][j][k] = aminoacid.seqString();
                }
            }
        }
        double somme = 0.0;
        double moy = 0.0;
        for (int r = 0; r < this.obSeqs.size(); ++r) {
            int multiple = 1;
            ArrayList obseq = (ArrayList)this.obSeqs.get(r);
            this.probaObsForMultipleSequencesForProtGeneModels[r] = new double[obseq.size() - 2][this.lambda.a.length][];
            for (int t = 2; t < obseq.size(); ++t) {
                if (multiple * 1000 == t) {
                    System.out.println("bp ".concat(String.valueOf(String.valueOf(t))));
                    ++multiple;
                }
                int[][] multioball = new int[3][];
                for (int k = 0; k < 3; ++k) {
                    multioball[k] = (int[])obseq.get(t - 2 + k);
                }
                double[][] logobsaverages = new double[this.lambda.a.length][];
                for (int k = 0; k < multioball[2].length; ++k) {
                    String runningAminoacid = codons[multioball[0][k]][multioball[1][k]][multioball[2][k]];
                    int aainteger = (Integer)symbolsMap.get(runningAminoacid);
                    for (int i = 0; i < this.lambda.a.length; ++i) {
                        logobsaverages[i] = new double[this.lambda.proteinModels[i].num_states];
                        this.probaObsForMultipleSequencesForProtGeneModels[r][t - 2][i] = new double[this.lambda.proteinModels[i].num_states];
                        for (int j = 0; j < this.lambda.proteinModels[i].num_states; ++j) {
                            double[] dArray = logobsaverages[i];
                            int n = j;
                            dArray[n] = dArray[n] + this.lambda.proteinModels[i].b[j][aainteger];
                        }
                    }
                }
                for (int i = 0; i < this.lambda.a.length; ++i) {
                    for (int j = 0; j < this.lambda.proteinModels[i].num_states; ++j) {
                        this.probaObsForMultipleSequencesForProtGeneModels[r][t - 2][i][j] = logobsaverages[i][j] / new Integer(multioball[2].length).doubleValue();
                    }
                }
            }
        }
    }

    public double BaumWelchAlgoForMultipleSequences() {
        int j;
        if (!this.lambda.isReady) {
            System.err.println("THE MODEL HAS TO BE READY BEFORE YOU USE IT, USE PREPAREMODEL FUNCTION FROM CLASS HMMMODEL");
            System.exit(1);
        }
        double[][] newA = new double[this.lambda.num_states][this.lambda.num_states];
        double[][] newB = new double[this.lambda.num_states][this.lambda.num_symbols];
        double[] newPi = new double[this.lambda.num_states];
        double overLikelihood = this.forwardAlgoForMultipleSequences();
        this.backwardAlgoForMultipleSequences();
        this.computeGammaForMultipleSequences();
        this.computeKsiForMultipleSequences();
        if (this.lambda.hasContinuousObs) {
            this.reestimationGammaMixtureForMultipleSequences();
        }
        double[] normA = new double[this.lambda.num_states];
        double[] normB = new double[this.lambda.num_states];
        for (int r = 0; r < this.obSeqs.size(); ++r) {
            ArrayList obseq = (ArrayList)this.obSeqs.get(r);
            for (int i = 0; i < this.lambda.num_states; ++i) {
                int t;
                for (t = 0; t < obseq.size() - 1; ++t) {
                    int n = i;
                    normA[n] = normA[n] + this.gammaForMultipleSequences[r][t][i];
                }
                if (!this.lambda.hasContinuousObs) {
                    for (t = 0; t < obseq.size(); ++t) {
                        int[] multiob = (int[])obseq.get(t);
                        for (int s = 0; s < multiob.length; ++s) {
                            double[] dArray = newB[i];
                            int n = ((int[])obseq.get(t))[s];
                            dArray[n] = dArray[n] + this.gammaForMultipleSequences[r][t][i];
                            int n2 = i;
                            normB[n2] = normB[n2] + this.gammaForMultipleSequences[r][t][i];
                        }
                    }
                }
                int n = i;
                newPi[n] = newPi[n] + this.gammaForMultipleSequences[r][0][i];
                for (j = 0; j < this.lambda.num_states; ++j) {
                    for (int t2 = 0; t2 < obseq.size() - 1; ++t2) {
                        double[] dArray = newA[i];
                        int n3 = j;
                        dArray[n3] = dArray[n3] + this.ksiForMultipleSequences[r][t2][i][j];
                    }
                }
            }
        }
        for (int i = 0; i < this.lambda.num_states; ++i) {
            double sum = 0.0;
            for (j = 0; j < this.lambda.num_states; ++j) {
                this.lambda.a[i][j] = newA[i][j] / normA[i];
                sum += this.lambda.a[i][j];
            }
            if (!this.lambda.hasContinuousObs) {
                sum = 0.0;
                for (j = 0; j < this.lambda.num_symbols; ++j) {
                    this.lambda.b[i][j] = newB[i][j] / normB[i];
                    sum += this.lambda.b[i][j];
                }
            }
            this.lambda.pi[i] = newPi[i] / new Double(this.obSeqs.size());
        }
        return overLikelihood;
    }

    public double BaumWelchAlgoForMultipleSequences(ArrayList constraints) {
        int j;
        if (!this.lambda.isReady) {
            System.err.println("THE MODEL HAS TO BE READY BEFORE YOU USE IT");
            System.exit(1);
        }
        double[][] newA = new double[this.lambda.num_states][this.lambda.num_states];
        double[][] newB = new double[this.lambda.num_states][this.lambda.num_symbols];
        double[] newPi = new double[this.lambda.num_states];
        this.computeLogObsForMultipleSequences();
        double overLikelihood = this.forwardAlgoForMultipleSequences();
        this.backwardAlgoForMultipleSequences(constraints);
        this.computeGammaForMultipleSequences();
        this.computeKsiForMultipleSequences();
        double[] normA = new double[this.lambda.num_states];
        double[] normB = new double[this.lambda.num_states];
        for (int r = 0; r < this.obSeqs.size(); ++r) {
            int t;
            int i;
            ArrayList obseq = (ArrayList)this.obSeqs.get(r);
            for (i = 0; i < this.lambda.num_states; ++i) {
                for (t = 0; t < obseq.size() - 1; ++t) {
                    int n = i;
                    normA[n] = normA[n] + this.gammaForMultipleSequences[r][t][i];
                }
                for (t = 0; t < obseq.size(); ++t) {
                    double[] dArray = newB[i];
                    int n = ((int[])obseq.get(t))[0];
                    dArray[n] = dArray[n] + this.gammaForMultipleSequences[r][t][i];
                }
                int n = i;
                newPi[n] = newPi[n] + this.gammaForMultipleSequences[r][0][i];
                for (j = 0; j < this.lambda.num_states; ++j) {
                    for (int t2 = 0; t2 < obseq.size() - 1; ++t2) {
                        double[] dArray = newA[i];
                        int n2 = j;
                        dArray[n2] = dArray[n2] + this.ksiForMultipleSequences[r][t2][i][j];
                    }
                }
            }
            for (i = 0; i < this.lambda.num_states; ++i) {
                for (t = 0; t < obseq.size(); ++t) {
                    int n = i;
                    normB[n] = normB[n] + this.gammaForMultipleSequences[r][t][i];
                }
            }
        }
        for (int i = 0; i < this.lambda.num_states; ++i) {
            double sum = 0.0;
            for (j = 0; j < this.lambda.num_states; ++j) {
                if (!Double.isNaN(normA[i]) && !Double.isNaN(newA[i][j]) && normA[i] != 0.0) {
                    this.lambda.a[i][j] = newA[i][j] / normA[i];
                }
                sum += this.lambda.a[i][j];
            }
            sum = 0.0;
            for (j = 0; j < this.lambda.num_symbols; ++j) {
                if (!Double.isNaN(normB[i]) && !Double.isNaN(newB[i][j]) && normB[i] != 0.0) {
                    this.lambda.b[i][j] = newB[i][j] / normB[i];
                }
                sum += this.lambda.b[i][j];
            }
            if (Double.isNaN(newPi[i])) continue;
            this.lambda.pi[i] = newPi[i] / new Double(this.obSeqs.size());
        }
        return overLikelihood;
    }

    public double[][] getLogObs() {
        return this.logObs;
    }

    public void reinitialiseAlgos() {
        System.out.println("reinitialiseAlgos IS NOT IMPLEMENTED");
    }

    public double computeBICScore(double nullLogLikelihood) {
        double d = new Double(this.lambda.num_symbols - 1) * new Double(this.lambda.num_states);
        double sum = 0.0;
        for (int i = 0; i < this.lambda.num_states; ++i) {
            if (this.lambda.pi[i] == 0.0) continue;
            sum += 1.0;
        }
        d += sum - 1.0;
        double[] r = new double[this.lambda.num_states];
        for (int i = 0; i < this.lambda.num_states; ++i) {
            sum = 0.0;
            for (int j = 0; j < this.lambda.num_states; ++j) {
                if (this.lambda.a[i][j] == 0.0) continue;
                sum += 1.0;
            }
            r[i] = sum;
            d += r[i] - 1.0;
        }
        double numberSequences = new Double(this.obSeqs.size());
        double bic = (double)-2 * (this.obsSeqProbaForMultipleSequencesOverall - nullLogLikelihood) + d * Math.log(numberSequences);
        return bic;
    }

    public double computeBICScoreWithLinkedStates(double nullLogLikelihood, int numLinkedStates) {
        double d = new Double(this.lambda.num_symbols - 1) * new Double(this.lambda.num_states - numLinkedStates);
        double sum = 0.0;
        for (int i = 0; i < this.lambda.num_states; ++i) {
            if (this.lambda.pi[i] == 0.0) continue;
            sum += 1.0;
        }
        d += sum - 1.0;
        double[] r = new double[this.lambda.num_states];
        for (int i = 0; i < this.lambda.num_states; ++i) {
            if (i >= 2 && i <= 1 + numLinkedStates) continue;
            sum = 0.0;
            for (int j = 0; j < this.lambda.num_states; ++j) {
                if (this.lambda.a[i][j] == 0.0) continue;
                sum += 1.0;
            }
            r[i] = sum;
            d += r[i] - 1.0;
        }
        double numberSequences = new Double(this.obSeqs.size());
        double bic = (double)-2 * (this.obsSeqProbaForMultipleSequencesOverall - nullLogLikelihood) + d * Math.log(numberSequences);
        return bic;
    }

    public static double[][] randomizeMatrix(int n, int m, Random generator) {
        double[][] mat = new double[n][m];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < m; ++j) {
                mat[i][j] = generator.nextDouble();
            }
        }
        return mat;
    }

    public static double[] randomizeVector(int n, Random generator) {
        double[] vec = new double[n];
        for (int i = 0; i < n; ++i) {
            vec[i] = generator.nextDouble();
        }
        return vec;
    }

    public static double[][] normaliseMatrix(double[][] mat) {
        double[][] res = new double[mat.length][mat[0].length];
        double sum = 0.0;
        for (int i = 0; i < mat.length; ++i) {
            int j;
            sum = 0.0;
            for (j = 0; j < mat[0].length; ++j) {
                sum += mat[i][j];
            }
            for (j = 0; j < mat[0].length; ++j) {
                res[i][j] = mat[i][j] / sum;
            }
        }
        return res;
    }

    public static double[] normaliseVector(double[] vec) {
        int j;
        double[] res = new double[vec.length];
        double sum = 0.0;
        for (j = 0; j < vec.length; ++j) {
            sum += vec[j];
        }
        for (j = 0; j < vec.length; ++j) {
            res[j] = vec[j] / sum;
        }
        return res;
    }

    public static double computeGaussianMixtureProbability(DoubleMatrix1D obs, double[] c, DoubleMatrix1D[] mu, DoubleMatrix2D[] invcov) {
        double res = 0.0;
        MyLogFunc mylog = new MyLogFunc();
        double dimension = new Double(obs.size());
        Algebra alg = new Algebra();
        for (int k = 0; k < c.length; ++k) {
            DoubleMatrix2D currinvcov = invcov[k];
            double det = 1.0 / alg.det(currinvcov);
            DenseDoubleMatrix1D centeredObs = new DenseDoubleMatrix1D(obs.size());
            for (int m = 0; m < obs.size(); ++m) {
                centeredObs.setQuick(m, obs.getQuick(m) - mu[k].getQuick(m));
            }
            res += c[k] * (1.0 / (Math.pow(Math.PI * 2, dimension / 2.0) * Math.sqrt(det))) * Math.exp(-0.5 * alg.mult(alg.mult(currinvcov, (DoubleMatrix1D)centeredObs), (DoubleMatrix1D)centeredObs));
        }
        return res;
    }

    public void reestimationGammaMixtureForMultipleSequences() {
        int k;
        MyLogFunc mylog = new MyLogFunc();
        this.gammaMixtureForMultipleSequences = new double[this.obSeqs.size()][][][];
        Algebra alg = new Algebra();
        DenseDoubleMatrix2D[][] invCovariances = new DenseDoubleMatrix2D[this.lambda.num_states][this.lambda.numGaussianMixtureComponents];
        double[][][][] cov = this.lambda.GaussianCova;
        for (int i = 0; i < this.lambda.num_states; ++i) {
            for (int j = 0; j < this.lambda.numGaussianMixtureComponents; ++j) {
                DenseDoubleMatrix2D covMat = new DenseDoubleMatrix2D(this.lambda.dimensionOfData, this.lambda.dimensionOfData);
                for (k = 0; k < this.lambda.dimensionOfData; ++k) {
                    for (int l = 0; l < this.lambda.dimensionOfData; ++l) {
                        covMat.setQuick(k, l, cov[i][j][k][l]);
                    }
                }
                invCovariances[i][j] = (DenseDoubleMatrix2D)alg.inverse((DoubleMatrix2D)covMat);
            }
        }
        DenseDoubleMatrix1D[][] mu = new DenseDoubleMatrix1D[this.lambda.num_states][this.lambda.numGaussianMixtureComponents];
        for (int i = 0; i < this.lambda.num_states; ++i) {
            for (int j = 0; j < this.lambda.numGaussianMixtureComponents; ++j) {
                mu[i][j] = new DenseDoubleMatrix1D(this.lambda.dimensionOfData);
                for (k = 0; k < this.lambda.dimensionOfData; ++k) {
                    mu[i][j].setQuick(k, this.lambda.GaussianMu[i][j][k]);
                }
            }
        }
        double[] c = new double[this.lambda.numGaussianMixtureComponents];
        double[] gamm = new double[this.lambda.numGaussianMixtureComponents];
        double[] sumdenomc = new double[this.lambda.num_states];
        double[][] sumnumc = new double[this.lambda.num_states][this.lambda.numGaussianMixtureComponents];
        DenseDoubleMatrix1D[][] sumnummu = new DenseDoubleMatrix1D[this.lambda.num_states][this.lambda.numGaussianMixtureComponents];
        DenseDoubleMatrix2D[][] sumnumcov = new DenseDoubleMatrix2D[this.lambda.num_states][this.lambda.numGaussianMixtureComponents];
        for (int i = 0; i < this.lambda.num_states; ++i) {
            for (int j = 0; j < this.lambda.numGaussianMixtureComponents; ++j) {
                sumnummu[i][j] = new DenseDoubleMatrix1D(this.lambda.dimensionOfData);
                sumnumcov[i][j] = new DenseDoubleMatrix2D(this.lambda.dimensionOfData, this.lambda.dimensionOfData);
            }
        }
        for (int r = 0; r < this.obSeqs.size(); ++r) {
            ArrayList obseq = (ArrayList)this.obSeqs.get(r);
            this.gammaMixtureForMultipleSequences[r] = new double[obseq.size()][this.lambda.num_states][this.lambda.numGaussianMixtureComponents];
            for (int t = 0; t < obseq.size(); ++t) {
                double[] multiob = (double[])obseq.get(t);
                for (int j = 0; j < this.lambda.num_states; ++j) {
                    int k2;
                    c = this.lambda.GaussianWeights[j];
                    gamm = new double[c.length];
                    double somme = 0.0;
                    DenseDoubleMatrix1D centeredObs = new DenseDoubleMatrix1D(this.lambda.dimensionOfData);
                    for (k2 = 0; k2 < c.length; ++k2) {
                        DenseDoubleMatrix2D currinvcov = invCovariances[j][k2];
                        double det = 1.0 / alg.det((DoubleMatrix2D)currinvcov);
                        for (int m = 0; m < this.lambda.dimensionOfData; ++m) {
                            centeredObs.setQuick(m, multiob[m] - mu[j][k2].getQuick(m));
                        }
                        gamm[k2] = c[k2] * (1.0 / (Math.pow(Math.PI * 2, (double)this.lambda.dimensionOfData / 2.0) * Math.sqrt(det))) * Math.exp(-0.5 * alg.mult(alg.mult((DoubleMatrix2D)currinvcov, (DoubleMatrix1D)centeredObs), (DoubleMatrix1D)centeredObs));
                        somme += gamm[k2];
                    }
                    for (k2 = 0; k2 < c.length; ++k2) {
                        this.gammaMixtureForMultipleSequences[r][t][j][k2] = Math.exp(mylog.apply(gamm[k2] / somme) + mylog.apply(this.gammaForMultipleSequences[r][t][j]));
                        int n = j;
                        sumdenomc[n] = sumdenomc[n] + this.gammaMixtureForMultipleSequences[r][t][j][k2];
                        double[] dArray = sumnumc[j];
                        int n2 = k2;
                        dArray[n2] = dArray[n2] + this.gammaMixtureForMultipleSequences[r][t][j][k2];
                        for (int w = 0; w < this.lambda.dimensionOfData; ++w) {
                            double dummy = sumnummu[j][k2].getQuick(w) + this.gammaMixtureForMultipleSequences[r][t][j][k2] * multiob[w];
                            sumnummu[j][k2].setQuick(w, dummy);
                        }
                        for (int m = 0; m < this.lambda.dimensionOfData; ++m) {
                            centeredObs.setQuick(m, multiob[m] - mu[j][k2].getQuick(m));
                        }
                        DenseDoubleMatrix2D covar = (DenseDoubleMatrix2D)alg.multOuter((DoubleMatrix1D)centeredObs, (DoubleMatrix1D)centeredObs, null);
                        if (covar.getQuick(0, 0) < 1.0E-20 || covar.getQuick(1, 1) < 1.0E-20) {
                            System.out.println("VERY SMALL NUMBERS mus");
                            for (int m = 0; m < this.lambda.dimensionOfData; ++m) {
                                System.out.println(String.valueOf(String.valueOf(new StringBuffer("t=").append(t).append(" j=").append(j).append(" k=").append(k2).append(" m=").append(m).append(" ").append(multiob[m]).append(" ").append(mu[j][k2].getQuick(m)))));
                                System.out.println(String.valueOf(String.valueOf(new StringBuffer("corresponding gamma t=").append(t).append(" j=").append(j).append(" k=").append(k2).append(" ").append(this.gammaMixtureForMultipleSequences[r][t][j][k2]).append(" somme=").append(somme))));
                            }
                        }
                        for (int p = 0; p < sumnumcov[j][k2].rows(); ++p) {
                            for (int q = 0; q < sumnumcov[j][k2].columns(); ++q) {
                                double dummy = sumnumcov[j][k2].getQuick(p, q) + covar.getQuick(p, q) * this.gammaMixtureForMultipleSequences[r][t][j][k2];
                                sumnumcov[j][k2].setQuick(p, q, dummy);
                            }
                        }
                    }
                }
            }
        }
        for (int j = 0; j < this.lambda.num_states; ++j) {
            for (int k3 = 0; k3 < this.lambda.numGaussianMixtureComponents; ++k3) {
                this.lambda.GaussianWeights[j][k3] = sumnumc[j][k3] / sumdenomc[j];
                for (int l = 0; l < this.lambda.dimensionOfData; ++l) {
                    this.lambda.GaussianMu[j][k3][l] = sumnummu[j][k3].getQuick(l) / sumnumc[j][k3];
                    for (int s = 0; s < this.lambda.dimensionOfData; ++s) {
                        this.lambda.GaussianCova[j][k3][l][s] = sumnumcov[j][k3].getQuick(l, s) / sumnumc[j][k3];
                    }
                }
            }
        }
    }

    public static void printOut2DArray(double[][] mat) {
        System.out.println("Printing 2D array");
        for (int i = 0; i < mat.length; ++i) {
            System.out.print(String.valueOf(String.valueOf(i)).concat("\t"));
            for (int j = 0; j < mat[0].length; ++j) {
                System.out.print(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(j))).append(":").append(mat[i][j]).append("\t"))));
            }
            System.out.println();
        }
    }

    public static void printOut2DMatrix(DoubleMatrix2D mat) {
        System.out.println("Printing 2D matrix");
        for (int i = 0; i < mat.rows(); ++i) {
            System.out.print(String.valueOf(String.valueOf(i)).concat("\t"));
            for (int j = 0; j < mat.columns(); ++j) {
                System.out.print(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(j))).append(":").append(mat.getQuick(i, j)).append("\t"))));
            }
            System.out.println();
        }
    }

    public static void printOut1DMatrix(DoubleMatrix1D mat) {
        System.out.println("Printing 1D matrix");
        for (int i = 0; i < mat.size(); ++i) {
            System.out.print(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(i))).append(":").append(mat.getQuick(i)).append("\t"))));
            System.out.println();
        }
    }

    public static ArrayList[] generateHMMContinuousSample(int sizeSequence, double[] pi, double[][] transitionMat, double[][] weightvec, double[][][] mus, double[][][] sigmas, RandomEngine twister) {
        int j;
        int i;
        ArrayList[] result = new ArrayList[2];
        ArrayList<double[]> observations = new ArrayList<double[]>();
        ArrayList<Integer> hiddenstates = new ArrayList<Integer>();
        int numstates = transitionMat.length;
        int numMixture = weightvec[0].length;
        int dimension = mus[0][0].length;
        int[] sequOfStates = new int[sizeSequence];
        double[] initialIntervalPoints = new double[numstates];
        double[][] transitionIntervalPoints = new double[numstates][numstates];
        double[][] weightIntervalPoints = new double[numstates][numMixture];
        initialIntervalPoints[0] = 0.0;
        if (numstates >= 1) {
            for (int j2 = 1; j2 < numstates; ++j2) {
                initialIntervalPoints[j2] = initialIntervalPoints[j2 - 1] + pi[j2 - 1];
            }
        }
        for (i = 0; i < numstates; ++i) {
            transitionIntervalPoints[i][0] = 0.0;
            if (numstates < 1) continue;
            for (j = 1; j < numstates; ++j) {
                transitionIntervalPoints[i][j] = transitionIntervalPoints[i][j - 1] + transitionMat[i][j - 1];
            }
        }
        for (i = 0; i < numstates; ++i) {
            weightIntervalPoints[i][0] = 0.0;
            if (numMixture < 1) continue;
            for (j = 1; j < numMixture; ++j) {
                weightIntervalPoints[i][j] = weightIntervalPoints[i][j - 1] + weightvec[i][j - 1];
            }
        }
        Uniform stateGenerator = new Uniform(0.0, 1.0, twister);
        double raw = stateGenerator.nextDouble();
        int state = 0;
        sequOfStates[0] = numstates - 1;
        for (int j3 = 0; j3 < numstates - 1; ++j3) {
            if (!(raw > initialIntervalPoints[j3]) || !(raw <= initialIntervalPoints[j3 + 1])) continue;
            sequOfStates[0] = j3;
        }
        for (int t = 1; t < sizeSequence; ++t) {
            raw = stateGenerator.nextDouble();
            state = sequOfStates[t - 1];
            sequOfStates[t] = numstates - 1;
            for (int j4 = 0; j4 < numstates - 1; ++j4) {
                if (!(raw > transitionIntervalPoints[state][j4]) || !(raw <= transitionIntervalPoints[state][j4 + 1])) continue;
                sequOfStates[t] = j4;
            }
        }
        Normal gaussianGenerator = null;
        double covariance = 0.0;
        double[] means = new double[dimension];
        for (int t = 0; t < sizeSequence; ++t) {
            int currentState = sequOfStates[t];
            double[] obsdat = new double[dimension];
            int mixtureChosen = numMixture - 1;
            for (int j5 = 0; j5 < numMixture - 1; ++j5) {
                double rawweight = stateGenerator.nextDouble();
                if (!(rawweight > weightIntervalPoints[currentState][j5]) || !(rawweight <= weightIntervalPoints[currentState][j5 + 1])) continue;
                mixtureChosen = j5;
            }
            double dummy = 1.0;
            for (int k = 0; k < dimension; ++k) {
                double number;
                gaussianGenerator = new Normal(mus[currentState][mixtureChosen][k], sigmas[currentState][mixtureChosen][k], twister);
                obsdat[k] = number = gaussianGenerator.nextDouble();
                dummy *= obsdat[k] - mus[currentState][mixtureChosen][k];
                int n = k;
                means[n] = means[n] + (obsdat[k] - mus[currentState][mixtureChosen][k]);
            }
            covariance += dummy;
            observations.add(obsdat);
            hiddenstates.add(new Integer(currentState));
        }
        result[0] = observations;
        result[1] = hiddenstates;
        double size = new Integer(sizeSequence).doubleValue();
        return result;
    }

    public static void resetAminoAcidList(String[] newaa) {
        aminoAcids = new String[newaa.length];
        for (int i = 0; i < aminoAcids.length; ++i) {
            HmmAlgorithms.aminoAcids[i] = newaa[i];
        }
    }

    static {
        MAX_ITERATION = 100;
        MIN_ERROR = 0.001;
        MAX_LEN_OBSEQ = 10;
        aminoAcids = new String[]{"A", "R", "N", "D", "C", "Q", "E", "G", "H", "I", "L", "K", "M", "F", "P", "S", "T", "W", "Y", "V", "-", "Z"};
        dnasym = new String[]{"A", "C", "G", "T"};
        rand = new Random();
    }
}

