/*
 * Decompiled with CFR 0.152.
 */
package trimali;

import com.ibm.xml.parser.TXDocument;
import com.stevesoft.pat.Regex;
import com.sun.xml.tree.XmlDocument;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import java.util.StringTokenizer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import trimali.HmmAlgorithms;
import trimali.MyLogFunc;

public class Model {
    public static final int MAX_NUM_STATES = 1000;
    public static final int MAX_NUM_SYMBOLS = 1000;
    public static double MIN_PROB;
    static final String IBM_PARSER = "ibm";
    static final String SUN_PARSER = "sun";
    public String PARSER_NAME = "sun";
    public static Random rand;
    public boolean hasInhomogeneousLengths = false;
    public boolean isReady = false;
    public int num_states = 0;
    public String[] states;
    public String[] symbols;
    public static HashMap statesMap;
    public static HashMap symbolsMap;
    public static final String CHAIN = "CHAIN";
    public static final String PROPEPTIDE1 = "PROPEP1";
    public static final String PROPEPTIDE2 = "PROPEP2";
    public static final String PROPEPTIDE = "PROPEP";
    public static final String PEPTIDE = "PEPTIDE";
    public static final String PEPTIDE1 = "PEPTIDE1";
    public static final String PEPTIDE2 = "PEPTIDE2";
    public static final String PC1END = "PC1-5";
    public static final String PC1_1 = "PC1-1";
    public static final String PC1_2 = "PC1-2";
    public static final String PC1_3 = "PC1-3";
    public static final String PC1_4 = "PC1-4";
    public static final String PC1_5 = "PC1-5";
    public static final String PC2_1 = "PC2-1";
    public static final String PC2_2 = "PC2-2";
    public static final String PC2_3 = "PC2-3";
    public static final String PC2_4 = "PC2-4";
    public static final String PC2_5 = "PC2-5";
    public static final String SPEND = "CLEAV3";
    public static final String MITOEND = "MITOCLEAV3";
    public static final String MITOCHONDRIAL = "MITOCHONDRIAL";
    public static final String HYDRO = "HYDRO";
    public static final String NTER = "NTER";
    public static final String CTER = "CTER";
    public static final String residues = "ARNDCQEGHILKMFPSTWYVZ";
    public static String[] aminoAcids;
    public int num_symbols = 0;
    public int ll_bound = 0;
    public int ur_bound = 0;
    public double[][] a;
    public int[][] condA;
    public int[][] condAInv;
    public double[][] b;
    public double[][] logA;
    public double[] logPi;
    public double[] pi;
    public transient int[] l_limit;
    public transient int[] r_limit;
    public double[][] lengthsProb;
    public double[] lengths_mu;
    public double[] lengths_sigma;
    public double[][] pdfLengths;
    public boolean[] hasInhomogeneousLength;
    public boolean[] hasConsIndex;
    public double[][] statesConservation;
    public double[] consmu;
    public double[] conssigma;
    public int[] numbercdps;
    public String[] labels;
    public boolean hasContinuousObs = false;
    public double[][][] GaussianMu;
    public double[][][][] GaussianCova;
    public double[][] GaussianWeights;
    public int numGaussianMixtureComponents;
    public int dimensionOfData;
    public Model[] proteinModels;

    public static int getMaxNumStates() {
        return 1000;
    }

    public static int getMaxNumSymbols() {
        return 1000;
    }

    public static double getMinProb() {
        return MIN_PROB;
    }

    public static double setMinProb(double p) {
        if (p >= 0.0 && p < 1.0) {
            MIN_PROB = p;
        }
        return MIN_PROB;
    }

    public Model() {
        symbolsMap = new HashMap(aminoAcids.length);
        for (int i = 0; i < aminoAcids.length; ++i) {
            symbolsMap.put(aminoAcids[i], new Integer(i));
        }
    }

    public Model(boolean hasInhomoLengths) {
        symbolsMap = new HashMap(aminoAcids.length);
        for (int i = 0; i < aminoAcids.length; ++i) {
            symbolsMap.put(aminoAcids[i], new Integer(i));
        }
        this.hasInhomogeneousLengths = hasInhomoLengths;
    }

    public Model(boolean hasContinuousObs, int numStates, int numGaussianMixtureComponents, int dimensionOfData) {
        this.hasContinuousObs = hasContinuousObs;
        Random generator = new Random();
        this.a = HmmAlgorithms.normaliseMatrix(HmmAlgorithms.randomizeMatrix(numStates, numStates, generator));
        this.pi = HmmAlgorithms.normaliseVector(HmmAlgorithms.randomizeVector(numStates, generator));
        this.numGaussianMixtureComponents = numGaussianMixtureComponents;
        this.dimensionOfData = dimensionOfData;
        this.GaussianWeights = HmmAlgorithms.normaliseMatrix(HmmAlgorithms.randomizeMatrix(numStates, numGaussianMixtureComponents, generator));
        this.GaussianMu = new double[numStates][numGaussianMixtureComponents][dimensionOfData];
        this.GaussianCova = new double[numStates][numGaussianMixtureComponents][dimensionOfData][dimensionOfData];
        this.num_states = numStates;
        this.logA = this.getLogA();
        this.logPi = this.getLogPi();
        this.consmu = this.getStatesConservationMu();
        this.conssigma = this.getStatesConservationSigma();
    }

    public void normalizeRowA(int i) {
        double sum = 0.0;
        for (int j = this.l_limit[i]; j <= this.r_limit[i]; ++j) {
            sum += this.a[i][j];
        }
        double factor = (1.0 - (double)(this.r_limit[i] - this.l_limit[i] + 1) * MIN_PROB) / (sum -= (double)(this.r_limit[i] - this.l_limit[i] + 1) * MIN_PROB);
        int j = this.l_limit[i];
        while (j <= this.r_limit[i]) {
            double[] dArray = this.a[i];
            int n = j;
            dArray[n] = dArray[n] * factor;
            double[] dArray2 = this.a[i];
            int n2 = j++;
            dArray2[n2] = dArray2[n2] + (1.0 - factor) * MIN_PROB;
        }
    }

    public void normalizeRowA() {
        for (int i = 0; i < this.num_states; ++i) {
            this.normalizeRowA(i);
        }
    }

    public void normalizeRowB(int i) {
        double sum = 0.0;
        for (int k = 0; k < this.num_symbols; ++k) {
            sum += this.b[i][k];
        }
        double factor = (1.0 - (double)this.num_symbols * MIN_PROB) / (sum -= (double)this.num_symbols * MIN_PROB);
        int k = 0;
        while (k < this.num_symbols) {
            double[] dArray = this.b[i];
            int n = k;
            dArray[n] = dArray[n] * factor;
            double[] dArray2 = this.b[i];
            int n2 = k++;
            dArray2[n2] = dArray2[n2] + (1.0 - factor) * MIN_PROB;
        }
    }

    public void normalizeRowB() {
        for (int i = 0; i < this.num_states; ++i) {
            this.normalizeRowB(i);
        }
    }

    public void normalizeRowPi() {
        double sum = 0.0;
        for (int j = 0; j < this.num_states; ++j) {
            sum += this.pi[j];
        }
        double factor = (1.0 - (double)this.num_states * MIN_PROB) / (sum -= (double)this.num_states * MIN_PROB);
        int j = 0;
        while (j < this.num_states) {
            int n = j;
            this.pi[n] = this.pi[n] * factor;
            int n2 = j++;
            this.pi[n2] = this.pi[n2] + (1.0 - factor) * MIN_PROB;
        }
    }

    public int getNumStates() {
        return this.a.length;
    }

    public int getNumSymbols() {
        return this.num_symbols;
    }

    public String[] getSymbols() {
        return this.symbols;
    }

    public int getLLimit(int i) {
        return this.l_limit[i];
    }

    public void setA() {
        this.setA(true);
    }

    public void setA(boolean bRandomize) {
        if (bRandomize) {
            for (int i = 0; i < this.num_states; ++i) {
                for (int j = this.l_limit[i]; j <= this.r_limit[i]; ++j) {
                    this.a[i][j] = rand.nextDouble() + MIN_PROB;
                }
            }
            this.normalizeRowA();
        } else {
            for (int i = 0; i < this.num_states; ++i) {
                for (int j = this.l_limit[i]; j <= this.r_limit[i]; ++j) {
                    this.a[i][j] = MIN_PROB;
                }
                this.a[i][i] = 1.0 - (double)(this.r_limit[i] - this.l_limit[i]) * MIN_PROB;
            }
        }
    }

    public void setA(double[][] p) {
        this.a = new double[this.num_states][this.num_states];
        for (int i = 0; i < this.num_states; ++i) {
            for (int j = 0; j < this.num_states; ++j) {
                this.a[i][j] = p[i][j] > MIN_PROB ? p[i][j] : MIN_PROB;
            }
        }
    }

    public boolean setA(double[][] p, boolean bNormalize) {
        this.setA(p);
        if (!bNormalize) {
            return true;
        }
        this.normalizeRowA();
        return true;
    }

    public void setB() {
        this.setB(true);
    }

    public void setB(boolean bRandomize) {
        if (bRandomize) {
            for (int i = 0; i < this.num_states; ++i) {
                for (int k = 0; k < this.num_symbols; ++k) {
                    this.b[i][k] = rand.nextDouble() + MIN_PROB;
                }
            }
            this.normalizeRowB();
        } else {
            for (int i = 0; i < this.num_states; ++i) {
                for (int k = 0; k < this.num_symbols; ++k) {
                    this.b[i][k] = 1.0 / (double)this.num_symbols;
                }
            }
        }
    }

    public void setB(int i, int k, double p) {
        this.b[i][k] = p > MIN_PROB ? p : MIN_PROB;
    }

    public boolean setB(int i, int k, double p, boolean bCheck) {
        if (!bCheck || i >= 0 && i < this.num_states && k >= 0 && k < this.num_symbols && p <= 1.0 && p >= 0.0) {
            this.setB(i, k, p);
            return true;
        }
        return false;
    }

    public void setB(int i, double[] p) {
        for (int k = 0; k < this.num_symbols; ++k) {
            this.b[i][k] = p[k] > MIN_PROB ? p[k] : MIN_PROB;
        }
    }

    public boolean setB(int i, double[] p, boolean bNormalize) {
        this.setB(i, p);
        if (!bNormalize) {
            return true;
        }
        this.normalizeRowB(i);
        return true;
    }

    public void setLenProbs(double[][] lp) {
        this.lengthsProb = lp;
    }

    public void setB(double[][] p) {
        for (int i = 0; i < this.num_states; ++i) {
            for (int k = 0; k < this.num_symbols; ++k) {
                this.b[i][k] = p[i][k] > MIN_PROB ? p[i][k] : MIN_PROB;
            }
        }
    }

    public boolean setB(double[][] p, boolean bNormalize) {
        this.setB(p);
        if (!bNormalize) {
            return true;
        }
        this.normalizeRowB();
        return true;
    }

    public void setPi() {
        this.setPi(true);
    }

    public void setPi(boolean bRandomize) {
        if (bRandomize) {
            for (int j = 0; j < this.num_states; ++j) {
                this.pi[j] = rand.nextDouble() + (double)this.num_states * MIN_PROB;
            }
            this.normalizeRowPi();
        } else {
            for (int j = 0; j < this.num_states; ++j) {
                this.pi[j] = 1.0 / (double)this.num_states;
            }
        }
    }

    public void setPi(int j, double p) {
        this.pi[j] = p > MIN_PROB ? p : MIN_PROB;
    }

    public boolean setPi(int j, double p, boolean bCheck) {
        if (!bCheck || j >= 0 && j < this.num_states && p <= 1.0 && p >= 0.0) {
            this.setPi(j, p);
            return true;
        }
        return false;
    }

    public void setPi(double[] p) {
        for (int j = 0; j < this.num_states; ++j) {
            this.pi[j] = p[j] > MIN_PROB ? p[j] : MIN_PROB;
        }
    }

    public boolean setPi(double[] p, boolean bNormalize) {
        this.setPi(p);
        if (!bNormalize) {
            return true;
        }
        this.normalizeRowB();
        return true;
    }

    public String[] getLabels() {
        return this.labels;
    }

    public void setLabels(String[] lab) {
        this.labels = new String[this.num_states];
        this.labels = lab;
    }

    public double getA(int i, int j) {
        return this.a[i][j];
    }

    public double[] getA(int i) {
        return this.a[i];
    }

    public double[][] getA() {
        return this.a;
    }

    public double getB(int i, int k) {
        return this.b[i][k];
    }

    public double[][] getLengthProbs() {
        return this.lengthsProb;
    }

    public int[] getNumCdps() {
        return this.numbercdps;
    }

    public boolean[] getHasInhomLengths() {
        return this.hasInhomogeneousLength;
    }

    public HashMap getStatesMap() {
        return statesMap;
    }

    public double[] getB(int i) {
        return this.b[i];
    }

    public double[][] getB() {
        return this.b;
    }

    public double getPi(int j) {
        return this.pi[j];
    }

    public double[] getPi() {
        return this.pi;
    }

    public double getPi(int t, int j) {
        if (t == 0) {
            return this.pi[j];
        }
        double sum = 0.0;
        for (int i = 0; i < this.num_states; ++i) {
            sum += this.getPi(t - 1, i) * this.a[i][j];
        }
        return sum;
    }

    public void setProbability() {
        this.setProbability(true);
    }

    public void setProbability(boolean bRandomize) {
        this.setA(bRandomize);
        this.setB(bRandomize);
        this.setPi(bRandomize);
    }

    public void loadSemiModel(String file) {
        this.loadSemiModel(file, true);
    }

    public void loadSemiModel(String file, boolean bXml) {
        if (bXml) {
            this.loadModelXml(file);
        } else {
            this.loadSemiModelAscii(file);
        }
    }

    public void loadSemiModelAscii(String file) {
        try {
            int i;
            BufferedReader in = new BufferedReader(new FileReader(file));
            Regex comments = new Regex("#");
            String line = in.readLine();
            int ind = 0;
            while (ind < 4) {
                comments.search(line);
                if (!comments.didMatch()) {
                    if (ind == 0) {
                        this.num_states = Integer.valueOf(line);
                    }
                    if (ind == 1) {
                        this.num_symbols = Integer.valueOf(line);
                    }
                    if (ind == 2) {
                        this.ll_bound = Integer.valueOf(line);
                    }
                    if (ind == 3) {
                        this.ur_bound = Integer.valueOf(line);
                    }
                    ++ind;
                }
                line = in.readLine();
            }
            this.a = new double[this.num_states][this.num_states];
            this.b = new double[this.num_states][this.num_symbols];
            this.pi = new double[this.num_states];
            this.l_limit = new int[this.num_states];
            this.r_limit = new int[this.num_states];
            StringTokenizer stkn = null;
            for (i = 0; i < this.num_states; ++i) {
                comments.search(line);
                if (!comments.didMatch()) {
                    stkn = new StringTokenizer(line);
                    int j = 0;
                    while (stkn.hasMoreTokens()) {
                        double val = Double.valueOf(stkn.nextToken());
                        this.a[i][j++] = val;
                    }
                }
                line = in.readLine();
            }
            for (i = 0; i < this.num_states; ++i) {
                comments.search(line);
                if (!comments.didMatch()) {
                    stkn = new StringTokenizer(line);
                    int k = 0;
                    while (stkn.hasMoreTokens()) {
                        this.b[i][k++] = Double.valueOf(stkn.nextToken());
                    }
                }
                line = in.readLine();
            }
            comments.search(line);
            if (!comments.didMatch()) {
                stkn = new StringTokenizer(line);
                int j = 0;
                while (stkn.hasMoreTokens()) {
                    this.pi[j++] = Double.valueOf(stkn.nextToken());
                }
            }
            in.close();
        }
        catch (FileNotFoundException exc) {
            System.out.println("File Not Found: ".concat(String.valueOf(String.valueOf(file))));
        }
        catch (IOException exc) {
            exc.printStackTrace();
        }
    }

    public void loadModelXml(String file) {
        int n;
        int i;
        double prob;
        String proba;
        String len;
        int index;
        int j;
        int i2;
        String proba2;
        String col;
        int n2;
        String row;
        int m;
        TXDocument doc = null;
        if (this.PARSER_NAME.equals(IBM_PARSER)) {
            doc = new TXDocument();
        } else if (this.PARSER_NAME.equals(SUN_PARSER)) {
            doc = new XmlDocument();
        } else {
            System.err.println("Parser name not recognized!");
        }
        NodeList nodeList = null;
        NodeList childList = null;
        NodeList childList2 = null;
        Node childNode = null;
        Element nodeElement = null;
        Element childElement = null;
        String strElement = null;
        nodeList = doc.getElementsByTagName("states");
        nodeElement = (Element)nodeList.item(0);
        strElement = nodeElement.getAttribute("count");
        this.num_states = Integer.valueOf(strElement);
        nodeList = doc.getElementsByTagName("symbols");
        nodeElement = (Element)nodeList.item(0);
        strElement = nodeElement.getAttribute("count");
        this.num_symbols = Integer.valueOf(strElement);
        nodeList = doc.getElementsByTagName("states");
        nodeElement = (Element)nodeList.item(0);
        strElement = nodeElement.getAttribute("ll_bound");
        this.states = new String[this.num_states];
        this.symbols = new String[this.num_symbols];
        nodeList = doc.getElementsByTagName("bounds");
        nodeElement = (Element)nodeList.item(0);
        strElement = nodeElement.getAttribute("ll_bound");
        this.ll_bound = Integer.valueOf(strElement);
        nodeElement = (Element)nodeList.item(0);
        strElement = nodeElement.getAttribute("ur_bound");
        this.ur_bound = Integer.valueOf(strElement);
        nodeList = doc.getElementsByTagName("states");
        childList = nodeList.item(0).getChildNodes();
        this.states = new String[this.num_states];
        this.labels = new String[this.num_states];
        for (m = 0; m < childList.getLength(); ++m) {
            String state;
            childNode = childList.item(m);
            if (childNode.getNodeType() != 1 || (state = (childElement = (Element)childNode).getAttribute("name")) == null) continue;
            this.states[m] = state;
            this.labels[m] = state;
        }
        statesMap = new HashMap();
        for (int i3 = 0; i3 < this.states.length; ++i3) {
            statesMap.put(this.labels[i3], new Integer(i3));
        }
        nodeList = doc.getElementsByTagName("symbols");
        childList = nodeList.item(0).getChildNodes();
        this.symbols = new String[this.num_symbols];
        for (m = 0; m < childList.getLength(); ++m) {
            String sym;
            childNode = childList.item(m);
            if (childNode.getNodeType() != 1 || (sym = (childElement = (Element)childNode).getAttribute("name")) == null) continue;
            this.symbols[m] = sym;
        }
        this.a = new double[this.num_states][this.num_states];
        this.b = new double[this.num_states][this.num_symbols];
        this.pi = new double[this.num_states];
        this.l_limit = new int[this.num_states];
        this.r_limit = new int[this.num_states];
        nodeList = doc.getElementsByTagName("transition_matrix");
        childList = nodeList.item(0).getChildNodes();
        for (m = 0; m < childList.getLength(); ++m) {
            childNode = childList.item(m);
            if (childNode.getNodeType() != 1) continue;
            childElement = (Element)childNode;
            row = childElement.getAttribute("row");
            childList2 = childElement.getChildNodes();
            for (n2 = 0; n2 < childList2.getLength(); ++n2) {
                childNode = childList2.item(n2);
                if (childNode.getNodeType() != 1) continue;
                childElement = (Element)childNode;
                col = childElement.getAttribute("col");
                proba2 = childElement.getAttribute("proba");
                if (row == null || col == null) continue;
                i2 = Integer.valueOf(row);
                j = Integer.valueOf(col);
                this.a[i2][j] = Double.valueOf(proba2);
            }
        }
        nodeList = doc.getElementsByTagName("symbol_generation_matrix");
        childList = nodeList.item(0).getChildNodes();
        for (m = 0; m < childList.getLength(); ++m) {
            childNode = childList.item(m);
            if (childNode.getNodeType() != 1) continue;
            childElement = (Element)childNode;
            row = childElement.getAttribute("row");
            childList2 = childElement.getChildNodes();
            for (n2 = 0; n2 < childList2.getLength(); ++n2) {
                childNode = childList2.item(n2);
                if (childNode.getNodeType() != 1) continue;
                childElement = (Element)childNode;
                col = childElement.getAttribute("col");
                proba2 = childElement.getAttribute("proba");
                if (row == null || col == null) continue;
                i2 = Integer.valueOf(row);
                j = Integer.valueOf(col);
                this.b[i2][j] = Double.valueOf(proba2);
            }
        }
        nodeList = doc.getElementsByTagName("initial_state_vector");
        childList = nodeList.item(0).getChildNodes();
        for (m = 0; m < childList.getLength(); ++m) {
            childNode = childList.item(m);
            if (childNode.getNodeType() != 1) continue;
            childElement = (Element)childNode;
            String col2 = childElement.getAttribute("col");
            String proba3 = childElement.getAttribute("proba");
            if (col2 == null) continue;
            int j2 = Integer.valueOf(col2);
            this.pi[j2] = Double.valueOf(proba3);
        }
        nodeList = doc.getElementsByTagName("length_estimation");
        childList = nodeList.item(0).getChildNodes();
        this.lengthsProb = new double[this.num_states][];
        this.pdfLengths = new double[this.num_states][];
        this.lengths_mu = new double[this.num_states];
        this.lengths_sigma = new double[this.num_states];
        this.hasInhomogeneousLength = new boolean[this.num_states];
        for (int r = 0; r < this.num_states; ++r) {
            this.hasInhomogeneousLength[r] = false;
        }
        this.numbercdps = new int[this.num_states];
        String currState = "";
        for (int i4 = 0; i4 < this.num_states; ++i4) {
            this.lengthsProb[i4] = new double[1001];
            this.pdfLengths[i4] = new double[1001];
        }
        for (int m2 = 0; m2 < childList.getLength(); ++m2) {
            childNode = childList.item(m2);
            if (childNode.getNodeType() != 1) continue;
            childElement = (Element)childNode;
            currState = childElement.getAttribute("state");
            double curr_mu = Double.valueOf(childElement.getAttribute("mu"));
            double curr_sigma = Double.valueOf(childElement.getAttribute("sigma"));
            int curr_cdplength = Integer.valueOf(childElement.getAttribute("count"));
            System.out.println(currState);
            index = (Integer)statesMap.get(currState);
            this.lengths_mu[index] = curr_mu;
            this.lengths_sigma[index] = curr_sigma;
            if (childElement.getAttribute("count") != null) {
                this.numbercdps[index] = curr_cdplength;
                this.hasInhomogeneousLength[index] = true;
            } else {
                this.hasInhomogeneousLength[index] = false;
                System.out.println("hashomogeneousLength ".concat(String.valueOf(String.valueOf(currState))));
            }
            childList2 = childElement.getChildNodes();
            len = "";
            proba = "";
            prob = 0.0;
            i = 0;
            for (n = 0; n < childList2.getLength(); ++n) {
                childNode = childList2.item(n);
                if (childNode.getNodeType() != 1) continue;
                childElement = (Element)childNode;
                len = childElement.getAttribute("length");
                proba = childElement.getAttribute("proba");
                if (len == null || proba == null) continue;
                i = new Double(len).intValue();
                this.pdfLengths[((Integer)Model.statesMap.get((Object)currState)).intValue()][i] = prob = Double.valueOf(proba).doubleValue();
            }
        }
        nodeList = doc.getElementsByTagName("conservation_distribution");
        this.statesConservation = new double[this.states.length][];
        this.hasConsIndex = new boolean[this.states.length];
        this.consmu = new double[this.states.length];
        this.conssigma = new double[this.states.length];
        if (nodeList.getLength() != 0) {
            childElement = (Element)nodeList.item(0);
            for (int u = 0; u < this.states.length; ++u) {
                this.hasConsIndex[u] = false;
            }
            int curr_conscdplength = Integer.valueOf(childElement.getAttribute("count"));
            for (int u = 0; u < this.states.length; ++u) {
                this.statesConservation[u] = new double[curr_conscdplength];
            }
            childList = nodeList.item(0).getChildNodes();
            for (int m3 = 0; m3 < childList.getLength(); ++m3) {
                childNode = childList.item(m3);
                if (childNode.getNodeType() != 1) continue;
                childElement = (Element)childNode;
                currState = childElement.getAttribute("state");
                double curr_mu = Double.valueOf(childElement.getAttribute("mu"));
                double curr_sigma = Double.valueOf(childElement.getAttribute("sigma"));
                index = (Integer)statesMap.get(currState);
                this.consmu[index] = curr_mu;
                this.conssigma[index] = curr_sigma;
                this.hasConsIndex[index] = true;
                childList2 = childElement.getChildNodes();
                len = "";
                proba = "";
                prob = 0.0;
                i = 0;
                for (n = 0; n < childList2.getLength(); ++n) {
                    childNode = childList2.item(n);
                    if (childNode.getNodeType() != 1) continue;
                    childElement = (Element)childNode;
                    len = childElement.getAttribute("length");
                    proba = childElement.getAttribute("proba");
                    if (len == null || proba == null) continue;
                    this.statesConservation[((Integer)Model.statesMap.get((Object)currState)).intValue()][n] = prob = Double.valueOf(proba).doubleValue();
                }
            }
        }
    }

    public void saveSemiModelAscii(String file) {
        try {
            int i;
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            out.println(this.num_states);
            out.println(this.num_symbols);
            out.println(this.ll_bound);
            out.println(this.ur_bound);
            for (i = 0; i < this.num_states; ++i) {
                for (int j = 0; j < this.num_states; ++j) {
                    out.print(this.a[i][j]);
                    out.print("\t");
                }
                out.println();
            }
            for (i = 0; i < this.num_states; ++i) {
                for (int k = 0; k < this.num_symbols; ++k) {
                    out.print(this.b[i][k]);
                    out.print("\t");
                }
                out.println();
            }
            for (int j = 0; j < this.num_states; ++j) {
                out.print(this.pi[j]);
                out.print("\t");
            }
            out.println();
            out.close();
        }
        catch (FileNotFoundException exc) {
            System.out.println("File Not Found: ".concat(String.valueOf(String.valueOf(file))));
        }
        catch (IOException exc) {
            exc.printStackTrace();
        }
    }

    public void removeState(String state) {
        boolean stillMore = true;
        int i = -1;
        while (stillMore) {
            int k;
            for (int s = 0; s < this.num_states; ++s) {
                if (state.equals(this.labels[s])) {
                    i = s;
                    System.out.println("i=".concat(String.valueOf(String.valueOf(i))));
                    stillMore = true;
                    break;
                }
                stillMore = false;
            }
            if (!stillMore) continue;
            --this.num_states;
            double[][] initA = new double[this.num_states][this.num_states];
            double[][] initB = new double[this.num_states][this.getB()[0].length];
            double[] initPi = new double[this.num_states];
            double[][] initProb = new double[this.num_states][this.lengthsProb[0].length];
            String[] initLabels = new String[this.num_states];
            double[][] initPdfLengths = new double[this.num_states][this.lengthsProb[0].length];
            double[] initLengths_mu = new double[this.num_states];
            double[] initLengths_sigma = new double[this.num_states];
            boolean[] initHasInhomogeneousLength = new boolean[this.num_states];
            boolean[] initHasConsIndex = new boolean[this.num_states];
            double[][] initStatesConservation = null;
            if (this.statesConservation[0] != null) {
                initStatesConservation = new double[this.num_states][this.statesConservation[0].length];
            } else {
                this.statesConservation = new double[this.num_states + 1][2];
                initStatesConservation = new double[this.num_states][2];
            }
            double[] initConsmu = new double[this.num_states];
            double[] initConssigma = new double[this.num_states];
            if (i == 0) {
                for (k = 1; k < this.num_states + 1; ++k) {
                    int p;
                    int j;
                    for (j = 1; j < this.num_states + 1; ++j) {
                        initA[k - 1][j - 1] = this.getA(k, j);
                    }
                    for (j = 0; j < this.num_symbols; ++j) {
                        initB[k - 1][j] = this.getB(k, j);
                    }
                    for (j = 0; j < this.lengthsProb[0].length; ++j) {
                        initProb[k - 1][j] = this.getLengthProbs()[k][j];
                    }
                    initPi[k - 1] = this.getPi(k);
                    initLabels[k - 1] = this.getLabels()[k];
                    for (p = 0; p < this.pdfLengths[0].length; ++p) {
                        initPdfLengths[k - 1][p] = this.pdfLengths[k][p];
                    }
                    for (p = 0; p < initStatesConservation[0].length; ++p) {
                        initStatesConservation[k - 1][p] = this.statesConservation[k][p];
                    }
                    initHasInhomogeneousLength[k - 1] = this.hasInhomogeneousLength[k];
                    initHasConsIndex[k - 1] = this.hasConsIndex[k];
                    initLengths_mu[k - 1] = this.lengths_mu[k];
                    initLengths_sigma[k - 1] = this.lengths_sigma[k];
                    initConsmu[k - 1] = this.consmu[k];
                    initConssigma[k - 1] = this.conssigma[k];
                    ArrayList p2 = new ArrayList();
                }
            } else if (i == this.num_states) {
                System.out.println("right loop!");
                for (k = 0; k < this.num_states; ++k) {
                    int p;
                    int j;
                    for (j = 0; j < this.num_states; ++j) {
                        initA[k][j] = this.getA(k, j);
                    }
                    for (j = 0; j < this.num_symbols; ++j) {
                        initB[k][j] = this.getB(k, j);
                    }
                    for (j = 0; j < this.lengthsProb[0].length; ++j) {
                        initProb[k][j] = this.getLengthProbs()[k][j];
                    }
                    initPi[k] = this.getPi(k);
                    initLabels[k] = this.getLabels()[k];
                    for (p = 0; p < initPdfLengths[0].length; ++p) {
                        initPdfLengths[k][p] = this.pdfLengths[k][p];
                    }
                    for (p = 0; p < initStatesConservation[0].length; ++p) {
                        initStatesConservation[k][p] = this.statesConservation[k][p];
                    }
                    initHasInhomogeneousLength[k] = this.hasInhomogeneousLength[k];
                    initHasConsIndex[k] = this.hasConsIndex[k];
                    initLengths_mu[k] = this.lengths_mu[k];
                    initLengths_sigma[k] = this.lengths_sigma[k];
                    initConsmu[k] = this.consmu[k];
                    initConssigma[k] = this.conssigma[k];
                }
            } else {
                for (k = 0; k < i; ++k) {
                    int p;
                    int j;
                    for (j = 0; j < i; ++j) {
                        initA[k][j] = this.getA(k, j);
                    }
                    for (j = i + 1; j < this.num_states + 1; ++j) {
                        initA[k][j - 1] = this.getA(k, j);
                    }
                    for (j = 0; j < this.num_symbols; ++j) {
                        initB[k][j] = this.getB(k, j);
                    }
                    for (j = 0; j < this.lengthsProb[0].length; ++j) {
                        initProb[k][j] = this.getLengthProbs()[k][j];
                    }
                    initPi[k] = this.getPi(k);
                    initLabels[k] = this.getLabels()[k];
                    for (p = 0; p < initPdfLengths[0].length; ++p) {
                        initPdfLengths[k][p] = this.pdfLengths[k][p];
                    }
                    for (p = 0; p < initStatesConservation[0].length; ++p) {
                        initStatesConservation[k][p] = this.statesConservation[k][p];
                    }
                    initHasInhomogeneousLength[k] = this.hasInhomogeneousLength[k];
                    initHasConsIndex[k] = this.hasConsIndex[k];
                    initLengths_mu[k] = this.lengths_mu[k];
                    initLengths_sigma[k] = this.lengths_sigma[k];
                    initConsmu[k] = this.consmu[k];
                    initConssigma[k] = this.conssigma[k];
                }
                for (k = i + 1; k < this.num_states + 1; ++k) {
                    int p;
                    int j;
                    for (j = 0; j < i; ++j) {
                        initA[k - 1][j] = this.getA(k, j);
                    }
                    for (j = i + 1; j < this.num_states + 1; ++j) {
                        initA[k - 1][j - 1] = this.getA(k, j);
                    }
                    for (j = 0; j < this.num_symbols; ++j) {
                        initB[k - 1][j] = this.getB(k, j);
                    }
                    for (j = 0; j < this.lengthsProb[0].length; ++j) {
                        initProb[k - 1][j] = this.getLengthProbs()[k][j];
                    }
                    initPi[k - 1] = this.getPi(k);
                    initLabels[k - 1] = this.getLabels()[k];
                    for (p = 0; p < initPdfLengths[0].length; ++p) {
                        initPdfLengths[k - 1][p] = this.pdfLengths[k][p];
                    }
                    for (p = 0; p < initStatesConservation[0].length; ++p) {
                        initStatesConservation[k - 1][p] = this.statesConservation[k][p];
                    }
                    initHasInhomogeneousLength[k - 1] = this.hasInhomogeneousLength[k];
                    initHasConsIndex[k - 1] = this.hasConsIndex[k];
                    initLengths_mu[k - 1] = this.lengths_mu[k];
                    initLengths_sigma[k - 1] = this.lengths_sigma[k];
                    initConsmu[k - 1] = this.consmu[k];
                    initConssigma[k - 1] = this.conssigma[k];
                }
            }
            this.a = initA;
            this.b = initB;
            this.setPi(initPi);
            this.setLenProbs(initProb);
            this.setLabels(initLabels);
            this.pdfLengths = initPdfLengths;
            this.statesConservation = initStatesConservation;
            this.hasInhomogeneousLength = initHasInhomogeneousLength;
            this.hasConsIndex = initHasConsIndex;
            this.lengths_mu = initLengths_mu;
            this.lengths_sigma = initLengths_sigma;
            this.consmu = initConsmu;
            this.conssigma = initConssigma;
        }
    }

    public void computeLogMatrices() {
        int i;
        MyLogFunc mylog = new MyLogFunc();
        this.logA = new double[this.getA().length][this.getA()[0].length];
        this.logPi = new double[this.getPi().length];
        for (i = 0; i < this.getA().length; ++i) {
            for (int j = 0; j < this.getA()[0].length; ++j) {
                this.logA[i][j] = mylog.apply(this.getA()[i][j]);
            }
        }
        for (i = 0; i < this.getPi().length; ++i) {
            this.logPi[i] = mylog.apply(this.getPi()[i]);
        }
    }

    public void computeCumulativeDist() {
        for (int i = 0; i < this.num_states; ++i) {
            double sum = 0.0;
            this.lengthsProb[i][0] = 0.0;
            for (int t = 1; t < this.pdfLengths[i].length; ++t) {
                this.lengthsProb[i][t] = this.lengthsProb[i][t - 1] + this.pdfLengths[i][t];
            }
        }
    }

    public void computeCondA() {
        this.condA = new int[this.a.length][];
        for (int j = 0; j < this.a[0].length; ++j) {
            int size = 0;
            for (int i = 0; i < this.a.length; ++i) {
                if (this.a[i][j] == 0.0) continue;
                ++size;
            }
            this.condA[j] = new int[size];
            int t = 0;
            for (int i = 0; i < this.a[j].length; ++i) {
                if (this.a[i][j] == 0.0) continue;
                this.condA[j][t] = i;
                ++t;
            }
        }
    }

    public void computeCondAInv() {
        this.condAInv = new int[this.a.length][];
        for (int i = 0; i < this.a.length; ++i) {
            int size = 0;
            for (int j = 0; j < this.a[0].length; ++j) {
                if (this.a[i][j] == 0.0) continue;
                ++size;
            }
            this.condAInv[i] = new int[size];
            int t = 0;
            for (int j = 0; j < this.a[i].length; ++j) {
                if (this.a[i][j] == 0.0) continue;
                this.condAInv[i][t] = j;
                ++t;
            }
        }
    }

    public double[][] getLogA() {
        return this.logA;
    }

    public double[] getLogPi() {
        return this.logPi;
    }

    public double[][] getStatesConservation() {
        return this.statesConservation;
    }

    public double[] getStatesConservationMu() {
        return this.consmu;
    }

    public double[] getStatesConservationSigma() {
        return this.conssigma;
    }

    public boolean[] getHasConsIndex() {
        return this.hasConsIndex;
    }

    public double[] getConsmu() {
        return this.consmu;
    }

    public double[] getConssigma() {
        return this.conssigma;
    }

    public double[] getLen_mu() {
        return this.lengths_mu;
    }

    public double[] getLen_sigma() {
        return this.lengths_sigma;
    }

    public double[][] getStateCons() {
        return this.statesConservation;
    }

    public void prepareModelForAlgorithms() {
        this.computeCondA();
        this.computeCondAInv();
        this.computeLogMatrices();
        if (this.hasInhomogeneousLengths) {
            this.computeCumulativeDist();
        }
        this.num_states = this.a.length;
        this.isReady = true;
    }

    public void associateProteinModels(Model[] proHMMs) {
        if (this.num_states == proHMMs.length) {
            this.proteinModels = proHMMs;
            for (int i = 0; i < this.num_states; ++i) {
                this.proteinModels[i].prepareModelForAlgorithms();
            }
        } else {
            System.err.println("size of protein models doesn't match with gene models");
        }
    }

    static {
        MAX_NUM_STATES = 1000;
        MAX_NUM_SYMBOLS = 1000;
        MIN_PROB = 1.0E-14;
        IBM_PARSER = IBM_PARSER;
        SUN_PARSER = SUN_PARSER;
        rand = new Random();
        CHAIN = CHAIN;
        PROPEPTIDE1 = PROPEPTIDE1;
        PROPEPTIDE2 = PROPEPTIDE2;
        PROPEPTIDE = PROPEPTIDE;
        PEPTIDE = PEPTIDE;
        PEPTIDE1 = PEPTIDE1;
        PEPTIDE2 = PEPTIDE2;
        PC1END = "PC1-5";
        PC1_1 = PC1_1;
        PC1_2 = PC1_2;
        PC1_3 = PC1_3;
        PC1_4 = PC1_4;
        PC1_5 = "PC1-5";
        PC2_1 = PC2_1;
        PC2_2 = PC2_2;
        PC2_3 = PC2_3;
        PC2_4 = PC2_4;
        PC2_5 = PC2_5;
        SPEND = SPEND;
        MITOEND = MITOEND;
        MITOCHONDRIAL = MITOCHONDRIAL;
        HYDRO = HYDRO;
        NTER = NTER;
        CTER = CTER;
        residues = residues;
        aminoAcids = new String[]{"A", "R", "N", "D", "C", "Q", "E", "G", "H", "I", "L", "K", "M", "F", "P", "S", "T", "W", "Y", "V", "Z"};
    }
}

