/*
 * Decompiled with CFR 0.152.
 */
package trimali;

import cern.jet.random.Normal;
import cern.jet.random.engine.MersenneTwister;
import cern.jet.random.engine.RandomEngine;
import com.stevesoft.pat.Regex;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import trimali.HmmAlgorithms;
import trimali.Model;

public class PerformTrimming {
    public static final String[] aminoAcids = new String[]{"A", "R", "N", "D", "C", "Q", "E", "G", "H", "I", "L", "K", "M", "F", "P", "S", "T", "W", "Y", "V", "-", "Z"};
    public static final double[] freqRandomVertebrateAminoAcids = new double[]{0.074, 0.042, 0.044, 0.059, 0.033, 0.037, 0.058, 0.074, 0.029, 0.038, 0.076, 0.072, 0.018, 0.04, 0.05, 0.081, 0.062, 0.013, 0.033, 0.068, 0.0, 0.0};
    public static TreeMap aminoAcidsInverse;
    public static String filename;
    public static String entropyValues;
    public static String newAliFile;
    public static String finalAliFile;
    public double entropyThreshold = 2.0;
    public static double AvgLengthThresholdForInsertionState;
    public Model proteinModel;
    public Model entropyModel;
    public static final String[] entropyScoreAlphabet;
    public static String[] entropyStatesLabels;
    public static final double mimimumProba = 1.0E-4;
    public static final double convergenceThreshold = 1.0;
    public static final double maxiters = 150.0;
    public static double thresholdGapPercentage;
    public HmmAlgorithms hmmAlgos;
    public String[][] startAliCol;
    public String[][] finalAliCol;
    public int numLearningSeqs;
    public double[][] freqmat;
    public double[][] freqmatWithGaps;
    public int[] indexes;
    public int[][] lengthsInsertedAA;
    public int numberSeqs = 0;
    public LinkedHashMap ali;
    public static LinkedHashMap newAli;
    public LinkedHashMap newAli2;
    public static boolean debug;

    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("USAGE: CLUSTAL_ALIGNMENT_FILE OR CLUSTAL_ALIGNMENT_FILE THRESHOLD_GAP");
        }
        filename = args[0];
        if (args.length > 1) {
            thresholdGapPercentage = new Double(args[1]);
        }
        Regex clustalFileReg = new Regex("(.*)\\.[^\\.]+");
        String prefix = filename;
        if (clustalFileReg.search(filename)) {
            prefix = clustalFileReg.stringMatched(1);
        }
        newAliFile = String.valueOf(String.valueOf(prefix)).concat("_intermediate.aln");
        finalAliFile = String.valueOf(String.valueOf(prefix)).concat("_final.aln");
        PerformTrimming cleanAli = new PerformTrimming();
        aminoAcidsInverse = new TreeMap();
        for (int k = 0; k < aminoAcids.length; ++k) {
            aminoAcidsInverse.put(aminoAcids[k], new Integer(k));
        }
        cleanAli.ali = PerformTrimming.readAlignment(filename);
        cleanAli.numLearningSeqs = cleanAli.ali.size();
        double[][] countmat = PerformTrimming.returnaacounts(cleanAli.ali);
        cleanAli.freqmatWithGaps = PerformTrimming.returnFrequenciesPerPositionWithGaps(countmat);
        ArrayList<Integer> relevantColumns = new ArrayList<Integer>();
        for (int i = 0; i < cleanAli.freqmatWithGaps.length; ++i) {
            if (!(cleanAli.freqmatWithGaps[i][(Integer)aminoAcidsInverse.get("-")] < thresholdGapPercentage)) continue;
            relevantColumns.add(new Integer(i));
        }
        newAli = PerformTrimming.filterAlignment(cleanAli.ali, relevantColumns);
        Set kset = ((HashMap)newAli).keySet();
        Iterator iterator = kset.iterator();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            String string = (String)newAli.get(name);
        }
        PerformTrimming.printClustalAlignment(newAli, newAliFile);
        double[][] newCounts = PerformTrimming.returnaacounts(newAli);
        double[][] newFreqMat = PerformTrimming.returnFrequenciesPerPosition(newCounts);
        double[][] newFreqMatWithGaps = PerformTrimming.returnFrequenciesPerPositionWithGaps(newCounts);
        double[] entropyVals = new double[newFreqMat.length];
        double[] gapFreqs = new double[newFreqMat.length];
        for (int i = 0; i < newFreqMat.length; ++i) {
            entropyVals[i] = PerformTrimming.computeEntropy(newFreqMat[i]);
            gapFreqs[i] = 0.1;
        }
        double[][] listTobePrinted = new double[entropyVals.length][2];
        for (int k = 0; k < listTobePrinted.length; ++k) {
            listTobePrinted[k][0] = entropyVals[k];
            listTobePrinted[k][1] = gapFreqs[k];
        }
        PerformTrimming.printList(listTobePrinted, entropyValues);
        cleanAli.initialiseContinuousEntropyModel2states();
        cleanAli.hmmAlgos = new HmmAlgorithms(cleanAli.entropyModel);
        ArrayList<double[]> multiAli = new ArrayList<double[]>();
        double rannumber = 0.0;
        MersenneTwister twister = new MersenneTwister(new Date());
        Normal norm = new Normal(0.0, 1.0E-4, (RandomEngine)twister);
        for (int i = 0; i < entropyVals.length; ++i) {
            double[] vect = new double[cleanAli.entropyModel.dimensionOfData];
            vect[0] = entropyVals[i];
            vect[1] = gapFreqs[i];
            vect[0] = vect[0] + norm.nextDouble();
            vect[1] = vect[1] + norm.nextDouble();
            multiAli.add(vect);
        }
        ArrayList<ArrayList<double[]>> multiAlis = new ArrayList<ArrayList<double[]>>();
        multiAlis.add(multiAli);
        cleanAli.hmmAlgos.obSeqs = multiAlis;
        double formerlikelihood = 0.0;
        double likelihood = -1.0E10;
        int numiter = 0;
        while (Math.abs(formerlikelihood - likelihood) > 1.0 && (double)numiter < 150.0) {
            formerlikelihood = likelihood;
            likelihood = cleanAli.hmmAlgos.BaumWelchAlgoForMultipleSequences();
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("number of iterations:").append(numiter).append(" ").append("log-likelihood:").append(likelihood))));
            ++numiter;
        }
        cleanAli.hmmAlgos.computeLogObsForMultipleSequences();
        double overLikelihood = cleanAli.hmmAlgos.forwardAlgoForMultipleSequences();
        cleanAli.hmmAlgos.backwardAlgoForMultipleSequences();
        cleanAli.hmmAlgos.computeGammaForMultipleSequences();
        cleanAli.hmmAlgos.computeKsiForMultipleSequences();
        cleanAli.hmmAlgos.optimalAccuracyDecodingForMultipleSequences();
        ArrayList<Integer> newColumns = new ArrayList<Integer>();
        for (int r = 0; r < cleanAli.hmmAlgos.qstarForMultipleSequences.length; ++r) {
            for (int t = 0; t < cleanAli.hmmAlgos.qstarForMultipleSequences[r].length; ++t) {
                String state = entropyStatesLabels[cleanAli.hmmAlgos.qstarForMultipleSequences[r][t]];
                System.out.print(String.valueOf(String.valueOf(state)).concat(" "));
                if (state != "H" && state != "C" && state != "D") continue;
                newColumns.add(new Integer(t));
            }
            System.out.println("\n");
        }
        cleanAli.newAli2 = PerformTrimming.filterAlignment(newAli, newColumns);
        PerformTrimming.printClustalAlignment(cleanAli.newAli2, finalAliFile);
        cleanAli.startAliCol = PerformTrimming.returnAlignmentByColumns(cleanAli.ali);
        cleanAli.finalAliCol = PerformTrimming.returnAlignmentByColumns(cleanAli.newAli2);
    }

    public static LinkedHashMap readAlignment(String filename) {
        Regex regclustal = new Regex("([^\\s]+)\\s+([\\w-]+)");
        Regex regclust = new Regex("CLUSTAL");
        BufferedReader br = null;
        LinkedHashMap<String, String> hm = new LinkedHashMap<String, String>();
        String name = "";
        String seq = "";
        try {
            br = new BufferedReader(new FileReader(filename));
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        String line = "";
        try {
            line = br.readLine();
            while (line != null) {
                if (regclustal.search(line) && !regclust.search(line)) {
                    name = regclustal.stringMatched(1);
                    seq = regclustal.stringMatched(2);
                    if (hm.containsKey(name)) {
                        hm.put(name, String.valueOf(String.valueOf(hm.get(name))).concat(String.valueOf(String.valueOf(seq))));
                    } else if (!hm.containsKey(name)) {
                        hm.put(name, seq);
                    }
                }
                line = br.readLine();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return hm;
    }

    public static String rtrim(String source) {
        return source.replaceAll("\\s+$", "");
    }

    public static String ltrim(String source) {
        return source.replaceAll("^\\s+", "");
    }

    public static LinkedHashMap readFastaFile(String filename) {
        Regex regfasta = new Regex(">([\\w\\._]+)");
        BufferedReader br = null;
        LinkedHashMap<String, String> hm = new LinkedHashMap<String, String>();
        String name = "";
        String seq = "";
        try {
            br = new BufferedReader(new FileReader(filename));
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        String line = "";
        try {
            line = br.readLine();
            int numberSeq = 0;
            while (line != null) {
                if (regfasta.search(line)) {
                    if (numberSeq > 0) {
                        hm.put(name, seq);
                        if (debug) {
                            System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(name))).append(" ").append(seq))));
                        }
                    }
                    name = regfasta.stringMatched(1);
                    seq = "";
                    ++numberSeq;
                } else {
                    seq = String.valueOf(String.valueOf(seq)).concat(String.valueOf(String.valueOf(PerformTrimming.ltrim(PerformTrimming.rtrim(line)))));
                }
                line = br.readLine();
            }
            hm.put(name, seq);
            if (debug) {
                System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(name))).append(" ").append(seq))));
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return hm;
    }

    public static double[][] returnaacounts(LinkedHashMap alignment) {
        Set kset = ((HashMap)alignment).keySet();
        Iterator iterat = kset.iterator();
        int numbergenes = kset.size();
        int alisize = 0;
        while (iterat.hasNext()) {
            String name = (String)iterat.next();
            alisize = ((String)alignment.get(name)).length();
        }
        double[][] countmatrix = new double[alisize][aminoAcids.length];
        iterat = kset.iterator();
        while (iterat.hasNext()) {
            String name = (String)iterat.next();
            String seq = (String)alignment.get(name);
            if (seq.length() != alisize) {
                System.out.println(String.valueOf(String.valueOf(new StringBuffer("problem with multiple sequences ").append(name).append(" ").append(seq.length()).append(" ").append(alisize))));
            }
            for (int k = 0; k < seq.length(); ++k) {
                if (aminoAcidsInverse.containsKey(seq.substring(k, k + 1))) {
                    double[] dArray = countmatrix[k];
                    int n = (Integer)aminoAcidsInverse.get(seq.substring(k, k + 1));
                    dArray[n] = dArray[n] + 1.0;
                    continue;
                }
                double[] dArray = countmatrix[k];
                int n = (Integer)aminoAcidsInverse.get("-");
                dArray[n] = dArray[n] + 1.0;
            }
        }
        return countmatrix;
    }

    public static double[][] returnFrequenciesPerPositionWithGaps(double[][] countmatrix) {
        double[][] resmatrix = new double[countmatrix.length][countmatrix[0].length];
        for (int i = 0; i < countmatrix.length; ++i) {
            int j;
            double somme = 0.0;
            for (j = 0; j < countmatrix[0].length; ++j) {
                somme += countmatrix[i][j];
            }
            for (j = 0; j < countmatrix[0].length; ++j) {
                resmatrix[i][j] = countmatrix[i][j] / somme;
            }
        }
        return resmatrix;
    }

    public static double[][] returnFrequenciesPerPosition(double[][] countmatrix) {
        double[][] resmatrix = new double[countmatrix.length][countmatrix[0].length - 1];
        for (int i = 0; i < countmatrix.length; ++i) {
            int j;
            double somme = 0.0;
            for (j = 0; j < countmatrix[0].length - 1; ++j) {
                somme += countmatrix[i][j];
            }
            for (j = 0; j < countmatrix[0].length - 1; ++j) {
                resmatrix[i][j] = countmatrix[i][j] / somme;
            }
        }
        return resmatrix;
    }

    public static double computeEntropy(double[] mat) {
        double res = 0.0;
        for (int t = 0; t < mat.length; ++t) {
            if (!(mat[t] > 0.0)) continue;
            res += -Math.log(mat[t]) * mat[t];
        }
        return res;
    }

    public static void printList(double[][] list, String filename) {
        PrintWriter out = null;
        try {
            out = new PrintWriter(new BufferedWriter(new FileWriter(filename)));
            for (int i = 0; i < list.length; ++i) {
                out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(i))).append("\t").append(list[i][0]).append("\t").append(list[i][1]))));
            }
            out.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static void printClustalAlignment(LinkedHashMap alignment, String fileName) {
        PrintWriter out = null;
        try {
            out = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
            Iterator iterat = ((HashMap)alignment).keySet().iterator();
            String name = (String)iterat.next();
            String seq = (String)alignment.get(name);
            int len = seq.length();
            int num = len / 50;
            out.println("CLUSTAL");
            iterat = ((HashMap)alignment).keySet().iterator();
            int maxlength = 0;
            while (iterat.hasNext()) {
                name = (String)iterat.next();
                maxlength = Math.max(name.length(), maxlength);
            }
            iterat = ((HashMap)alignment).keySet().iterator();
            for (int k = 0; k < num; ++k) {
                iterat = ((HashMap)alignment).keySet().iterator();
                while (iterat.hasNext()) {
                    name = (String)iterat.next();
                    seq = (String)alignment.get(name);
                    out.print(name);
                    for (int i = 0; i < maxlength - name.length(); ++i) {
                        out.print(" ");
                    }
                    out.print(String.valueOf(String.valueOf(new StringBuffer("  ").append(seq.substring(50 * k, 50 * (k + 1))).append("\n"))));
                }
                out.print("\n");
            }
            iterat = ((HashMap)alignment).keySet().iterator();
            while (iterat.hasNext()) {
                name = (String)iterat.next();
                seq = (String)alignment.get(name);
                out.print(name);
                for (int i = 0; i < maxlength - name.length(); ++i) {
                    out.print(" ");
                }
                out.print(String.valueOf(String.valueOf(new StringBuffer("  ").append(seq.substring(50 * num, len)).append("\n"))));
            }
            out.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void initialiseEntropyModel() {
        int t;
        this.entropyModel = new Model();
        this.entropyModel.labels = entropyStatesLabels;
        this.entropyModel.symbols = entropyScoreAlphabet;
        this.entropyModel.num_symbols = entropyScoreAlphabet.length;
        this.entropyModel.num_states = entropyStatesLabels.length;
        this.entropyModel.a = new double[entropyStatesLabels.length][entropyStatesLabels.length];
        this.entropyModel.b = new double[entropyStatesLabels.length][entropyScoreAlphabet.length];
        this.entropyModel.pi = new double[entropyStatesLabels.length];
        this.entropyModel.pi[0] = 0.33;
        this.entropyModel.pi[1] = 0.33;
        this.entropyModel.pi[2] = 0.33;
        this.entropyModel.a[0][0] = 0.9;
        this.entropyModel.a[0][1] = 0.1;
        this.entropyModel.a[0][2] = 0.1;
        this.entropyModel.a[1][0] = 0.05;
        this.entropyModel.a[1][1] = 0.95;
        this.entropyModel.a[1][2] = 0.05;
        this.entropyModel.a[2][0] = 0.5;
        this.entropyModel.a[2][1] = 0.005;
        this.entropyModel.a[2][2] = 0.5;
        for (t = 0; t < 1; ++t) {
            this.entropyModel.b[0][t] = 0.05;
            this.entropyModel.b[1][t] = 0.95;
        }
        for (t = 1; t < this.entropyModel.b[0].length; ++t) {
            this.entropyModel.b[0][t] = 0.95;
            this.entropyModel.b[1][t] = 0.05;
        }
        this.entropyModel.b[2][0] = 0.2;
        this.entropyModel.b[2][1] = 0.2;
        this.entropyModel.b[2][2] = 0.2;
        this.entropyModel.b[2][3] = 0.2;
        this.entropyModel.b[2][4] = 0.2;
        this.entropyModel.b[2][5] = 0.2;
        this.entropyModel.prepareModelForAlgorithms();
    }

    public void initialiseContinuousEntropyModel2states() {
        this.entropyModel = new Model(true, 2, 2, 2);
        this.entropyModel.labels = entropyStatesLabels;
        this.entropyModel.num_states = entropyStatesLabels.length;
        this.entropyModel.a = new double[entropyStatesLabels.length][entropyStatesLabels.length];
        this.entropyModel.pi = new double[entropyStatesLabels.length];
        this.entropyModel.pi[0] = 0.5;
        this.entropyModel.pi[1] = 0.5;
        this.entropyModel.a[0][0] = 0.9;
        this.entropyModel.a[0][1] = 0.1;
        this.entropyModel.a[1][0] = 0.1;
        this.entropyModel.a[1][1] = 0.9;
        this.entropyModel.GaussianWeights[0][0] = 0.5;
        this.entropyModel.GaussianWeights[0][1] = 0.5;
        this.entropyModel.GaussianWeights[1][0] = 0.5;
        this.entropyModel.GaussianWeights[1][1] = 0.5;
        Random generator = new Random();
        for (int i = 0; i < this.entropyModel.num_states; ++i) {
            for (int j = 0; j < this.entropyModel.numGaussianMixtureComponents; ++j) {
                this.entropyModel.GaussianCova[i][j] = HmmAlgorithms.randomizeMatrix(this.entropyModel.dimensionOfData, this.entropyModel.dimensionOfData, generator);
                for (int k = 0; k < this.entropyModel.GaussianCova[i][j].length; ++k) {
                    for (int l = 0; l < this.entropyModel.GaussianCova[i][j].length; ++l) {
                        if (k != l) {
                            this.entropyModel.GaussianCova[i][j][k][l] = 1.0E-4;
                            continue;
                        }
                        if (k == 1) {
                            this.entropyModel.GaussianCova[i][j][k][l] = 0.01;
                            continue;
                        }
                        if (k != 0) continue;
                        this.entropyModel.GaussianCova[i][j][k][l] = 0.1;
                    }
                }
            }
        }
        this.entropyModel.GaussianMu[0][0][0] = 2.7;
        this.entropyModel.GaussianMu[1][0][0] = 2.0;
        this.entropyModel.GaussianMu[0][0][1] = 0.1;
        this.entropyModel.GaussianMu[1][0][1] = 0.1;
        this.entropyModel.GaussianMu[0][1][0] = 2.7;
        this.entropyModel.GaussianMu[1][1][0] = 1.5;
        this.entropyModel.GaussianMu[0][1][1] = 0.1;
        this.entropyModel.GaussianMu[1][1][1] = 0.1;
        this.entropyModel.prepareModelForAlgorithms();
    }

    public void initialiseContinuousEntropyModel3states() {
        int k;
        this.entropyModel = new Model(true, 3, 2, 2);
        this.entropyModel.labels = entropyStatesLabels;
        this.entropyModel.num_states = entropyStatesLabels.length;
        this.entropyModel.a = new double[entropyStatesLabels.length][entropyStatesLabels.length];
        this.entropyModel.pi = new double[entropyStatesLabels.length];
        this.entropyModel.pi[0] = 0.33;
        this.entropyModel.pi[1] = 0.33;
        this.entropyModel.pi[2] = 0.33;
        this.entropyModel.a[0][0] = 0.9;
        this.entropyModel.a[0][1] = 0.05;
        this.entropyModel.a[0][2] = 0.05;
        this.entropyModel.a[1][0] = 0.05;
        this.entropyModel.a[1][1] = 0.9;
        this.entropyModel.a[1][2] = 0.05;
        this.entropyModel.a[2][0] = 0.05;
        this.entropyModel.a[2][1] = 0.05;
        this.entropyModel.a[2][2] = 0.85;
        for (int i = 0; i < this.entropyModel.num_states; ++i) {
            for (k = 0; k < this.entropyModel.numGaussianMixtureComponents; ++k) {
                if (k == 0) {
                    this.entropyModel.GaussianWeights[i][k] = 0.5;
                }
                if (k != 1) continue;
                this.entropyModel.GaussianWeights[i][k] = 0.5;
            }
        }
        Random generator = new Random();
        for (int i = 0; i < this.entropyModel.num_states; ++i) {
            for (int j = 0; j < this.entropyModel.numGaussianMixtureComponents; ++j) {
                for (int k2 = 0; k2 < this.entropyModel.GaussianCova[i][j].length; ++k2) {
                    for (int l = 0; l < this.entropyModel.GaussianCova[i][j].length; ++l) {
                        if (k2 == l) continue;
                        this.entropyModel.GaussianCova[i][j][k2][l] = 1.0E-5;
                    }
                    if (j == 0) {
                        this.entropyModel.GaussianCova[i][j][k2][k2] = 0.1;
                    }
                    if (j != 1) continue;
                    this.entropyModel.GaussianCova[i][j][k2][k2] = 0.2;
                }
            }
        }
        for (k = 0; k < this.entropyModel.numGaussianMixtureComponents; ++k) {
            this.entropyModel.GaussianMu[0][k][0] = 2.3;
            this.entropyModel.GaussianMu[1][k][0] = 1.3;
            this.entropyModel.GaussianMu[2][k][0] = 1.5;
            this.entropyModel.GaussianMu[0][k][1] = 0.2;
            this.entropyModel.GaussianMu[1][k][1] = 0.05;
            this.entropyModel.GaussianMu[2][k][1] = 0.4;
        }
        this.entropyModel.prepareModelForAlgorithms();
    }

    public void initialiseContinuousEntropyModel4states() {
        int k;
        this.entropyModel = new Model(true, 4, 2, 2);
        this.entropyModel.labels = entropyStatesLabels;
        this.entropyModel.num_states = entropyStatesLabels.length;
        this.entropyModel.a = new double[entropyStatesLabels.length][entropyStatesLabels.length];
        this.entropyModel.pi = new double[entropyStatesLabels.length];
        this.entropyModel.pi[0] = 0.25;
        this.entropyModel.pi[1] = 0.25;
        this.entropyModel.pi[2] = 0.25;
        this.entropyModel.pi[3] = 0.25;
        this.entropyModel.a[0][0] = 0.9;
        this.entropyModel.a[0][1] = 0.033;
        this.entropyModel.a[0][2] = 0.033;
        this.entropyModel.a[0][3] = 0.033;
        this.entropyModel.a[1][0] = 0.033;
        this.entropyModel.a[1][1] = 0.9;
        this.entropyModel.a[1][2] = 0.033;
        this.entropyModel.a[1][3] = 0.033;
        this.entropyModel.a[2][0] = 0.033;
        this.entropyModel.a[2][1] = 0.033;
        this.entropyModel.a[2][2] = 0.9;
        this.entropyModel.a[2][3] = 0.033;
        this.entropyModel.a[3][0] = 0.05;
        this.entropyModel.a[3][1] = 0.05;
        this.entropyModel.a[3][2] = 0.85;
        this.entropyModel.a[3][3] = 0.05;
        for (int i = 0; i < this.entropyModel.num_states; ++i) {
            for (k = 0; k < this.entropyModel.numGaussianMixtureComponents; ++k) {
                if (k == 0) {
                    this.entropyModel.GaussianWeights[i][k] = 0.5;
                }
                if (k != 1) continue;
                this.entropyModel.GaussianWeights[i][k] = 0.5;
            }
        }
        Random generator = new Random();
        for (int i = 0; i < this.entropyModel.num_states; ++i) {
            for (int j = 0; j < this.entropyModel.numGaussianMixtureComponents; ++j) {
                for (int k2 = 0; k2 < this.entropyModel.GaussianCova[i][j].length; ++k2) {
                    for (int l = 0; l < this.entropyModel.GaussianCova[i][j].length; ++l) {
                        if (k2 == l) continue;
                        this.entropyModel.GaussianCova[i][j][k2][l] = 1.0E-6;
                    }
                    if (j == 0) {
                        this.entropyModel.GaussianCova[i][j][k2][k2] = 0.1;
                    }
                    if (j != 1) continue;
                    this.entropyModel.GaussianCova[i][j][k2][k2] = 0.2;
                }
            }
        }
        for (k = 0; k < this.entropyModel.numGaussianMixtureComponents; ++k) {
            this.entropyModel.GaussianMu[0][k][0] = 2.3;
            this.entropyModel.GaussianMu[1][k][0] = 1.3;
            this.entropyModel.GaussianMu[2][k][0] = 1.3;
            this.entropyModel.GaussianMu[3][k][0] = 1.5;
            this.entropyModel.GaussianMu[0][k][1] = 0.2;
            this.entropyModel.GaussianMu[1][k][1] = 0.05;
            this.entropyModel.GaussianMu[2][k][1] = 0.2;
            this.entropyModel.GaussianMu[3][k][1] = 0.4;
        }
        this.entropyModel.prepareModelForAlgorithms();
    }

    public double[][] normalise(double[][] matrix) {
        double[][] res = new double[matrix.length][matrix[0].length];
        for (int i = 0; i < res.length; ++i) {
            int j;
            double sum = 0.0;
            for (j = 0; j < res[0].length; ++j) {
                if (matrix[i][j] <= 0.0) {
                    res[i][j] = 1.0E-4;
                } else if (matrix[i][j] > 0.0) {
                    res[i][j] = matrix[i][j];
                }
                sum += res[i][j];
            }
            j = 0;
            while (j < res[0].length) {
                double[] dArray = res[i];
                int n = j++;
                dArray[n] = dArray[n] / sum;
            }
        }
        return res;
    }

    public void normaliseEntropyModel() {
        this.entropyModel.a = this.normalise(this.entropyModel.a);
        this.entropyModel.b = this.normalise(this.entropyModel.b);
    }

    public void printModel(String filePath, Model model) {
        BufferedWriter outGeneralModel = null;
        try {
            int j;
            int i;
            outGeneralModel = new BufferedWriter(new FileWriter(filePath));
            if (debug) {
                System.out.println("########### GENERAL HMM MATRICES ##################");
            }
            outGeneralModel.write("INITIAL PROBABILITIES VECTOR\n");
            outGeneralModel.write("\t");
            for (i = 0; i < model.pi.length; ++i) {
                outGeneralModel.write(String.valueOf(String.valueOf(model.labels[i])).concat("\t"));
            }
            outGeneralModel.write("\n\t");
            for (i = 0; i < model.pi.length; ++i) {
                if (debug) {
                    System.out.print(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(model.labels[i]))).append(": ").append(model.pi[i]).append(" "))));
                }
                outGeneralModel.write(String.valueOf(String.valueOf(model.pi[i])).concat("\t"));
            }
            if (debug) {
                System.out.println();
                System.out.println("OBSERVATION MATRIX");
            }
            if (!model.hasContinuousObs) {
                outGeneralModel.write("\nOBSERVATION MATRIX\n\t");
                for (int j2 = 0; j2 < model.b[0].length; ++j2) {
                    outGeneralModel.write(String.valueOf(String.valueOf(model.symbols[j2])).concat("\t"));
                }
                outGeneralModel.write("\n");
                for (i = 0; i < model.b.length; ++i) {
                    outGeneralModel.write(String.valueOf(String.valueOf(model.labels[i])).concat("\t"));
                    if (debug) {
                        System.out.print(String.valueOf(String.valueOf(model.labels[i])).concat(": "));
                    }
                    for (j = 0; j < model.b[0].length; ++j) {
                        if (debug) {
                            System.out.print(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(model.symbols[j]))).append(":").append(model.b[i][j]).append(" "))));
                        }
                        outGeneralModel.write(String.valueOf(String.valueOf(model.b[i][j])).concat("\t"));
                    }
                    if (debug) {
                        System.out.println();
                    }
                    outGeneralModel.write("\n");
                }
                if (debug) {
                    System.out.println();
                }
                outGeneralModel.write("\n");
            } else if (model.hasContinuousObs) {
                int i2;
                int k;
                outGeneralModel.write("\nWEIGHT VECTOR\n\t");
                for (i = 0; i < model.numGaussianMixtureComponents; ++i) {
                    outGeneralModel.write(String.valueOf(String.valueOf(i)).concat("\t"));
                }
                outGeneralModel.write("\n");
                for (i = 0; i < model.num_states; ++i) {
                    outGeneralModel.write(String.valueOf(String.valueOf(model.labels[i])).concat("\t"));
                    for (j = 0; j < model.numGaussianMixtureComponents; ++j) {
                        outGeneralModel.write(String.valueOf(String.valueOf(model.GaussianWeights[i][j])).concat("\t"));
                    }
                    outGeneralModel.write("\n");
                }
                outGeneralModel.write("\n");
                outGeneralModel.write("\nGAUSSIAN MEANS\n");
                for (i = 0; i < model.numGaussianMixtureComponents; ++i) {
                    outGeneralModel.write(String.valueOf(String.valueOf(new StringBuffer("gaussian#").append(i).append("\t"))));
                    for (j = 0; j < model.dimensionOfData; ++j) {
                        outGeneralModel.write(String.valueOf(String.valueOf(j)).concat("\t"));
                    }
                }
                outGeneralModel.write("\n");
                for (k = 0; k < model.num_states; ++k) {
                    outGeneralModel.write(String.valueOf(String.valueOf(model.labels[k])).concat("\t"));
                    for (i2 = 0; i2 < model.numGaussianMixtureComponents; ++i2) {
                        for (int j3 = 0; j3 < model.dimensionOfData; ++j3) {
                            outGeneralModel.write(String.valueOf(String.valueOf(model.GaussianMu[k][i2][j3])).concat("\t"));
                        }
                        outGeneralModel.write("\t");
                    }
                    outGeneralModel.write("\n");
                }
                outGeneralModel.write("\nGAUSSIAN COVARIANCES\n");
                for (k = 0; k < model.numGaussianMixtureComponents; ++k) {
                    outGeneralModel.write("Gaussian#".concat(String.valueOf(String.valueOf(k))));
                    for (i2 = 0; i2 < model.dimensionOfData; ++i2) {
                        outGeneralModel.write("\t");
                    }
                    outGeneralModel.write("\t");
                }
                outGeneralModel.write("\n");
                for (i = 0; i < model.num_states; ++i) {
                    outGeneralModel.write(model.labels[i]);
                    for (j = 0; j < model.dimensionOfData; ++j) {
                        outGeneralModel.write("\t");
                        for (int k2 = 0; k2 < model.numGaussianMixtureComponents; ++k2) {
                            for (int l = 0; l < model.dimensionOfData; ++l) {
                                outGeneralModel.write(String.valueOf(String.valueOf(model.GaussianCova[i][k2][j][l])).concat("\t"));
                            }
                            outGeneralModel.write("\t");
                        }
                        outGeneralModel.write("\n");
                    }
                }
            }
            if (debug) {
                System.out.println("TRANSITION MATRIX");
            }
            outGeneralModel.write("TRANSITION MATRIX\n\t");
            for (i = 0; i < model.a.length; ++i) {
                outGeneralModel.write(String.valueOf(String.valueOf(model.labels[i])).concat("\t"));
            }
            outGeneralModel.write("\n");
            for (i = 0; i < model.a.length; ++i) {
                outGeneralModel.write(String.valueOf(String.valueOf(model.labels[i])).concat("\t"));
                if (debug) {
                    System.out.print(String.valueOf(String.valueOf(new StringBuffer("FROM ").append(model.labels[i]).append(": "))));
                }
                for (j = 0; j < model.a.length; ++j) {
                    if (debug) {
                        System.out.print(String.valueOf(String.valueOf(new StringBuffer("TO ").append(model.labels[j]).append(":").append(model.a[i][j]).append(" "))));
                    }
                    outGeneralModel.write(String.valueOf(String.valueOf(model.a[i][j])).concat("\t"));
                }
                if (debug) {
                    System.out.println();
                }
                outGeneralModel.write("\n");
            }
            outGeneralModel.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static LinkedHashMap filterAlignment(LinkedHashMap alignment, ArrayList filteringIndexes) {
        LinkedHashMap<String, String> newAli = new LinkedHashMap<String, String>();
        Iterator iterat = ((HashMap)alignment).keySet().iterator();
        String newseq = "";
        String name = "";
        String seq = "";
        while (iterat.hasNext()) {
            name = (String)iterat.next();
            seq = (String)alignment.get(name);
            newseq = "";
            for (int k = 0; k < seq.length(); ++k) {
                if (!filteringIndexes.contains(new Integer(k))) continue;
                newseq = String.valueOf(String.valueOf(newseq)).concat(String.valueOf(String.valueOf(seq.substring(k, k + 1))));
            }
            newAli.put(name, newseq);
        }
        return newAli;
    }

    public void buildProfileHMM() {
        int i;
        int i2;
        int i3;
        int i4;
        this.numberSeqs = this.finalAliCol[0].length;
        this.indexes = new int[this.finalAliCol.length + 1];
        int runningIndex = 0;
        boolean samecol = true;
        for (int i5 = 0; i5 < this.startAliCol.length; ++i5) {
            if (runningIndex >= this.finalAliCol.length) continue;
            samecol = true;
            for (int k = 0; k < this.startAliCol[i5].length; ++k) {
                if (this.startAliCol[i5][k].equals(this.finalAliCol[runningIndex][k])) continue;
                samecol = false;
            }
            if (!samecol) continue;
            if (debug) {
                System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(runningIndex))).append(" ").append(i5))));
            }
            this.indexes[runningIndex] = i5;
            ++runningIndex;
        }
        this.indexes[this.finalAliCol.length] = this.startAliCol.length;
        ArrayList<double[]> freqsInInsertedStates = new ArrayList<double[]>();
        double[] freq = new double[aminoAcids.length - 1];
        ArrayList<Integer> positionsOfInsertionsStates = new ArrayList<Integer>();
        ArrayList allInsertionLengths = new ArrayList();
        ArrayList<Double> probasGoingToInsertionState = new ArrayList<Double>();
        double[][] proteinStateCounts = new double[this.finalAliCol.length][aminoAcids.length - 1];
        for (i4 = 0; i4 < proteinStateCounts.length; ++i4) {
            double sum = 0.0;
            for (int j = 0; j < this.getNumLearningSeqs(); ++j) {
                if (this.startAliCol[this.indexes[i4]][j].equals("-")) continue;
                double[] dArray = proteinStateCounts[i4];
                int n = (Integer)aminoAcidsInverse.get(this.startAliCol[this.indexes[i4]][j]);
                dArray[n] = dArray[n] + 1.0;
                sum += 1.0;
            }
            int k = 0;
            while (k < proteinStateCounts[i4].length) {
                double[] dArray = proteinStateCounts[i4];
                int n = k++;
                dArray[n] = dArray[n] / sum;
            }
        }
        for (i4 = 0; i4 < this.finalAliCol.length; ++i4) {
            if (this.indexes[i4 + 1] - this.indexes[i4] <= 1) continue;
            ArrayList<Double> insertionLengths = new ArrayList<Double>();
            freq = new double[aminoAcids.length - 1];
            double sum = 0.0;
            double proba = 0.0;
            for (int j = 0; j < this.startAliCol[0].length; ++j) {
                double len = 0.0;
                double p = 0.0;
                for (int k = this.indexes[i4] + 1; k < this.indexes[i4 + 1]; ++k) {
                    if (this.startAliCol[k][j].equals("-")) continue;
                    int n = (Integer)aminoAcidsInverse.get(this.startAliCol[k][j]);
                    freq[n] = freq[n] + 1.0;
                    sum += 1.0;
                    len += 1.0;
                    p = 1.0;
                }
                proba += p;
                insertionLengths.add(new Double(len));
            }
            proba /= new Double(this.startAliCol[0].length).doubleValue();
            int r = 0;
            while (r < freq.length) {
                int n = r++;
                freq[n] = freq[n] / sum;
            }
            probasGoingToInsertionState.add(new Double(proba));
            freqsInInsertedStates.add(freq);
            allInsertionLengths.add(insertionLengths);
            positionsOfInsertionsStates.add(new Integer(i4));
        }
        ArrayList<Double> averageInsertionLengths = new ArrayList<Double>();
        for (int k = 0; k < allInsertionLengths.size(); ++k) {
            ArrayList ail = (ArrayList)allInsertionLengths.get(k);
            double avg = 0.0;
            for (int i6 = 0; i6 < ail.size(); ++i6) {
                double len = (Double)ail.get(i6);
                avg += len;
            }
            averageInsertionLengths.add(new Double(avg / (double)ail.size()));
        }
        if (debug) {
            for (i3 = 0; i3 < averageInsertionLengths.size(); ++i3) {
                System.out.println(String.valueOf(String.valueOf(new StringBuffer("probability of entering insertion state ").append(i3).append(" ").append((Double)probasGoingToInsertionState.get(i3)))));
                System.out.println("averageInsertionLengths:".concat(String.valueOf(String.valueOf((Double)averageInsertionLengths.get(i3)))));
                double[] al = (double[])freqsInInsertedStates.get(i3);
                for (int j = 0; j < al.length; ++j) {
                    System.out.print(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(aminoAcids[j]))).append(":").append(al[j]).append(" "))));
                }
                System.out.println();
                System.out.println(i3);
            }
        }
        if (debug) {
            for (i3 = 0; i3 < proteinStateCounts.length; ++i3) {
                System.out.print(String.valueOf(String.valueOf(i3)).concat(": "));
                for (int j = 0; j < proteinStateCounts[i3].length; ++j) {
                    System.out.print(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(aminoAcids[j]))).append(":").append(proteinStateCounts[i3][j]).append(" "))));
                }
                System.out.println();
            }
        }
        for (i3 = 0; i3 < averageInsertionLengths.size(); ++i3) {
            if (!((Double)averageInsertionLengths.get(i3) < AvgLengthThresholdForInsertionState)) continue;
            allInsertionLengths.remove(i3);
            averageInsertionLengths.remove(i3);
            freqsInInsertedStates.remove(i3);
            positionsOfInsertionsStates.remove(i3);
            probasGoingToInsertionState.remove(i3);
        }
        int numprotstates = this.finalAliCol.length;
        this.proteinModel = new Model();
        this.proteinModel.num_symbols = aminoAcids.length;
        this.proteinModel.num_states = numprotstates + freqsInInsertedStates.size() + 2;
        this.proteinModel.a = new double[this.proteinModel.num_states][this.proteinModel.num_states];
        this.proteinModel.b = new double[this.proteinModel.num_states][this.proteinModel.num_symbols];
        this.proteinModel.pi = new double[this.proteinModel.num_states];
        this.proteinModel.pi[0] = 1.0;
        for (i2 = 0; i2 < numprotstates; ++i2) {
            for (int j = 0; j < proteinStateCounts[0].length; ++j) {
                this.proteinModel.b[i2][j] = proteinStateCounts[i2][j];
            }
        }
        for (i2 = 0; i2 < freqsInInsertedStates.size(); ++i2) {
            freq = (double[])freqsInInsertedStates.get(i2);
            for (int j = 0; j < freq.length; ++j) {
                this.proteinModel.b[i2 + numprotstates][j] = freq[j];
            }
        }
        for (int j = 0; j < this.proteinModel.b[0].length; ++j) {
            this.proteinModel.b[this.proteinModel.num_states - 2][j] = freqRandomVertebrateAminoAcids[j];
            this.proteinModel.b[this.proteinModel.num_states - 1][this.proteinModel.b[0].length - 1] = 1.0;
        }
        int count1 = 0;
        for (int i7 = 0; i7 < numprotstates - 1; ++i7) {
            int indexinsertion = (Integer)positionsOfInsertionsStates.get(count1);
            if (i7 == indexinsertion) {
                double p;
                this.proteinModel.a[i7][numprotstates + count1] = p = ((Double)probasGoingToInsertionState.get(count1)).doubleValue();
                this.proteinModel.a[i7][i7 + 1] = 1.0 - p;
                ++count1;
                continue;
            }
            this.proteinModel.a[i7][i7 + 1] = 1.0;
        }
        double avg = 0.0;
        int indexinsertion = -1;
        for (i = 0; i < averageInsertionLengths.size(); ++i) {
            avg = (Double)averageInsertionLengths.get(i);
            this.proteinModel.a[numprotstates + i][numprotstates + i] = avg / (1.0 + avg);
            indexinsertion = (Integer)positionsOfInsertionsStates.get(i);
            this.proteinModel.a[numprotstates + i][indexinsertion + 1] = 1.0 / (1.0 + avg);
        }
        this.proteinModel.labels = new String[this.proteinModel.a.length];
        for (i = 0; i < numprotstates; ++i) {
            this.proteinModel.labels[i] = "M".concat(String.valueOf(String.valueOf(i)));
        }
        for (i = 0; i < averageInsertionLengths.size(); ++i) {
            this.proteinModel.labels[i + numprotstates] = "I".concat(String.valueOf(String.valueOf(i)));
        }
        this.proteinModel.labels[numprotstates + averageInsertionLengths.size()] = "RANDOM";
        this.proteinModel.labels[numprotstates + averageInsertionLengths.size() + 1] = "STOP";
        this.proteinModel.symbols = aminoAcids;
    }

    public static String[][] returnAlignmentByColumns(LinkedHashMap alignmnent) {
        Iterator iterat = ((HashMap)alignmnent).keySet().iterator();
        int numseqs = alignmnent.size();
        String name = (String)iterat.next();
        String seq = (String)alignmnent.get(name);
        int len = seq.length();
        String[][] res = new String[len][numseqs];
        iterat = ((HashMap)alignmnent).keySet().iterator();
        int seqCompteur = 0;
        while (iterat.hasNext()) {
            name = (String)iterat.next();
            seq = (String)alignmnent.get(name);
            for (int i = 0; i < seq.length(); ++i) {
                res[i][seqCompteur] = seq.substring(i, i + 1);
            }
            ++seqCompteur;
        }
        return res;
    }

    public static void printAlignment(LinkedHashMap alignment) {
        Set kset = ((HashMap)alignment).keySet();
        Iterator iterat = kset.iterator();
        int numbergenes = kset.size();
        boolean alisize = false;
        while (iterat.hasNext()) {
            String name = (String)iterat.next();
            String seq = (String)alignment.get(name);
            System.out.print(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(name))).append(" ").append(seq).append("\n"))));
        }
        System.out.print("\n\n");
    }

    private void setNumLearningSeqs(int len) {
        this.numLearningSeqs = len;
    }

    private int getNumLearningSeqs() {
        return this.numLearningSeqs;
    }

    static {
        filename = "D:/GPCRs/trees/trees_Feb_March2013/Sate/satejob5.marker001.secretinR_paper.aln";
        entropyValues = "D:/GPCRs/GPCR_modeling/entropy_values.txt";
        newAliFile = "D:/GPCRs/trees/trees_Feb_March2013/Sate/satejob5.marker001.secretinR_paper_intermediate.aln";
        finalAliFile = "D:/GPCRs/trees/trees_Feb_March2013/Sate/satejob5.marker001.secretinR_paper_final.aln";
        AvgLengthThresholdForInsertionState = 0.2;
        entropyScoreAlphabet = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "21"};
        entropyStatesLabels = new String[]{"L", "H"};
        mimimumProba = 1.0E-4;
        convergenceThreshold = 1.0;
        maxiters = 150.0;
        thresholdGapPercentage = 0.2;
        debug = false;
    }
}

