/*
 * Decompiled with CFR 0.152.
 */
package trimali;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Pattern;

public class SimilarityMatrix {
    private static String residues;
    public double[][] currentSimilarityMatrix;
    public static String[] aminoAcids;
    public static HashMap symbolsMap;
    public static double[][] blosum50;

    public SimilarityMatrix() {
        residues = "ARNDCQEGHILKMFPSTWYV";
    }

    public double[][] getSimilarityMatrix() {
        return this.currentSimilarityMatrix;
    }

    public void setSimilarityMatrix(double[][] matrix) {
        this.currentSimilarityMatrix = matrix;
    }

    public String getResidues() {
        return residues;
    }

    public void readMatrixFromFile(String filename) {
        symbolsMap = new HashMap(aminoAcids.length);
        for (int i = 0; i < aminoAcids.length; ++i) {
            symbolsMap.put(aminoAcids[i], new Integer(i));
        }
        double[][] result = null;
        double[][] result2 = null;
        BufferedReader in = null;
        String[] arrayAminoAcids = null;
        Pattern pattern = Pattern.compile("\\s+");
        try {
            in = new BufferedReader(new FileReader(filename));
            String line = in.readLine();
            int indexline = 0;
            while (line != null) {
                int i;
                String[] splits = pattern.split(line);
                ArrayList<String> alsplits = new ArrayList<String>();
                for (i = 0; i < splits.length; ++i) {
                    if (splits[i].equals("")) continue;
                    alsplits.add(splits[i]);
                }
                splits = new String[alsplits.size()];
                for (i = 0; i < splits.length; ++i) {
                    splits[i] = (String)alsplits.get(i);
                }
                if (indexline == 0) {
                    result = new double[splits.length][splits.length];
                    arrayAminoAcids = new String[splits.length];
                    for (i = 0; i < splits.length; ++i) {
                        arrayAminoAcids[i] = splits[i];
                    }
                } else if (indexline > 0) {
                    for (i = 1; i < splits.length; ++i) {
                        result[indexline - 1][i - 1] = new Double(splits[i]);
                    }
                }
                ++indexline;
                line = in.readLine();
            }
            HashMap map = symbolsMap;
            result2 = new double[result.length][result.length];
            for (int i = 0; i < result.length; ++i) {
                for (int j = 0; j < result.length; ++j) {
                    int newi = (Integer)map.get(arrayAminoAcids[i]);
                    int newj = (Integer)map.get(arrayAminoAcids[j]);
                    result2[newi][newj] = result[i][j];
                }
            }
            in.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.setSimilarityMatrix(result2);
    }

    public void completeSubstitutionMatrix() {
        int length = this.currentSimilarityMatrix.length;
        double[][] fullMat = new double[length][length];
        for (int i = 0; i < length; ++i) {
            for (int j = 0; j < length; ++j) {
                fullMat[i][j] = i < j ? this.currentSimilarityMatrix[j][i] : this.currentSimilarityMatrix[i][j];
            }
        }
        this.currentSimilarityMatrix = fullMat;
    }

    public static void main(String[] args) {
        int i;
        SimilarityMatrix simmat = new SimilarityMatrix();
        simmat.readMatrixFromFile("D:/PEPTIDE_HORMONES/BLOSUM62.txt");
        simmat.writeBlosumForPython("D:/PEPTIDE_HORMONES/BLOSUM62_python.txt");
        simmat.karlinlikeNormalisation();
        double[][] matrix = simmat.getSimilarityMatrix();
        System.out.print("   ");
        for (i = 0; i < matrix.length; ++i) {
            System.out.print(String.valueOf(String.valueOf(residues.substring(i, i + 1))).concat("    "));
        }
        System.out.println();
        for (i = 0; i < matrix.length; ++i) {
            System.out.print(String.valueOf(String.valueOf(residues.substring(i, i + 1))).concat(" "));
            double sum = 0.0;
            for (int j = 0; j < matrix[i].length; ++j) {
                System.out.print(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(residues.substring(j, j + 1)))).append(" ").append(matrix[i][j]).append(" "))));
                sum += matrix[i][j];
            }
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("SUM:").append(residues.substring(i, i + 1)).append(" ").append(sum))));
            System.out.println();
        }
    }

    public void normaliseBlosum() {
        double[][] matrix = this.currentSimilarityMatrix;
        int l = matrix.length;
        double[][] normMatrix = new double[l][];
        for (int i = 0; i < l; ++i) {
            int j;
            int c = matrix[i].length;
            normMatrix[i] = new double[c];
            double max = 0.0;
            double min = 0.0;
            for (j = 0; j < c; ++j) {
                max = Math.max(max, matrix[i][j]);
                min = Math.min(min, matrix[i][j]);
            }
            for (j = 0; j < c; ++j) {
                normMatrix[i][j] = (matrix[i][j] - min) / (max - min);
            }
        }
        this.setSimilarityMatrix(normMatrix);
    }

    public void normaliseBlosum2() {
        int c;
        int i;
        double[][] matrix = this.getSimilarityMatrix();
        int l = matrix.length;
        double[][] normMatrix = new double[l][];
        double[][] result = new double[l][];
        for (i = 0; i < l; ++i) {
            int j;
            c = matrix[i].length;
            normMatrix[i] = new double[c];
            result[i] = new double[c];
            double min = 0.0;
            double sum = 0.0;
            for (j = 0; j < c; ++j) {
                min = Math.min(min, matrix[i][j]);
            }
            for (j = 0; j < c; ++j) {
                sum += (matrix[i][j] - min) * (matrix[i][j] - min);
            }
            for (j = 0; j < c; ++j) {
                normMatrix[i][j] = (matrix[i][j] - min) / Math.sqrt(sum);
            }
        }
        for (i = 0; i < l; ++i) {
            c = matrix[i].length;
            for (int k = 0; k < l; ++k) {
                for (int j = 0; j < c; ++j) {
                    double[] dArray = result[i];
                    int n = k;
                    dArray[n] = dArray[n] + normMatrix[i][j] * normMatrix[k][j];
                }
            }
        }
        this.setSimilarityMatrix(result);
    }

    public void karlinlikeNormalisation() {
        double[][] matrix = this.getSimilarityMatrix();
        double[][] result = new double[matrix.length][];
        double[][] result2 = new double[matrix.length][];
        for (int i = 0; i < matrix.length; ++i) {
            int j;
            result[i] = new double[matrix[i].length];
            result2[i] = new double[matrix[i].length];
            for (int j2 = 0; j2 < matrix[i].length; ++j2) {
                result[i][j2] = matrix[i][j2] / Math.sqrt(matrix[i][i] * matrix[j2][j2]);
            }
            double max = 0.0;
            double min = 0.0;
            for (j = 0; j < matrix[i].length; ++j) {
                max = Math.max(max, result[i][j]);
                min = Math.min(min, result[i][j]);
            }
            for (j = 0; j < matrix[i].length; ++j) {
                result2[i][j] = (result[i][j] - min) / (max - min);
            }
        }
        this.setSimilarityMatrix(result2);
    }

    public void writeBlosumForPython(String fileName) {
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new PrintWriter(new FileWriter(fileName)));
            out.write("[");
            for (int i = 0; i < this.currentSimilarityMatrix.length; ++i) {
                out.write("[");
                for (int j = 0; j < i + 1; ++j) {
                    if (j != 0) {
                        out.write(",".concat(String.valueOf(String.valueOf(new Double(this.currentSimilarityMatrix[i][j]).intValue()))));
                        continue;
                    }
                    out.write("".concat(String.valueOf(String.valueOf(new Double(this.currentSimilarityMatrix[i][j]).intValue()))));
                }
                out.write("],");
            }
            out.write("]");
            out.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    static {
        aminoAcids = new String[]{"A", "R", "N", "D", "C", "Q", "E", "G", "H", "I", "L", "K", "M", "F", "P", "S", "T", "W", "Y", "V", "Z"};
        blosum50 = new double[][]{{5.0}, {-2.0, 7.0}, {-1.0, -1.0, 7.0}, {-2.0, -2.0, 2.0, 8.0}, {-1.0, -4.0, -2.0, -4.0, 13.0}, {-1.0, 1.0, 0.0, 0.0, -3.0, 7.0}, {-1.0, 0.0, 0.0, 2.0, -3.0, 2.0, 6.0}, {0.0, -3.0, 0.0, -1.0, -3.0, -2.0, -3.0, 8.0}, {-2.0, 0.0, 1.0, -1.0, -3.0, 1.0, 0.0, -2.0, 10.0}, {-1.0, -4.0, -3.0, -4.0, -2.0, -3.0, -4.0, -4.0, -4.0, 5.0}, {-2.0, -3.0, -4.0, -4.0, -2.0, -2.0, -3.0, -4.0, -3.0, 2.0, 5.0}, {-1.0, 3.0, 0.0, -1.0, -3.0, 2.0, 1.0, -2.0, 0.0, -3.0, -3.0, 6.0}, {-1.0, -2.0, -2.0, -4.0, -2.0, 0.0, -2.0, -3.0, -1.0, 2.0, 3.0, -2.0, 7.0}, {-3.0, -3.0, -4.0, -5.0, -2.0, -4.0, -3.0, -4.0, -1.0, 0.0, 1.0, -4.0, 0.0, 8.0}, {-1.0, -3.0, -2.0, -1.0, -4.0, -1.0, -1.0, -2.0, -2.0, -3.0, -4.0, -1.0, -3.0, -4.0, 10.0}, {1.0, -1.0, 1.0, 0.0, -1.0, 0.0, -1.0, 0.0, -1.0, -3.0, -3.0, 0.0, -2.0, -3.0, -1.0, 5.0}, {0.0, -1.0, 0.0, -1.0, -1.0, -1.0, -1.0, -2.0, -2.0, -1.0, -1.0, -1.0, -1.0, -2.0, -1.0, 2.0, 5.0}, {-3.0, -3.0, -4.0, -5.0, -5.0, -1.0, -3.0, -3.0, -3.0, -3.0, -2.0, -3.0, -1.0, 1.0, -4.0, -4.0, -3.0, 15.0}, {-2.0, -1.0, -2.0, -3.0, -3.0, -1.0, -2.0, -3.0, 2.0, -1.0, -1.0, -2.0, 0.0, 4.0, -3.0, -2.0, -2.0, 2.0, 8.0}, {0.0, -3.0, -3.0, -4.0, -1.0, -3.0, -3.0, -4.0, -4.0, 4.0, 1.0, -3.0, 1.0, -1.0, -3.0, -2.0, 0.0, -3.0, -1.0, 5.0}};
    }
}

