/*
 * Decompiled with CFR 0.152.
 */
package trimali;

import com.stevesoft.pat.Regex;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.regex.Pattern;
import trimali.Model;
import trimali.SimilarityMatrix;

public class Util {
    public double[][] similarityMatrix;
    public static final String[] orgs = new String[]{"HUMAN", "MOUSE", "RAT", "DOG", "COW", "CHICKEN", "OPOSSUM", "FROG", "MEDAKA", "FUGU", "ZEBRAFISH", "TETRAODON", "STICKLEBACK"};
    public static final String HYDROPHOBIC = "hydro";
    public static final String TRANSMEMBRANE = "transmembrane";
    public static final String ANCHOR = "signal-anchor (type 2 transmem)";

    public static final TreeMap smooth(ArrayList values, double sigma, double numstep, boolean norm) {
        HashMap<Double, Double> res = new HashMap<Double, Double>();
        HashMap<Double, Double> res2 = new HashMap<Double, Double>();
        Collections.sort(values);
        double max = (Double)Collections.max(values);
        double min = (Double)Collections.min(values);
        double step = (max - min) / numstep;
        if (!norm) {
            min = 1.0;
            max = numstep;
            step = 1.0;
        }
        System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(min))).append(" ").append(max).append(" ").append(step).append(" ").append(numstep))));
        HashMap<Double, Double> u = new HashMap<Double, Double>();
        int r = 0;
        while ((double)r < numstep) {
            u.put(new Double(r), new Double(0.0));
            res.put(new Double(r), new Double(0.0));
            ++r;
        }
        double z = -1.0;
        int i = 0;
        int lasti = -1;
        for (int t = 0; t < values.size(); ++t) {
            double val = (Double)values.get(i);
            while (min + z * step <= val) {
                z += 1.0;
            }
            if (z < numstep) {
                u.put(new Double(z), new Double((Double)u.get(new Double(z)) + 1.0));
                lasti = i;
            } else {
                u.put(new Double(numstep - 1.0), new Double(values.size() - lasti));
            }
            ++i;
        }
        double total = 0.0;
        int t = 0;
        while ((double)t < numstep) {
            res.put(new Double(t), new Double(0.0));
            int r2 = 0;
            while ((double)r2 < numstep) {
                double value = (Double)res.get(new Double(t)) + (Double)u.get(new Double(r2)) * Util.gaussianKernel(sigma, t, r2);
                res.put(new Double(t), new Double(value));
                ++r2;
            }
            total += ((Double)res.get(new Double(t))).doubleValue();
            ++t;
        }
        t = 0;
        while ((double)t < numstep) {
            res.put(new Double(t), new Double((Double)res.get(new Double(t)) / total));
            ++t;
        }
        if (norm) {
            t = 0;
            while ((double)t < numstep) {
                res2.put(new Double(new Double(t + 1) / numstep), (Double)res.get(new Double(t)));
                ++t;
            }
        } else if (!norm) {
            t = 0;
            while ((double)t < numstep) {
                res2.put(new Double(new Double(t + 1)), (Double)res.get(new Double(t)));
                ++t;
            }
        }
        TreeMap res3 = new TreeMap(res2);
        return res3;
    }

    public static double gaussianKernel(double sigma, double ax, double x0) {
        double result = 1.0 / (Math.sqrt(Math.PI * 2) * sigma) * Math.exp(-0.5 * (ax - x0) * (ax - x0) / (sigma * sigma));
        return result;
    }

    public void readSimilarityMatrix(String filename) {
        double[][] result = null;
        double[][] result2 = null;
        BufferedReader in = null;
        String[] arrayAminoAcids = null;
        Pattern pattern = Pattern.compile("\\s+");
        try {
            int i;
            in = new BufferedReader(new FileReader(filename));
            String line = in.readLine();
            int indexline = 0;
            while (line != null) {
                String[] splits = pattern.split(line);
                ArrayList<String> alsplits = new ArrayList<String>();
                for (i = 0; i < splits.length; ++i) {
                    if (splits[i].equals("")) continue;
                    alsplits.add(splits[i]);
                }
                splits = new String[alsplits.size()];
                for (i = 0; i < splits.length; ++i) {
                    splits[i] = (String)alsplits.get(i);
                }
                if (indexline == 0) {
                    result = new double[splits.length][splits.length];
                    arrayAminoAcids = new String[splits.length];
                    for (i = 0; i < splits.length; ++i) {
                        arrayAminoAcids[i] = splits[i];
                    }
                } else if (indexline > 0) {
                    for (i = 1; i < splits.length; ++i) {
                        result[indexline - 1][i - 1] = new Double(splits[i]);
                    }
                }
                ++indexline;
                line = in.readLine();
            }
            Model model = new Model();
            HashMap map = Model.symbolsMap;
            result2 = new double[result.length][result.length];
            for (i = 0; i < result.length; ++i) {
                for (int j = 0; j < result.length; ++j) {
                    int newi = (Integer)map.get(arrayAminoAcids[i]);
                    int newj = (Integer)map.get(arrayAminoAcids[j]);
                    result2[newi][newj] = result[i][j];
                }
            }
            in.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.setSimilarityMatrix(result2);
    }

    public void setSimilarityMatrix(double[][] simMat) {
        this.similarityMatrix = simMat;
    }

    public double[] computeConservationInertia(ArrayList multiAli) {
        SimilarityMatrix simmat = new SimilarityMatrix();
        simmat.setSimilarityMatrix(this.similarityMatrix);
        simmat.normaliseBlosum();
        simmat.normaliseBlosum2();
        double[][] normBlosum = simmat.getSimilarityMatrix();
        double[] conservation = new double[multiAli.size()];
        for (int i = 0; i < multiAli.size(); ++i) {
            int[] column = (int[])multiAli.get(i);
            double num = 0.0;
            double cons = 0.0;
            for (int j = 0; j < column.length; ++j) {
                int res1 = column[j];
                if (res1 >= 20) continue;
                for (int k = j + 1; k < column.length; ++k) {
                    int res2 = column[k];
                    if (res2 >= 20) continue;
                    cons = res1 < res2 ? (cons += normBlosum[res1][res2]) : (cons += normBlosum[res2][res1]);
                    num += 1.0;
                }
            }
            if (num != 0.0) {
                cons /= num;
            } else if (num == 0.0) {
                cons = 1.0;
            }
            conservation[i] = cons;
        }
        return conservation;
    }

    public static double computeAverage(ArrayList list) {
        double mean = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            mean += ((Double)list.get(i)).doubleValue();
        }
        return mean /= new Double(list.size()).doubleValue();
    }

    public static double computeVariance(ArrayList list) {
        double var = 0.0;
        double mean = Util.computeAverage(list);
        for (int i = 0; i < list.size(); ++i) {
            double val = (Double)list.get(i);
            var += (val - mean) * (val - mean);
        }
        return var /= new Double(list.size()).doubleValue();
    }

    public static double computeUnbiasedVariance(ArrayList list) {
        double n = new Double(list.size());
        return Util.computeVariance(list) * n / (n - 1.0);
    }

    public static String determineOrganism(String id) {
        Regex humanReg = new Regex("ENSP");
        Regex mouseReg = new Regex("ENSMUSP");
        Regex ratReg = new Regex("ENSRNOP");
        Regex chickenReg = new Regex("ENSGALP");
        Regex opossumReg = new Regex("ENSMODP");
        Regex frogReg = new Regex("ENSXETP");
        Regex fuguReg = new Regex("SINFRUP");
        Regex medakaReg = new Regex("ENSORLP");
        Regex stickleReg = new Regex("ENSGACP");
        Regex tetraodonReg = new Regex("GSTENP");
        Regex zebrafishReg = new Regex("ENSDARP");
        String res = "UNKNOWN";
        if (humanReg.search(id)) {
            res = "HUMAN";
        } else if (ratReg.search(id)) {
            res = "RAT";
        } else if (mouseReg.search(id)) {
            res = "MOUSE";
        } else if (opossumReg.search(id)) {
            res = "OPOSSUM";
        } else if (frogReg.search(id)) {
            res = "FROG";
        } else if (zebrafishReg.search(id)) {
            res = "ZEBRAFISH";
        } else if (stickleReg.search(id)) {
            res = "STICKLEBACK";
        } else if (fuguReg.search(id)) {
            res = "FUGU";
        } else if (medakaReg.search(id)) {
            res = "MEDAKA";
        } else if (tetraodonReg.search(id)) {
            res = "TETRAODON";
        }
        return res;
    }

    public static int checkLetter(String letter) {
        int result = 22;
        for (int i = 0; i < Model.aminoAcids.length; ++i) {
            if (!Model.aminoAcids[i].equals(letter)) continue;
            result = i;
        }
        return result;
    }

    public static double[][] normaliseMatrix(double[][] matrix) {
        int l = matrix.length;
        double[][] normMatrix = new double[l][];
        for (int i = 0; i < l; ++i) {
            int j;
            int c = matrix[i].length;
            normMatrix[i] = new double[c];
            double max = 0.0;
            for (j = 0; j < c; ++j) {
                max = Math.max(max, matrix[i][j]);
            }
            for (j = 0; j < c; ++j) {
                normMatrix[i][j] = matrix[i][j] / max;
            }
        }
        return normMatrix;
    }

    static {
        HYDROPHOBIC = HYDROPHOBIC;
        TRANSMEMBRANE = TRANSMEMBRANE;
        ANCHOR = ANCHOR;
    }
}

